/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class TypeBindings {
    private static final JavaType[] NO_TYPES = new JavaType[0];
    public static final JavaType UNBOUND = new SimpleType(Object.class);
    protected final TypeFactory _typeFactory;
    protected final JavaType _contextType;
    protected final Class _contextClass;
    protected Map _bindings;
    protected HashSet _placeholders;
    private final TypeBindings _parentBindings;

    public TypeBindings(TypeFactory typeFactory, Class clazz) {
        this(typeFactory, null, clazz, null);
    }

    public TypeBindings(TypeFactory typeFactory, JavaType javaType) {
        this(typeFactory, null, javaType.getRawClass(), javaType);
    }

    public TypeBindings childInstance() {
        return new TypeBindings(this._typeFactory, this, this._contextClass, this._contextType);
    }

    private TypeBindings(TypeFactory typeFactory, TypeBindings typeBindings, Class clazz, JavaType javaType) {
        this._typeFactory = typeFactory;
        this._parentBindings = typeBindings;
        this._contextClass = clazz;
        this._contextType = javaType;
    }

    public JavaType resolveType(Class clazz) {
        return this._typeFactory._constructType(clazz, this);
    }

    public JavaType resolveType(Type type) {
        return this._typeFactory._constructType(type, this);
    }

    public int getBindingCount() {
        if (this._bindings == null) {
            this._resolve();
        }
        return this._bindings.size();
    }

    public JavaType findType(String string) {
        Object object;
        JavaType javaType;
        if (this._bindings == null) {
            this._resolve();
        }
        if ((javaType = (JavaType)this._bindings.get(string)) != null) {
            return javaType;
        }
        if (this._placeholders != null && this._placeholders.contains(string)) {
            return UNBOUND;
        }
        if (this._parentBindings != null) {
            return this._parentBindings.findType(string);
        }
        if (this._contextClass != null && (object = this._contextClass.getEnclosingClass()) != null && !Modifier.isStatic(this._contextClass.getModifiers())) {
            return UNBOUND;
        }
        object = this._contextClass != null ? this._contextClass.getName() : (this._contextType != null ? this._contextType.toString() : "UNKNOWN");
        throw new IllegalArgumentException("Type variable '" + string + "' can not be resolved (with context of class " + (String)object + ")");
    }

    public void addBinding(String string, JavaType javaType) {
        if (this._bindings == null || this._bindings.size() == 0) {
            this._bindings = new LinkedHashMap();
        }
        this._bindings.put(string, javaType);
    }

    public JavaType[] typesAsArray() {
        if (this._bindings == null) {
            this._resolve();
        }
        if (this._bindings.size() == 0) {
            return NO_TYPES;
        }
        return this._bindings.values().toArray(new JavaType[this._bindings.size()]);
    }

    protected void _resolve() {
        int n2;
        this._resolveBindings(this._contextClass);
        if (this._contextType != null && (n2 = this._contextType.containedTypeCount()) > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = this._contextType.containedTypeName(i2);
                JavaType javaType = this._contextType.containedType(i2);
                this.addBinding(string, javaType);
            }
        }
        if (this._bindings == null) {
            this._bindings = Collections.emptyMap();
        }
    }

    public void _addPlaceholder(String string) {
        if (this._placeholders == null) {
            this._placeholders = new HashSet();
        }
        this._placeholders.add(string);
    }

    protected void _resolveBindings(Type type) {
        Class clazz;
        Object[] objectArray;
        Type[] typeArray;
        if (type == null) {
            return;
        }
        if (type instanceof ParameterizedType) {
            typeArray = (TypeVariable<Class<T>>[])type;
            objectArray = typeArray.getActualTypeArguments();
            if (objectArray != null && objectArray.length > 0) {
                Class clazz2 = (Class)typeArray.getRawType();
                TypeVariable<Class<T>>[] object2 = clazz2.getTypeParameters();
                if (object2.length != objectArray.length) {
                    throw new IllegalArgumentException("Strange parametrized type (in class " + clazz2.getName() + "): number of type arguments != number of type parameters (" + objectArray.length + " vs " + object2.length + ")");
                }
                int n2 = objectArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    TypeVariable typeVariable = object2[i2];
                    String string = typeVariable.getName();
                    if (this._bindings == null) {
                        this._bindings = new LinkedHashMap();
                    } else if (this._bindings.containsKey(string)) continue;
                    this._addPlaceholder(string);
                    this._bindings.put(string, this._typeFactory._constructType((Type)objectArray[i2], this));
                }
            }
            clazz = (Class)typeArray.getRawType();
        } else if (type instanceof Class) {
            clazz = (Class)type;
            this._resolveBindings(clazz.getDeclaringClass());
            typeArray = clazz.getTypeParameters();
            if (typeArray != null && typeArray.length > 0) {
                objectArray = null;
                if (this._contextType != null && clazz.isAssignableFrom(this._contextType.getRawClass())) {
                    objectArray = this._typeFactory.findTypeParameters(this._contextType, clazz);
                }
                for (int i3 = 0; i3 < typeArray.length; ++i3) {
                    Type type2 = typeArray[i3];
                    String string = type2.getName();
                    Type type3 = type2.getBounds()[0];
                    if (type3 == null) continue;
                    if (this._bindings == null) {
                        this._bindings = new LinkedHashMap();
                    } else if (this._bindings.containsKey(string)) continue;
                    this._addPlaceholder(string);
                    if (objectArray != null) {
                        this._bindings.put(string, objectArray[i3]);
                        continue;
                    }
                    this._bindings.put(string, this._typeFactory._constructType(type3, this));
                }
            }
        } else {
            return;
        }
        this._resolveBindings(clazz.getGenericSuperclass());
        for (Type type4 : clazz.getGenericInterfaces()) {
            this._resolveBindings(type4);
        }
    }

    public String toString() {
        if (this._bindings == null) {
            this._resolve();
        }
        StringBuilder stringBuilder = new StringBuilder("[TypeBindings for ");
        if (this._contextType != null) {
            stringBuilder.append(this._contextType.toString());
        } else {
            stringBuilder.append(this._contextClass.getName());
        }
        stringBuilder.append(": ").append(this._bindings).append("]");
        return stringBuilder.toString();
    }
}

