/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeBase;
import java.util.Collection;

public class CollectionLikeType
extends TypeBase {
    protected final JavaType _elementType;

    protected CollectionLikeType(Class clazz, JavaType javaType, Object object, Object object2) {
        super(clazz, javaType.hashCode(), object, object2);
        this._elementType = javaType;
    }

    protected JavaType _narrow(Class clazz) {
        return new CollectionLikeType(clazz, this._elementType, this._valueHandler, this._typeHandler);
    }

    public JavaType narrowContentsBy(Class clazz) {
        if (clazz == this._elementType.getRawClass()) {
            return this;
        }
        return new CollectionLikeType(this._class, this._elementType.narrowBy(clazz), this._valueHandler, this._typeHandler);
    }

    public JavaType widenContentsBy(Class clazz) {
        if (clazz == this._elementType.getRawClass()) {
            return this;
        }
        return new CollectionLikeType(this._class, this._elementType.widenBy(clazz), this._valueHandler, this._typeHandler);
    }

    public static CollectionLikeType construct(Class clazz, JavaType javaType) {
        return new CollectionLikeType(clazz, javaType, null, null);
    }

    public CollectionLikeType withTypeHandler(Object object) {
        return new CollectionLikeType(this._class, this._elementType, this._valueHandler, object);
    }

    public CollectionLikeType withContentTypeHandler(Object object) {
        return new CollectionLikeType(this._class, this._elementType.withTypeHandler(object), this._valueHandler, this._typeHandler);
    }

    public CollectionLikeType withValueHandler(Object object) {
        return new CollectionLikeType(this._class, this._elementType, object, this._typeHandler);
    }

    public CollectionLikeType withContentValueHandler(Object object) {
        return new CollectionLikeType(this._class, this._elementType.withValueHandler(object), this._valueHandler, this._typeHandler);
    }

    public boolean isContainerType() {
        return true;
    }

    public boolean isCollectionLikeType() {
        return true;
    }

    public JavaType getContentType() {
        return this._elementType;
    }

    public int containedTypeCount() {
        return 1;
    }

    public JavaType containedType(int n2) {
        return n2 == 0 ? this._elementType : null;
    }

    public String containedTypeName(int n2) {
        if (n2 == 0) {
            return "E";
        }
        return null;
    }

    public StringBuilder getErasedSignature(StringBuilder stringBuilder) {
        return CollectionLikeType._classSignature(this._class, stringBuilder, true);
    }

    public StringBuilder getGenericSignature(StringBuilder stringBuilder) {
        CollectionLikeType._classSignature(this._class, stringBuilder, false);
        stringBuilder.append('<');
        this._elementType.getGenericSignature(stringBuilder);
        stringBuilder.append(">;");
        return stringBuilder;
    }

    protected String buildCanonicalName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._class.getName());
        if (this._elementType != null) {
            stringBuilder.append('<');
            stringBuilder.append(this._elementType.toCanonical());
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }

    public boolean isTrueCollectionType() {
        return Collection.class.isAssignableFrom(this._class);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        CollectionLikeType collectionLikeType = (CollectionLikeType)object;
        return this._class == collectionLikeType._class && this._elementType.equals(collectionLikeType._elementType);
    }

    public String toString() {
        return "[collection-like type; class " + this._class.getName() + ", contains " + this._elementType + "]";
    }
}

