/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ContainerNode$NoNodesIterator;
import com.fasterxml.jackson.databind.node.ContainerNode$NoStringsIterator;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode$NoFieldsIterator;
import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ObjectNode
extends ContainerNode {
    protected LinkedHashMap _children = null;

    public ObjectNode(JsonNodeFactory jsonNodeFactory) {
        super(jsonNodeFactory);
    }

    protected ObjectNode(JsonNodeFactory jsonNodeFactory, LinkedHashMap linkedHashMap) {
        super(jsonNodeFactory);
        this._children = linkedHashMap;
    }

    public ObjectNode deepCopy() {
        if (this._children == null) {
            return new ObjectNode(this._nodeFactory);
        }
        int n2 = this._children.size();
        LinkedHashMap linkedHashMap = new LinkedHashMap(Math.max(4, n2));
        for (Map.Entry entry : this._children.entrySet()) {
            linkedHashMap.put(entry.getKey(), ((JsonNode)entry.getValue()).deepCopy());
        }
        return new ObjectNode(this._nodeFactory, linkedHashMap);
    }

    public JsonToken asToken() {
        return JsonToken.START_OBJECT;
    }

    public boolean isObject() {
        return true;
    }

    public int size() {
        return this._children == null ? 0 : this._children.size();
    }

    public Iterator elements() {
        return this._children == null ? ContainerNode$NoNodesIterator.instance() : this._children.values().iterator();
    }

    public JsonNode get(int n2) {
        return null;
    }

    public JsonNode get(String string) {
        if (this._children != null) {
            return (JsonNode)this._children.get(string);
        }
        return null;
    }

    public Iterator fieldNames() {
        return this._children == null ? ContainerNode$NoStringsIterator.instance() : this._children.keySet().iterator();
    }

    public JsonNode path(int n2) {
        return MissingNode.getInstance();
    }

    public JsonNode path(String string) {
        JsonNode jsonNode;
        if (this._children != null && (jsonNode = (JsonNode)this._children.get(string)) != null) {
            return jsonNode;
        }
        return MissingNode.getInstance();
    }

    public Iterator fields() {
        if (this._children == null) {
            return ObjectNode$NoFieldsIterator.instance;
        }
        return this._children.entrySet().iterator();
    }

    public ObjectNode with(String string) {
        JsonNode jsonNode;
        if (this._children == null) {
            this._children = new LinkedHashMap();
        } else {
            jsonNode = (JsonNode)this._children.get(string);
            if (jsonNode != null) {
                if (jsonNode instanceof ObjectNode) {
                    return (ObjectNode)jsonNode;
                }
                throw new UnsupportedOperationException("Property '" + string + "' has value that is not of type ObjectNode (but " + jsonNode.getClass().getName() + ")");
            }
        }
        jsonNode = this.objectNode();
        this._children.put(string, jsonNode);
        return jsonNode;
    }

    public ArrayNode withArray(String string) {
        JsonNode jsonNode;
        if (this._children == null) {
            this._children = new LinkedHashMap();
        } else {
            jsonNode = (JsonNode)this._children.get(string);
            if (jsonNode != null) {
                if (jsonNode instanceof ArrayNode) {
                    return (ArrayNode)jsonNode;
                }
                throw new UnsupportedOperationException("Property '" + string + "' has value that is not of type ArrayNode (but " + jsonNode.getClass().getName() + ")");
            }
        }
        jsonNode = this.arrayNode();
        this._children.put(string, jsonNode);
        return jsonNode;
    }

    public JsonNode findValue(String string) {
        if (this._children != null) {
            for (Map.Entry entry : this._children.entrySet()) {
                if (string.equals(entry.getKey())) {
                    return (JsonNode)entry.getValue();
                }
                JsonNode jsonNode = ((JsonNode)entry.getValue()).findValue(string);
                if (jsonNode == null) continue;
                return jsonNode;
            }
        }
        return null;
    }

    public List findValues(String string, List list) {
        if (this._children != null) {
            for (Map.Entry entry : this._children.entrySet()) {
                if (string.equals(entry.getKey())) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    list.add(entry.getValue());
                    continue;
                }
                list = ((JsonNode)entry.getValue()).findValues(string, list);
            }
        }
        return list;
    }

    public List findValuesAsText(String string, List list) {
        if (this._children != null) {
            for (Map.Entry entry : this._children.entrySet()) {
                if (string.equals(entry.getKey())) {
                    if (list == null) {
                        list = new ArrayList<String>();
                    }
                    list.add(((JsonNode)entry.getValue()).asText());
                    continue;
                }
                list = ((JsonNode)entry.getValue()).findValuesAsText(string, list);
            }
        }
        return list;
    }

    public ObjectNode findParent(String string) {
        if (this._children != null) {
            for (Map.Entry entry : this._children.entrySet()) {
                if (string.equals(entry.getKey())) {
                    return this;
                }
                JsonNode jsonNode = ((JsonNode)entry.getValue()).findParent(string);
                if (jsonNode == null) continue;
                return (ObjectNode)jsonNode;
            }
        }
        return null;
    }

    public List findParents(String string, List list) {
        if (this._children != null) {
            for (Map.Entry entry : this._children.entrySet()) {
                if (string.equals(entry.getKey())) {
                    if (list == null) {
                        list = new ArrayList<ObjectNode>();
                    }
                    list.add(this);
                    continue;
                }
                list = ((JsonNode)entry.getValue()).findParents(string, list);
            }
        }
        return list;
    }

    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        jsonGenerator.writeStartObject();
        if (this._children != null) {
            for (Map.Entry entry : this._children.entrySet()) {
                jsonGenerator.writeFieldName((String)entry.getKey());
                ((BaseJsonNode)entry.getValue()).serialize(jsonGenerator, serializerProvider);
            }
        }
        jsonGenerator.writeEndObject();
    }

    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        typeSerializer.writeTypePrefixForObject(this, jsonGenerator);
        if (this._children != null) {
            for (Map.Entry entry : this._children.entrySet()) {
                jsonGenerator.writeFieldName((String)entry.getKey());
                ((BaseJsonNode)entry.getValue()).serialize(jsonGenerator, serializerProvider);
            }
        }
        typeSerializer.writeTypeSuffixForObject(this, jsonGenerator);
    }

    public JsonNode put(String string, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        return this._put(string, jsonNode);
    }

    public JsonNode remove(String string) {
        if (this._children != null) {
            return (JsonNode)this._children.remove(string);
        }
        return null;
    }

    public ObjectNode remove(Collection collection) {
        if (this._children != null) {
            for (String string : collection) {
                this._children.remove(string);
            }
        }
        return this;
    }

    public ObjectNode removeAll() {
        this._children = null;
        return this;
    }

    public JsonNode putAll(Map map) {
        if (this._children == null) {
            this._children = new LinkedHashMap(map);
        } else {
            for (Map.Entry entry : map.entrySet()) {
                JsonNode jsonNode = (JsonNode)entry.getValue();
                if (jsonNode == null) {
                    jsonNode = this.nullNode();
                }
                this._children.put(entry.getKey(), jsonNode);
            }
        }
        return this;
    }

    public JsonNode putAll(ObjectNode objectNode) {
        int n2 = objectNode.size();
        if (n2 > 0) {
            if (this._children == null) {
                this._children = new LinkedHashMap(n2);
            }
            objectNode.putContentsTo(this._children);
        }
        return this;
    }

    public ObjectNode retain(Collection collection) {
        if (this._children != null) {
            Iterator iterator = this._children.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (collection.contains(entry.getKey())) continue;
                iterator.remove();
            }
        }
        return this;
    }

    public ObjectNode retain(String ... stringArray) {
        return this.retain(Arrays.asList(stringArray));
    }

    public ArrayNode putArray(String string) {
        ArrayNode arrayNode = this.arrayNode();
        this._put(string, arrayNode);
        return arrayNode;
    }

    public ObjectNode putObject(String string) {
        ObjectNode objectNode = this.objectNode();
        this._put(string, objectNode);
        return objectNode;
    }

    public ObjectNode putPOJO(String string, Object object) {
        this._put(string, this.POJONode(object));
        return this;
    }

    public ObjectNode putNull(String string) {
        this._put(string, this.nullNode());
        return this;
    }

    public ObjectNode put(String string, int n2) {
        this._put(string, this.numberNode(n2));
        return this;
    }

    public ObjectNode put(String string, Integer n2) {
        if (n2 == null) {
            this._put(string, this.nullNode());
        } else {
            this._put(string, this.numberNode(n2));
        }
        return this;
    }

    public ObjectNode put(String string, long l2) {
        this._put(string, this.numberNode(l2));
        return this;
    }

    public ObjectNode put(String string, Long l2) {
        if (l2 == null) {
            this._put(string, this.nullNode());
        } else {
            this._put(string, this.numberNode(l2));
        }
        return this;
    }

    public ObjectNode put(String string, float f2) {
        this._put(string, this.numberNode(f2));
        return this;
    }

    public ObjectNode put(String string, Float f2) {
        if (f2 == null) {
            this._put(string, this.nullNode());
        } else {
            this._put(string, this.numberNode(f2.floatValue()));
        }
        return this;
    }

    public ObjectNode put(String string, double d2) {
        this._put(string, this.numberNode(d2));
        return this;
    }

    public ObjectNode put(String string, Double d2) {
        if (d2 == null) {
            this._put(string, this.nullNode());
        } else {
            this._put(string, this.numberNode(d2));
        }
        return this;
    }

    public ObjectNode put(String string, BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.putNull(string);
        } else {
            this._put(string, this.numberNode(bigDecimal));
        }
        return this;
    }

    public ObjectNode put(String string, String string2) {
        if (string2 == null) {
            this.putNull(string);
        } else {
            this._put(string, this.textNode(string2));
        }
        return this;
    }

    public ObjectNode put(String string, boolean bl) {
        this._put(string, this.booleanNode(bl));
        return this;
    }

    public ObjectNode put(String string, Boolean bl) {
        if (bl == null) {
            this._put(string, this.nullNode());
        } else {
            this._put(string, this.booleanNode(bl));
        }
        return this;
    }

    public ObjectNode put(String string, byte[] byArray) {
        if (byArray == null) {
            this._put(string, this.nullNode());
        } else {
            this._put(string, this.binaryNode(byArray));
        }
        return this;
    }

    protected void putContentsTo(Map map) {
        if (this._children != null) {
            for (Map.Entry entry : this._children.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        ObjectNode objectNode = (ObjectNode)object;
        if (objectNode.size() != this.size()) {
            return false;
        }
        if (this._children != null) {
            for (Map.Entry entry : this._children.entrySet()) {
                String string = (String)entry.getKey();
                JsonNode jsonNode = (JsonNode)entry.getValue();
                JsonNode jsonNode2 = objectNode.get(string);
                if (jsonNode2 != null && jsonNode2.equals(jsonNode)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this._children == null ? -1 : this._children.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32 + (this.size() << 4));
        stringBuilder.append("{");
        if (this._children != null) {
            int n2 = 0;
            for (Map.Entry entry : this._children.entrySet()) {
                if (n2 > 0) {
                    stringBuilder.append(",");
                }
                ++n2;
                TextNode.appendQuoted(stringBuilder, (String)entry.getKey());
                stringBuilder.append(':');
                stringBuilder.append(((JsonNode)entry.getValue()).toString());
            }
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private final JsonNode _put(String string, JsonNode jsonNode) {
        if (this._children == null) {
            this._children = new LinkedHashMap();
        }
        return this._children.put(string, jsonNode);
    }
}

