/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.annotation.JsonAutoDetect$Visibility;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.BaseSettings;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfigBase;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.LinkedNode;
import java.text.DateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public final class DeserializationConfig
extends MapperConfigBase {
    protected final int _deserFeatures;
    protected final LinkedNode _problemHandlers;
    protected final JsonNodeFactory _nodeFactory;

    public DeserializationConfig(BaseSettings baseSettings, SubtypeResolver subtypeResolver, Map map) {
        super(baseSettings, subtypeResolver, map);
        this._deserFeatures = DeserializationConfig.collectFeatureDefaults(DeserializationFeature.class);
        this._nodeFactory = JsonNodeFactory.instance;
        this._problemHandlers = null;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, SubtypeResolver subtypeResolver) {
        super((MapperConfigBase)deserializationConfig, subtypeResolver);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._problemHandlers = deserializationConfig._problemHandlers;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, int n2, int n3) {
        super((MapperConfigBase)deserializationConfig, n2);
        this._deserFeatures = n3;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._problemHandlers = deserializationConfig._problemHandlers;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, BaseSettings baseSettings) {
        super((MapperConfigBase)deserializationConfig, baseSettings);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._problemHandlers = deserializationConfig._problemHandlers;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, JsonNodeFactory jsonNodeFactory) {
        super(deserializationConfig);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = jsonNodeFactory;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, LinkedNode linkedNode) {
        super(deserializationConfig);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = linkedNode;
        this._nodeFactory = deserializationConfig._nodeFactory;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, String string) {
        super((MapperConfigBase)deserializationConfig, string);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, Class clazz) {
        super((MapperConfigBase)deserializationConfig, clazz);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
    }

    public DeserializationConfig with(MapperFeature ... mapperFeatureArray) {
        int n2 = this._mapperFeatures;
        for (MapperFeature mapperFeature : mapperFeatureArray) {
            n2 |= mapperFeature.getMask();
        }
        return n2 == this._mapperFeatures ? this : new DeserializationConfig(this, n2, this._deserFeatures);
    }

    public DeserializationConfig without(MapperFeature ... mapperFeatureArray) {
        int n2 = this._mapperFeatures;
        for (MapperFeature mapperFeature : mapperFeatureArray) {
            n2 &= ~mapperFeature.getMask();
        }
        return n2 == this._mapperFeatures ? this : new DeserializationConfig(this, n2, this._deserFeatures);
    }

    public DeserializationConfig with(ClassIntrospector classIntrospector) {
        return this._withBase(this._base.withClassIntrospector(classIntrospector));
    }

    public DeserializationConfig with(AnnotationIntrospector annotationIntrospector) {
        return this._withBase(this._base.withAnnotationIntrospector(annotationIntrospector));
    }

    public DeserializationConfig with(VisibilityChecker visibilityChecker) {
        return this._withBase(this._base.withVisibilityChecker(visibilityChecker));
    }

    public DeserializationConfig withVisibility(PropertyAccessor propertyAccessor, JsonAutoDetect$Visibility visibility) {
        return this._withBase(this._base.withVisibility(propertyAccessor, visibility));
    }

    public DeserializationConfig with(TypeResolverBuilder typeResolverBuilder) {
        return this._withBase(this._base.withTypeResolverBuilder(typeResolverBuilder));
    }

    public DeserializationConfig with(SubtypeResolver subtypeResolver) {
        return this._subtypeResolver == subtypeResolver ? this : new DeserializationConfig(this, subtypeResolver);
    }

    public DeserializationConfig with(PropertyNamingStrategy propertyNamingStrategy) {
        return this._withBase(this._base.withPropertyNamingStrategy(propertyNamingStrategy));
    }

    public DeserializationConfig withRootName(String string) {
        if (string == null ? this._rootName == null : string.equals(this._rootName)) {
            return this;
        }
        return new DeserializationConfig(this, string);
    }

    public DeserializationConfig with(TypeFactory typeFactory) {
        return this._withBase(this._base.withTypeFactory(typeFactory));
    }

    public DeserializationConfig with(DateFormat dateFormat) {
        return this._withBase(this._base.withDateFormat(dateFormat));
    }

    public DeserializationConfig with(HandlerInstantiator handlerInstantiator) {
        return this._withBase(this._base.withHandlerInstantiator(handlerInstantiator));
    }

    public DeserializationConfig withInsertedAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        return this._withBase(this._base.withInsertedAnnotationIntrospector(annotationIntrospector));
    }

    public DeserializationConfig withAppendedAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        return this._withBase(this._base.withAppendedAnnotationIntrospector(annotationIntrospector));
    }

    public DeserializationConfig withView(Class clazz) {
        return this._view == clazz ? this : new DeserializationConfig(this, clazz);
    }

    public DeserializationConfig with(Locale locale) {
        return this._withBase(this._base.with(locale));
    }

    public DeserializationConfig with(TimeZone timeZone) {
        return this._withBase(this._base.with(timeZone));
    }

    private final DeserializationConfig _withBase(BaseSettings baseSettings) {
        return this._base == baseSettings ? this : new DeserializationConfig(this, baseSettings);
    }

    public DeserializationConfig with(JsonNodeFactory jsonNodeFactory) {
        if (this._nodeFactory == jsonNodeFactory) {
            return this;
        }
        return new DeserializationConfig(this, jsonNodeFactory);
    }

    public DeserializationConfig withHandler(DeserializationProblemHandler deserializationProblemHandler) {
        if (LinkedNode.contains(this._problemHandlers, deserializationProblemHandler)) {
            return this;
        }
        return new DeserializationConfig(this, new LinkedNode(deserializationProblemHandler, this._problemHandlers));
    }

    public DeserializationConfig withNoProblemHandlers() {
        if (this._problemHandlers == null) {
            return this;
        }
        return new DeserializationConfig(this, (LinkedNode)null);
    }

    public DeserializationConfig with(DeserializationFeature deserializationFeature) {
        int n2 = this._deserFeatures | deserializationFeature.getMask();
        return n2 == this._deserFeatures ? this : new DeserializationConfig(this, this._mapperFeatures, n2);
    }

    public DeserializationConfig with(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        int n2 = this._deserFeatures | deserializationFeature.getMask();
        for (DeserializationFeature deserializationFeature2 : deserializationFeatureArray) {
            n2 |= deserializationFeature2.getMask();
        }
        return n2 == this._deserFeatures ? this : new DeserializationConfig(this, this._mapperFeatures, n2);
    }

    public DeserializationConfig withFeatures(DeserializationFeature ... deserializationFeatureArray) {
        int n2 = this._deserFeatures;
        for (DeserializationFeature deserializationFeature : deserializationFeatureArray) {
            n2 |= deserializationFeature.getMask();
        }
        return n2 == this._deserFeatures ? this : new DeserializationConfig(this, this._mapperFeatures, n2);
    }

    public DeserializationConfig without(DeserializationFeature deserializationFeature) {
        int n2 = this._deserFeatures & ~deserializationFeature.getMask();
        return n2 == this._deserFeatures ? this : new DeserializationConfig(this, this._mapperFeatures, n2);
    }

    public DeserializationConfig without(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        int n2 = this._deserFeatures & ~deserializationFeature.getMask();
        for (DeserializationFeature deserializationFeature2 : deserializationFeatureArray) {
            n2 &= ~deserializationFeature2.getMask();
        }
        return n2 == this._deserFeatures ? this : new DeserializationConfig(this, this._mapperFeatures, n2);
    }

    public DeserializationConfig withoutFeatures(DeserializationFeature ... deserializationFeatureArray) {
        int n2 = this._deserFeatures;
        for (DeserializationFeature deserializationFeature : deserializationFeatureArray) {
            n2 &= ~deserializationFeature.getMask();
        }
        return n2 == this._deserFeatures ? this : new DeserializationConfig(this, this._mapperFeatures, n2);
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        if (this.isEnabled(MapperFeature.USE_ANNOTATIONS)) {
            return super.getAnnotationIntrospector();
        }
        return NopAnnotationIntrospector.instance;
    }

    public boolean useRootWrapping() {
        if (this._rootName != null) {
            return this._rootName.length() > 0;
        }
        return this.isEnabled(DeserializationFeature.UNWRAP_ROOT_VALUE);
    }

    public BeanDescription introspectClassAnnotations(JavaType javaType) {
        return this.getClassIntrospector().forClassAnnotations(this, javaType, this);
    }

    public BeanDescription introspectDirectClassAnnotations(JavaType javaType) {
        return this.getClassIntrospector().forDirectClassAnnotations(this, javaType, this);
    }

    public VisibilityChecker getDefaultVisibilityChecker() {
        VisibilityChecker visibilityChecker = super.getDefaultVisibilityChecker();
        if (!this.isEnabled(MapperFeature.AUTO_DETECT_SETTERS)) {
            visibilityChecker = visibilityChecker.withSetterVisibility(JsonAutoDetect$Visibility.NONE);
        }
        if (!this.isEnabled(MapperFeature.AUTO_DETECT_CREATORS)) {
            visibilityChecker = visibilityChecker.withCreatorVisibility(JsonAutoDetect$Visibility.NONE);
        }
        if (!this.isEnabled(MapperFeature.AUTO_DETECT_FIELDS)) {
            visibilityChecker = visibilityChecker.withFieldVisibility(JsonAutoDetect$Visibility.NONE);
        }
        return visibilityChecker;
    }

    public final boolean isEnabled(DeserializationFeature deserializationFeature) {
        return (this._deserFeatures & deserializationFeature.getMask()) != 0;
    }

    public final int getDeserializationFeatures() {
        return this._deserFeatures;
    }

    public LinkedNode getProblemHandlers() {
        return this._problemHandlers;
    }

    public Base64Variant getBase64Variant() {
        return Base64Variants.getDefaultVariant();
    }

    public final JsonNodeFactory getNodeFactory() {
        return this._nodeFactory;
    }

    public BeanDescription introspect(JavaType javaType) {
        return this.getClassIntrospector().forDeserialization(this, javaType, this);
    }

    public BeanDescription introspectForCreation(JavaType javaType) {
        return this.getClassIntrospector().forCreation(this, javaType, this);
    }

    public BeanDescription introspectForBuilder(JavaType javaType) {
        return this.getClassIntrospector().forDeserializationWithBuilder(this, javaType, this);
    }
}

