/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.TextBuffer;
import java.lang.ref.SoftReference;

public final class JsonStringEncoder {
    private static final char[] HEX_CHARS = CharTypes.copyHexChars();
    private static final byte[] HEX_BYTES = CharTypes.copyHexBytes();
    private static final int SURR1_FIRST = 55296;
    private static final int SURR1_LAST = 56319;
    private static final int SURR2_FIRST = 56320;
    private static final int SURR2_LAST = 57343;
    private static final int INT_BACKSLASH = 92;
    private static final int INT_U = 117;
    private static final int INT_0 = 48;
    protected static final ThreadLocal _threadEncoder = new ThreadLocal();
    protected TextBuffer _textBuffer;
    protected ByteArrayBuilder _byteBuilder;
    protected final char[] _quoteBuffer = new char[6];

    public JsonStringEncoder() {
        this._quoteBuffer[0] = 92;
        this._quoteBuffer[2] = 48;
        this._quoteBuffer[3] = 48;
    }

    public static JsonStringEncoder getInstance() {
        JsonStringEncoder jsonStringEncoder;
        SoftReference softReference = (SoftReference)_threadEncoder.get();
        JsonStringEncoder jsonStringEncoder2 = jsonStringEncoder = softReference == null ? null : (JsonStringEncoder)softReference.get();
        if (jsonStringEncoder == null) {
            jsonStringEncoder = new JsonStringEncoder();
            _threadEncoder.set(new SoftReference<JsonStringEncoder>(jsonStringEncoder));
        }
        return jsonStringEncoder;
    }

    public char[] quoteAsString(String string) {
        TextBuffer textBuffer = this._textBuffer;
        if (textBuffer == null) {
            this._textBuffer = textBuffer = new TextBuffer(null);
        }
        char[] cArray = textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = CharTypes.get7BitOutputEscapes();
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = string.length();
        int n5 = 0;
        block0: while (n3 < n4) {
            int n6;
            int n7;
            while ((n7 = string.charAt(n3)) >= n2 || nArray[n7] == 0) {
                if (n5 >= cArray.length) {
                    cArray = textBuffer.finishCurrentSegment();
                    n5 = 0;
                }
                cArray[n5++] = n7;
                if (++n3 < n4) continue;
                break block0;
            }
            if (n5 + (n6 = this._appendSingleEscape(n7 = nArray[string.charAt(n3++)], this._quoteBuffer)) > cArray.length) {
                int n8 = cArray.length - n5;
                if (n8 > 0) {
                    System.arraycopy(this._quoteBuffer, 0, cArray, n5, n8);
                }
                cArray = textBuffer.finishCurrentSegment();
                int n9 = n6 - n8;
                System.arraycopy(this._quoteBuffer, n8, cArray, 0, n9);
                n5 = n9;
                continue;
            }
            System.arraycopy(this._quoteBuffer, 0, cArray, n5, n6);
            n5 += n6;
        }
        textBuffer.setCurrentLength(n5);
        return textBuffer.contentsAsArray();
    }

    public byte[] quoteAsUTF8(String string) {
        ByteArrayBuilder byteArrayBuilder = this._byteBuilder;
        if (byteArrayBuilder == null) {
            this._byteBuilder = byteArrayBuilder = new ByteArrayBuilder(null);
        }
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        byte[] byArray = byteArrayBuilder.resetAndGetFirstSegment();
        block0: while (n2 < n3) {
            int n5;
            int[] nArray = CharTypes.get7BitOutputEscapes();
            while ((n5 = string.charAt(n2)) <= 127 && nArray[n5] == 0) {
                if (n4 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = 0;
                }
                byArray[n4++] = (byte)n5;
                if (++n2 < n3) continue;
                break block0;
            }
            if (n4 >= byArray.length) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n4 = 0;
            }
            if ((n5 = string.charAt(n2++)) <= 127) {
                int n6 = nArray[n5];
                n4 = this._appendByteEscape(n5, n6, byteArrayBuilder, n4);
                byArray = byteArrayBuilder.getCurrentSegment();
                continue;
            }
            if (n5 <= 2047) {
                byArray[n4++] = (byte)(0xC0 | n5 >> 6);
                n5 = 0x80 | n5 & 0x3F;
            } else if (n5 < 55296 || n5 > 57343) {
                byArray[n4++] = (byte)(0xE0 | n5 >> 12);
                if (n4 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = 0;
                }
                byArray[n4++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                n5 = 0x80 | n5 & 0x3F;
            } else {
                if (n5 > 56319) {
                    this._throwIllegalSurrogate(n5);
                }
                if (n2 >= n3) {
                    this._throwIllegalSurrogate(n5);
                }
                if ((n5 = this._convertSurrogate(n5, string.charAt(n2++))) > 0x10FFFF) {
                    this._throwIllegalSurrogate(n5);
                }
                byArray[n4++] = (byte)(0xF0 | n5 >> 18);
                if (n4 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = 0;
                }
                byArray[n4++] = (byte)(0x80 | n5 >> 12 & 0x3F);
                if (n4 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = 0;
                }
                byArray[n4++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                n5 = 0x80 | n5 & 0x3F;
            }
            if (n4 >= byArray.length) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n4 = 0;
            }
            byArray[n4++] = (byte)n5;
        }
        return this._byteBuilder.completeAndCoalesce(n4);
    }

    public byte[] encodeAsUTF8(String string) {
        ByteArrayBuilder byteArrayBuilder = this._byteBuilder;
        if (byteArrayBuilder == null) {
            this._byteBuilder = byteArrayBuilder = new ByteArrayBuilder(null);
        }
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        byte[] byArray = byteArrayBuilder.resetAndGetFirstSegment();
        int n5 = byArray.length;
        block0: while (n2 < n3) {
            int n6 = string.charAt(n2++);
            while (n6 <= 127) {
                if (n4 >= n5) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n5 = byArray.length;
                    n4 = 0;
                }
                byArray[n4++] = (byte)n6;
                if (n2 >= n3) break block0;
                n6 = string.charAt(n2++);
            }
            if (n4 >= n5) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n5 = byArray.length;
                n4 = 0;
            }
            if (n6 < 2048) {
                byArray[n4++] = (byte)(0xC0 | n6 >> 6);
            } else if (n6 < 55296 || n6 > 57343) {
                byArray[n4++] = (byte)(0xE0 | n6 >> 12);
                if (n4 >= n5) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n5 = byArray.length;
                    n4 = 0;
                }
                byArray[n4++] = (byte)(0x80 | n6 >> 6 & 0x3F);
            } else {
                if (n6 > 56319) {
                    this._throwIllegalSurrogate(n6);
                }
                if (n2 >= n3) {
                    this._throwIllegalSurrogate(n6);
                }
                if ((n6 = this._convertSurrogate(n6, string.charAt(n2++))) > 0x10FFFF) {
                    this._throwIllegalSurrogate(n6);
                }
                byArray[n4++] = (byte)(0xF0 | n6 >> 18);
                if (n4 >= n5) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n5 = byArray.length;
                    n4 = 0;
                }
                byArray[n4++] = (byte)(0x80 | n6 >> 12 & 0x3F);
                if (n4 >= n5) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n5 = byArray.length;
                    n4 = 0;
                }
                byArray[n4++] = (byte)(0x80 | n6 >> 6 & 0x3F);
            }
            if (n4 >= n5) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n5 = byArray.length;
                n4 = 0;
            }
            byArray[n4++] = (byte)(0x80 | n6 & 0x3F);
        }
        return this._byteBuilder.completeAndCoalesce(n4);
    }

    private int _appendSingleEscape(int n2, char[] cArray) {
        if (n2 < 0) {
            int n3 = -(n2 + 1);
            cArray[1] = 117;
            cArray[4] = HEX_CHARS[n3 >> 4];
            cArray[5] = HEX_CHARS[n3 & 0xF];
            return 6;
        }
        cArray[1] = (char)n2;
        return 2;
    }

    private int _appendByteEscape(int n2, int n3, ByteArrayBuilder byteArrayBuilder, int n4) {
        byteArrayBuilder.setCurrentSegmentLength(n4);
        byteArrayBuilder.append(92);
        if (n3 < 0) {
            byteArrayBuilder.append(117);
            if (n2 > 255) {
                int n5 = n2 >> 8;
                byteArrayBuilder.append(HEX_BYTES[n5 >> 4]);
                byteArrayBuilder.append(HEX_BYTES[n5 & 0xF]);
                n2 &= 0xFF;
            } else {
                byteArrayBuilder.append(48);
                byteArrayBuilder.append(48);
            }
            byteArrayBuilder.append(HEX_BYTES[n2 >> 4]);
            byteArrayBuilder.append(HEX_BYTES[n2 & 0xF]);
        } else {
            byteArrayBuilder.append((byte)n3);
        }
        return byteArrayBuilder.getCurrentSegmentLength();
    }

    private int _convertSurrogate(int n2, int n3) {
        if (n3 < 56320 || n3 > 57343) {
            throw new IllegalArgumentException("Broken surrogate pair: first char 0x" + Integer.toHexString(n2) + ", second 0x" + Integer.toHexString(n3) + "; illegal combination");
        }
        return 65536 + (n2 - 55296 << 10) + (n3 - 56320);
    }

    private void _throwIllegalSurrogate(int n2) {
        if (n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Illegal character point (0x" + Integer.toHexString(n2) + ") to output; max is 0x10FFFF as per RFC 4627");
        }
        if (n2 >= 55296) {
            if (n2 <= 56319) {
                throw new IllegalArgumentException("Unmatched first part of surrogate pair (0x" + Integer.toHexString(n2) + ")");
            }
            throw new IllegalArgumentException("Unmatched second part of surrogate pair (0x" + Integer.toHexString(n2) + ")");
        }
        throw new IllegalArgumentException("Illegal character point (0x" + Integer.toHexString(n2) + ") to output");
    }
}

