/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ValueNode;

public final class BooleanNode
extends ValueNode {
    public static final BooleanNode TRUE = new BooleanNode();
    public static final BooleanNode FALSE = new BooleanNode();

    private BooleanNode() {
    }

    public static BooleanNode getTrue() {
        return TRUE;
    }

    public static BooleanNode getFalse() {
        return FALSE;
    }

    public static BooleanNode valueOf(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public JsonToken asToken() {
        return this == TRUE ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
    }

    public boolean isBoolean() {
        return true;
    }

    public boolean booleanValue() {
        return this == TRUE;
    }

    public String asText() {
        return this == TRUE ? "true" : "false";
    }

    public boolean asBoolean() {
        return this == TRUE;
    }

    public boolean asBoolean(boolean bl) {
        return this == TRUE;
    }

    public int asInt(int n2) {
        return this == TRUE ? 1 : 0;
    }

    public long asLong(long l2) {
        return this == TRUE ? 1L : 0L;
    }

    public double asDouble(double d2) {
        return this == TRUE ? 1.0 : 0.0;
    }

    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        jsonGenerator.writeBoolean(this == TRUE);
    }

    public boolean equals(Object object) {
        return object == this;
    }
}

