/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo$As;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.AsArrayTypeDeserializer;
import com.fasterxml.jackson.databind.util.TokenBuffer;

public class AsPropertyTypeDeserializer
extends AsArrayTypeDeserializer {
    public AsPropertyTypeDeserializer(JavaType javaType, TypeIdResolver typeIdResolver, String string, boolean bl, Class clazz) {
        super(javaType, typeIdResolver, string, bl, clazz);
    }

    public AsPropertyTypeDeserializer(AsPropertyTypeDeserializer asPropertyTypeDeserializer, BeanProperty beanProperty) {
        super(asPropertyTypeDeserializer, beanProperty);
    }

    public TypeDeserializer forProperty(BeanProperty beanProperty) {
        if (beanProperty == this._property) {
            return this;
        }
        return new AsPropertyTypeDeserializer(this, beanProperty);
    }

    public JsonTypeInfo$As getTypeInclusion() {
        return JsonTypeInfo$As.PROPERTY;
    }

    public Object deserializeTypedFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            jsonToken = jsonParser.nextToken();
        } else {
            if (jsonToken == JsonToken.START_ARRAY) {
                return this._deserializeTypedUsingDefaultImpl(jsonParser, deserializationContext, null);
            }
            if (jsonToken != JsonToken.FIELD_NAME) {
                return this._deserializeTypedUsingDefaultImpl(jsonParser, deserializationContext, null);
            }
        }
        TokenBuffer tokenBuffer = null;
        while (jsonToken == JsonToken.FIELD_NAME) {
            String string = jsonParser.getCurrentName();
            jsonParser.nextToken();
            if (this._typePropertyName.equals(string)) {
                return this._deserializeTypedForId(jsonParser, deserializationContext, tokenBuffer);
            }
            if (tokenBuffer == null) {
                tokenBuffer = new TokenBuffer(null);
            }
            tokenBuffer.writeFieldName(string);
            tokenBuffer.copyCurrentStructure(jsonParser);
            jsonToken = jsonParser.nextToken();
        }
        return this._deserializeTypedUsingDefaultImpl(jsonParser, deserializationContext, tokenBuffer);
    }

    protected final Object _deserializeTypedForId(JsonParser jsonParser, DeserializationContext deserializationContext, TokenBuffer tokenBuffer) {
        String string = jsonParser.getText();
        JsonDeserializer jsonDeserializer = this._findDeserializer(deserializationContext, string);
        if (this._typeIdVisible) {
            if (tokenBuffer == null) {
                tokenBuffer = new TokenBuffer(null);
            }
            tokenBuffer.writeFieldName(jsonParser.getCurrentName());
            tokenBuffer.writeString(string);
        }
        if (tokenBuffer != null) {
            jsonParser = JsonParserSequence.createFlattened(tokenBuffer.asParser(jsonParser), jsonParser);
        }
        jsonParser.nextToken();
        return jsonDeserializer.deserialize(jsonParser, deserializationContext);
    }

    protected Object _deserializeTypedUsingDefaultImpl(JsonParser jsonParser, DeserializationContext deserializationContext, TokenBuffer tokenBuffer) {
        if (this._defaultImpl != null) {
            JsonDeserializer jsonDeserializer = this._findDefaultImplDeserializer(deserializationContext);
            if (tokenBuffer != null) {
                tokenBuffer.writeEndObject();
                jsonParser = tokenBuffer.asParser(jsonParser);
                jsonParser.nextToken();
            }
            return jsonDeserializer.deserialize(jsonParser, deserializationContext);
        }
        Object object = this._deserializeIfNatural(jsonParser, deserializationContext);
        if (object != null) {
            return object;
        }
        if (jsonParser.getCurrentToken() == JsonToken.START_ARRAY) {
            return super.deserializeTypedFromAny(jsonParser, deserializationContext);
        }
        throw deserializationContext.wrongTokenException(jsonParser, JsonToken.FIELD_NAME, "missing property '" + this._typePropertyName + "' that is to contain type id  (for class " + this.baseTypeName() + ")");
    }

    public Object deserializeTypedFromAny(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.getCurrentToken() == JsonToken.START_ARRAY) {
            return super.deserializeTypedFromArray(jsonParser, deserializationContext);
        }
        return this.deserializeTypedFromObject(jsonParser, deserializationContext);
    }

    protected Object _deserializeIfNatural(JsonParser jsonParser, DeserializationContext deserializationContext) {
        switch (jsonParser.getCurrentToken()) {
            case VALUE_STRING: {
                if (!this._baseType.getRawClass().isAssignableFrom(String.class)) break;
                return jsonParser.getText();
            }
            case VALUE_NUMBER_INT: {
                if (!this._baseType.getRawClass().isAssignableFrom(Integer.class)) break;
                return jsonParser.getIntValue();
            }
            case VALUE_NUMBER_FLOAT: {
                if (!this._baseType.getRawClass().isAssignableFrom(Double.class)) break;
                return jsonParser.getDoubleValue();
            }
            case VALUE_TRUE: {
                if (!this._baseType.getRawClass().isAssignableFrom(Boolean.class)) break;
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                if (!this._baseType.getRawClass().isAssignableFrom(Boolean.class)) break;
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

