/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public final class MemberKey {
    static final Class[] NO_CLASSES = new Class[0];
    final String _name;
    final Class[] _argTypes;

    public MemberKey(Method method) {
        this(method.getName(), method.getParameterTypes());
    }

    public MemberKey(Constructor constructor) {
        this("", constructor.getParameterTypes());
    }

    public MemberKey(String string, Class[] classArray) {
        this._name = string;
        this._argTypes = classArray == null ? NO_CLASSES : classArray;
    }

    public String toString() {
        return this._name + "(" + this._argTypes.length + "-args)";
    }

    public int hashCode() {
        return this._name.hashCode() + this._argTypes.length;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        MemberKey memberKey = (MemberKey)object;
        if (!this._name.equals(memberKey._name)) {
            return false;
        }
        Class[] classArray = memberKey._argTypes;
        int n2 = this._argTypes.length;
        if (classArray.length != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Class clazz = classArray[i2];
            Class clazz2 = this._argTypes[i2];
            if (clazz == clazz2 || clazz.isAssignableFrom(clazz2) || clazz2.isAssignableFrom(clazz)) continue;
            return false;
        }
        return true;
    }
}

