/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers$Base;
import com.fasterxml.jackson.databind.util.ArrayBuilders$LongBuilder;

@JacksonStdImpl
final class PrimitiveArrayDeserializers$LongDeser
extends PrimitiveArrayDeserializers$Base {
    public PrimitiveArrayDeserializers$LongDeser() {
        super(long[].class);
    }

    public long[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext);
        }
        ArrayBuilders$LongBuilder arrayBuilders$LongBuilder = deserializationContext.getArrayBuilders().getLongBuilder();
        long[] lArray = (long[])arrayBuilders$LongBuilder.resetAndStart();
        int n2 = 0;
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            long l2 = this._parseLongPrimitive(jsonParser, deserializationContext);
            if (n2 >= lArray.length) {
                lArray = (long[])arrayBuilders$LongBuilder.appendCompletedChunk(lArray, n2);
                n2 = 0;
            }
            lArray[n2++] = l2;
        }
        return (long[])arrayBuilders$LongBuilder.completeAndClearBuffer(lArray, n2);
    }

    private final long[] handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && jsonParser.getText().length() == 0) {
            return null;
        }
        if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            throw deserializationContext.mappingException(this._valueClass);
        }
        return new long[]{this._parseLongPrimitive(jsonParser, deserializationContext)};
    }
}

