/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.math.BigDecimal;

@JacksonStdImpl
public class NumberDeserializers$BigDecimalDeserializer
extends StdScalarDeserializer {
    public NumberDeserializers$BigDecimalDeserializer() {
        super(BigDecimal.class);
    }

    public BigDecimal deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getDecimalValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return null;
            }
            try {
                return new BigDecimal(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(this._valueClass, "not a valid representation");
            }
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }
}

