/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.BufferRecycler$ByteBufferType;
import java.io.OutputStream;
import java.util.LinkedList;

public final class ByteArrayBuilder
extends OutputStream {
    private static final byte[] NO_BYTES = new byte[0];
    private static final int INITIAL_BLOCK_SIZE = 500;
    private static final int MAX_BLOCK_SIZE = 262144;
    static final int DEFAULT_BLOCK_ARRAY_SIZE = 40;
    private final BufferRecycler _bufferRecycler;
    private final LinkedList _pastBlocks = new LinkedList();
    private int _pastLen;
    private byte[] _currBlock;
    private int _currBlockPtr;

    public ByteArrayBuilder() {
        this(null);
    }

    public ByteArrayBuilder(BufferRecycler bufferRecycler) {
        this(bufferRecycler, 500);
    }

    public ByteArrayBuilder(int n2) {
        this(null, n2);
    }

    public ByteArrayBuilder(BufferRecycler bufferRecycler, int n2) {
        this._bufferRecycler = bufferRecycler;
        this._currBlock = bufferRecycler == null ? new byte[n2] : bufferRecycler.allocByteBuffer(BufferRecycler$ByteBufferType.WRITE_CONCAT_BUFFER);
    }

    public void reset() {
        this._pastLen = 0;
        this._currBlockPtr = 0;
        if (!this._pastBlocks.isEmpty()) {
            this._pastBlocks.clear();
        }
    }

    public void release() {
        this.reset();
        if (this._bufferRecycler != null && this._currBlock != null) {
            this._bufferRecycler.releaseByteBuffer(BufferRecycler$ByteBufferType.WRITE_CONCAT_BUFFER, this._currBlock);
            this._currBlock = null;
        }
    }

    public void append(int n2) {
        if (this._currBlockPtr >= this._currBlock.length) {
            this._allocMore();
        }
        this._currBlock[this._currBlockPtr++] = (byte)n2;
    }

    public void appendTwoBytes(int n2) {
        if (this._currBlockPtr + 1 < this._currBlock.length) {
            this._currBlock[this._currBlockPtr++] = (byte)(n2 >> 8);
            this._currBlock[this._currBlockPtr++] = (byte)n2;
        } else {
            this.append(n2 >> 8);
            this.append(n2);
        }
    }

    public void appendThreeBytes(int n2) {
        if (this._currBlockPtr + 2 < this._currBlock.length) {
            this._currBlock[this._currBlockPtr++] = (byte)(n2 >> 16);
            this._currBlock[this._currBlockPtr++] = (byte)(n2 >> 8);
            this._currBlock[this._currBlockPtr++] = (byte)n2;
        } else {
            this.append(n2 >> 16);
            this.append(n2 >> 8);
            this.append(n2);
        }
    }

    public byte[] toByteArray() {
        int n2 = this._pastLen + this._currBlockPtr;
        if (n2 == 0) {
            return NO_BYTES;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (byte[] byArray2 : this._pastBlocks) {
            int n4 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n3, n4);
            n3 += n4;
        }
        System.arraycopy(this._currBlock, 0, byArray, n3, this._currBlockPtr);
        if ((n3 += this._currBlockPtr) != n2) {
            throw new RuntimeException("Internal error: total len assumed to be " + n2 + ", copied " + n3 + " bytes");
        }
        if (!this._pastBlocks.isEmpty()) {
            this.reset();
        }
        return byArray;
    }

    public byte[] resetAndGetFirstSegment() {
        this.reset();
        return this._currBlock;
    }

    public byte[] finishCurrentSegment() {
        this._allocMore();
        return this._currBlock;
    }

    public byte[] completeAndCoalesce(int n2) {
        this._currBlockPtr = n2;
        return this.toByteArray();
    }

    public byte[] getCurrentSegment() {
        return this._currBlock;
    }

    public void setCurrentSegmentLength(int n2) {
        this._currBlockPtr = n2;
    }

    public int getCurrentSegmentLength() {
        return this._currBlockPtr;
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) {
        while (true) {
            int n4;
            int n5;
            if ((n5 = Math.min(n4 = this._currBlock.length - this._currBlockPtr, n3)) > 0) {
                System.arraycopy(byArray, n2, this._currBlock, this._currBlockPtr, n5);
                n2 += n5;
                this._currBlockPtr += n5;
                n3 -= n5;
            }
            if (n3 <= 0) break;
            this._allocMore();
        }
    }

    public void write(int n2) {
        this.append(n2);
    }

    public void close() {
    }

    public void flush() {
    }

    private void _allocMore() {
        this._pastLen += this._currBlock.length;
        int n2 = Math.max(this._pastLen >> 1, 1000);
        if (n2 > 262144) {
            n2 = 262144;
        }
        this._pastBlocks.add(this._currBlock);
        this._currBlock = new byte[n2];
        this._currBlockPtr = 0;
    }
}

