/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.sym;

import com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer$Bucket;
import com.fasterxml.jackson.core.util.InternCache;
import java.util.Arrays;

public final class CharsToNameCanonicalizer {
    public static final int HASH_MULT = 33;
    protected static final int DEFAULT_TABLE_SIZE = 64;
    protected static final int MAX_TABLE_SIZE = 65536;
    static final int MAX_ENTRIES_FOR_REUSE = 12000;
    static final int MAX_COLL_CHAIN_LENGTH = 255;
    static final int MAX_COLL_CHAIN_FOR_REUSE = 63;
    static final CharsToNameCanonicalizer sBootstrapSymbolTable = new CharsToNameCanonicalizer();
    protected CharsToNameCanonicalizer _parent;
    private final int _hashSeed;
    protected final boolean _intern;
    protected final boolean _canonicalize;
    protected String[] _symbols;
    protected CharsToNameCanonicalizer$Bucket[] _buckets;
    protected int _size;
    protected int _sizeThreshold;
    protected int _indexMask;
    protected int _longestCollisionList;
    protected boolean _dirty;

    public static CharsToNameCanonicalizer createRoot() {
        long l2 = System.currentTimeMillis();
        int n2 = (int)l2 + ((int)l2 >>> 32) | 1;
        return CharsToNameCanonicalizer.createRoot(n2);
    }

    protected static CharsToNameCanonicalizer createRoot(int n2) {
        return sBootstrapSymbolTable.makeOrphan(n2);
    }

    private CharsToNameCanonicalizer() {
        this._canonicalize = true;
        this._intern = true;
        this._dirty = true;
        this._hashSeed = 0;
        this._longestCollisionList = 0;
        this.initTables(64);
    }

    private void initTables(int n2) {
        this._symbols = new String[n2];
        this._buckets = new CharsToNameCanonicalizer$Bucket[n2 >> 1];
        this._indexMask = n2 - 1;
        this._size = 0;
        this._longestCollisionList = 0;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n2);
    }

    private static final int _thresholdSize(int n2) {
        return n2 - (n2 >> 2);
    }

    private CharsToNameCanonicalizer(CharsToNameCanonicalizer charsToNameCanonicalizer, boolean bl, boolean bl2, String[] stringArray, CharsToNameCanonicalizer$Bucket[] charsToNameCanonicalizer$BucketArray, int n2, int n3, int n4) {
        this._parent = charsToNameCanonicalizer;
        this._canonicalize = bl;
        this._intern = bl2;
        this._symbols = stringArray;
        this._buckets = charsToNameCanonicalizer$BucketArray;
        this._size = n2;
        this._hashSeed = n3;
        int n5 = stringArray.length;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n5);
        this._indexMask = n5 - 1;
        this._longestCollisionList = n4;
        this._dirty = false;
    }

    public synchronized CharsToNameCanonicalizer makeChild(boolean bl, boolean bl2) {
        return new CharsToNameCanonicalizer(this, bl, bl2, this._symbols, this._buckets, this._size, this._hashSeed, this._longestCollisionList);
    }

    private CharsToNameCanonicalizer makeOrphan(int n2) {
        return new CharsToNameCanonicalizer(null, true, true, this._symbols, this._buckets, this._size, n2, this._longestCollisionList);
    }

    private synchronized void mergeChild(CharsToNameCanonicalizer charsToNameCanonicalizer) {
        if (charsToNameCanonicalizer.size() > 12000 || charsToNameCanonicalizer._longestCollisionList > 63) {
            this.initTables(64);
        } else {
            if (charsToNameCanonicalizer.size() <= this.size()) {
                return;
            }
            this._symbols = charsToNameCanonicalizer._symbols;
            this._buckets = charsToNameCanonicalizer._buckets;
            this._size = charsToNameCanonicalizer._size;
            this._sizeThreshold = charsToNameCanonicalizer._sizeThreshold;
            this._indexMask = charsToNameCanonicalizer._indexMask;
            this._longestCollisionList = charsToNameCanonicalizer._longestCollisionList;
        }
        this._dirty = false;
    }

    public void release() {
        if (!this.maybeDirty()) {
            return;
        }
        if (this._parent != null) {
            this._parent.mergeChild(this);
            this._dirty = false;
        }
    }

    public int size() {
        return this._size;
    }

    public int bucketCount() {
        return this._symbols.length;
    }

    public boolean maybeDirty() {
        return this._dirty;
    }

    public int hashSeed() {
        return this._hashSeed;
    }

    public int collisionCount() {
        int n2 = 0;
        for (CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket : this._buckets) {
            if (charsToNameCanonicalizer$Bucket == null) continue;
            n2 += charsToNameCanonicalizer$Bucket.length();
        }
        return n2;
    }

    public int maxCollisionLength() {
        return this._longestCollisionList;
    }

    public String findSymbol(char[] cArray, int n2, int n3, int n4) {
        Object object;
        if (n3 < 1) {
            return "";
        }
        if (!this._canonicalize) {
            return new String(cArray, n2, n3);
        }
        int n5 = this._hashToIndex(n4);
        String string = this._symbols[n5];
        if (string != null) {
            if (string.length() == n3) {
                int n6 = 0;
                while (string.charAt(n6) == cArray[n2 + n6] && ++n6 < n3) {
                }
                if (n6 == n3) {
                    return string;
                }
            }
            if ((object = this._buckets[n5 >> 1]) != null && (string = ((CharsToNameCanonicalizer$Bucket)object).find(cArray, n2, n3)) != null) {
                return string;
            }
        }
        if (!this._dirty) {
            this.copyArrays();
            this._dirty = true;
        } else if (this._size >= this._sizeThreshold) {
            this.rehash();
            n5 = this._hashToIndex(this.calcHash(cArray, n2, n3));
        }
        object = new String(cArray, n2, n3);
        if (this._intern) {
            object = InternCache.instance.intern((String)object);
        }
        ++this._size;
        if (this._symbols[n5] == null) {
            this._symbols[n5] = object;
        } else {
            CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket;
            int n7 = n5 >> 1;
            this._buckets[n7] = charsToNameCanonicalizer$Bucket = new CharsToNameCanonicalizer$Bucket((String)object, this._buckets[n7]);
            this._longestCollisionList = Math.max(charsToNameCanonicalizer$Bucket.length(), this._longestCollisionList);
            if (this._longestCollisionList > 255) {
                this.reportTooManyCollisions(255);
            }
        }
        return object;
    }

    public final int _hashToIndex(int n2) {
        n2 += n2 >>> 15;
        return n2 & this._indexMask;
    }

    public int calcHash(char[] cArray, int n2, int n3) {
        int n4 = this._hashSeed;
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 = n4 * 33 + cArray[i2];
        }
        return n4 == 0 ? 1 : n4;
    }

    public int calcHash(String string) {
        int n2 = string.length();
        int n3 = this._hashSeed;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = n3 * 33 + string.charAt(i2);
        }
        return n3 == 0 ? 1 : n3;
    }

    private void copyArrays() {
        String[] stringArray = this._symbols;
        int n2 = stringArray.length;
        this._symbols = new String[n2];
        System.arraycopy(stringArray, 0, this._symbols, 0, n2);
        CharsToNameCanonicalizer$Bucket[] charsToNameCanonicalizer$BucketArray = this._buckets;
        n2 = charsToNameCanonicalizer$BucketArray.length;
        this._buckets = new CharsToNameCanonicalizer$Bucket[n2];
        System.arraycopy(charsToNameCanonicalizer$BucketArray, 0, this._buckets, 0, n2);
    }

    private void rehash() {
        int n2;
        Object object;
        int n3;
        int n4 = this._symbols.length;
        int n5 = n4 + n4;
        if (n5 > 65536) {
            this._size = 0;
            Arrays.fill(this._symbols, null);
            Arrays.fill(this._buckets, null);
            this._dirty = true;
            return;
        }
        String[] stringArray = this._symbols;
        CharsToNameCanonicalizer$Bucket[] charsToNameCanonicalizer$BucketArray = this._buckets;
        this._symbols = new String[n5];
        this._buckets = new CharsToNameCanonicalizer$Bucket[n5 >> 1];
        this._indexMask = n5 - 1;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n5);
        int n6 = 0;
        int n7 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket;
            object = stringArray[n3];
            if (object == null) continue;
            ++n6;
            int n8 = this._hashToIndex(this.calcHash((String)object));
            if (this._symbols[n8] == null) {
                this._symbols[n8] = object;
                continue;
            }
            n2 = n8 >> 1;
            this._buckets[n2] = charsToNameCanonicalizer$Bucket = new CharsToNameCanonicalizer$Bucket((String)object, this._buckets[n2]);
            n7 = Math.max(n7, charsToNameCanonicalizer$Bucket.length());
        }
        n4 >>= 1;
        for (n3 = 0; n3 < n4; ++n3) {
            for (object = charsToNameCanonicalizer$BucketArray[n3]; object != null; object = ((CharsToNameCanonicalizer$Bucket)object).getNext()) {
                CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket;
                ++n6;
                String string = ((CharsToNameCanonicalizer$Bucket)object).getSymbol();
                n2 = this._hashToIndex(this.calcHash(string));
                if (this._symbols[n2] == null) {
                    this._symbols[n2] = string;
                    continue;
                }
                int n9 = n2 >> 1;
                this._buckets[n9] = charsToNameCanonicalizer$Bucket = new CharsToNameCanonicalizer$Bucket(string, this._buckets[n9]);
                n7 = Math.max(n7, charsToNameCanonicalizer$Bucket.length());
            }
        }
        this._longestCollisionList = n7;
        if (n6 != this._size) {
            throw new Error("Internal error on SymbolTable.rehash(): had " + this._size + " entries; now have " + n6 + ".");
        }
    }

    protected void reportTooManyCollisions(int n2) {
        throw new IllegalStateException("Longest collision chain in symbol table (of size " + this._size + ") now exceeds maximum, " + n2 + " -- suspect a DoS attack based on hash collisions");
    }
}

