/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jaxrs.json.annotation;

import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.JSONPObject;
import com.fasterxml.jackson.databind.util.JSONWrappedObject;
import com.fasterxml.jackson.jaxrs.json.annotation.JSONP;
import com.fasterxml.jackson.jaxrs.json.annotation.JSONP$Def;
import com.fasterxml.jackson.jaxrs.json.annotation.JacksonFeatures;
import java.lang.annotation.Annotation;

public class EndpointConfig {
    protected Class _activeView;
    protected String _rootName;
    protected DeserializationFeature[] _deserEnable;
    protected DeserializationFeature[] _deserDisable;
    protected ObjectReader _reader;
    protected JSONP$Def _jsonp;
    protected SerializationFeature[] _serEnable;
    protected SerializationFeature[] _serDisable;
    protected ObjectWriter _writer;

    protected EndpointConfig() {
    }

    public static EndpointConfig forReading(ObjectMapper objectMapper, Annotation[] annotationArray) {
        return new EndpointConfig().add(annotationArray, false).initReader(objectMapper);
    }

    public static EndpointConfig forWriting(ObjectMapper objectMapper, Annotation[] annotationArray, String string) {
        EndpointConfig endpointConfig = new EndpointConfig();
        if (string != null) {
            endpointConfig._jsonp = new JSONP$Def(string);
        }
        return endpointConfig.add(annotationArray, true).initWriter(objectMapper);
    }

    protected EndpointConfig add(Annotation[] annotationArray, boolean bl) {
        if (annotationArray != null) {
            for (Annotation annotation : annotationArray) {
                Object object;
                Class<? extends Annotation> clazz = annotation.annotationType();
                if (clazz == JSONP.class) {
                    if (!bl) continue;
                    this._jsonp = new JSONP$Def((JSONP)annotation);
                    continue;
                }
                if (clazz == JsonView.class) {
                    object = ((JsonView)annotation).value();
                    this._activeView = ((Class[])object).length > 0 ? object[0] : null;
                    continue;
                }
                if (clazz == JsonRootName.class) {
                    this._rootName = ((JsonRootName)annotation).value();
                    continue;
                }
                if (clazz == JacksonFeatures.class) {
                    object = (JacksonFeatures)annotation;
                    if (bl) {
                        this._serEnable = (SerializationFeature[])EndpointConfig.nullIfEmpty(object.serializationEnable());
                        this._serDisable = (SerializationFeature[])EndpointConfig.nullIfEmpty(object.serializationDisable());
                        continue;
                    }
                    this._deserEnable = (DeserializationFeature[])EndpointConfig.nullIfEmpty(object.deserializationEnable());
                    this._deserDisable = (DeserializationFeature[])EndpointConfig.nullIfEmpty(object.deserializationDisable());
                    continue;
                }
                if (clazz == JacksonAnnotationsInside.class || (object = clazz.getAnnotation(JacksonAnnotationsInside.class)) == null) continue;
                this.add(clazz.getAnnotations(), bl);
            }
        }
        return this;
    }

    protected EndpointConfig initReader(ObjectMapper objectMapper) {
        this._reader = this._activeView != null ? objectMapper.readerWithView(this._activeView) : objectMapper.reader();
        if (this._rootName != null) {
            this._reader = this._reader.withRootName(this._rootName);
        }
        if (this._deserEnable != null) {
            this._reader = this._reader.withFeatures(this._deserEnable);
        }
        if (this._deserDisable != null) {
            this._reader = this._reader.withoutFeatures(this._deserDisable);
        }
        this._reader.getJsonFactory().disable(JsonParser$Feature.AUTO_CLOSE_SOURCE);
        return this;
    }

    protected EndpointConfig initWriter(ObjectMapper objectMapper) {
        this._writer = this._activeView != null ? objectMapper.writerWithView(this._activeView) : objectMapper.writer();
        if (this._rootName != null) {
            this._writer = this._writer.withRootName(this._rootName);
        }
        if (this._serEnable != null) {
            this._writer = this._writer.withFeatures(this._serEnable);
        }
        if (this._serDisable != null) {
            this._writer = this._writer.withoutFeatures(this._serDisable);
        }
        this._writer.getJsonFactory().disable(JsonGenerator$Feature.AUTO_CLOSE_TARGET);
        return this;
    }

    public ObjectReader getReader() {
        if (this._reader == null) {
            throw new IllegalStateException();
        }
        return this._reader;
    }

    public ObjectWriter getWriter() {
        if (this._writer == null) {
            throw new IllegalStateException();
        }
        return this._writer;
    }

    public Object applyJSONP(Object object) {
        if (this._jsonp != null) {
            if (this._jsonp.prefix != null || this._jsonp.suffix != null) {
                return new JSONWrappedObject(this._jsonp.prefix, this._jsonp.suffix, object);
            }
            if (this._jsonp.method != null) {
                return new JSONPObject(this._jsonp.method, object);
            }
        }
        return object;
    }

    private static Object[] nullIfEmpty(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        return objectArray;
    }
}

