/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public final class EnumValues {
    private final EnumMap _values;

    private EnumValues(Map map) {
        this._values = new EnumMap(map);
    }

    public static EnumValues construct(Class clazz, AnnotationIntrospector annotationIntrospector) {
        return EnumValues.constructFromName(clazz, annotationIntrospector);
    }

    public static EnumValues constructFromName(Class clazz, AnnotationIntrospector annotationIntrospector) {
        Class clazz2 = ClassUtil.findEnumType(clazz);
        Enum[] enumArray = (Enum[])clazz2.getEnumConstants();
        if (enumArray != null) {
            HashMap<Enum, SerializedString> hashMap = new HashMap<Enum, SerializedString>();
            for (Enum enum_ : enumArray) {
                String string = annotationIntrospector.findEnumValue(enum_);
                hashMap.put(enum_, new SerializedString(string));
            }
            return new EnumValues(hashMap);
        }
        throw new IllegalArgumentException("Can not determine enum constants for Class " + clazz.getName());
    }

    public static EnumValues constructFromToString(Class clazz, AnnotationIntrospector annotationIntrospector) {
        Class clazz2 = ClassUtil.findEnumType(clazz);
        Enum[] enumArray = (Enum[])clazz2.getEnumConstants();
        if (enumArray != null) {
            HashMap<Enum, SerializedString> hashMap = new HashMap<Enum, SerializedString>();
            for (Enum enum_ : enumArray) {
                hashMap.put(enum_, new SerializedString(enum_.toString()));
            }
            return new EnumValues(hashMap);
        }
        throw new IllegalArgumentException("Can not determine enum constants for Class " + clazz.getName());
    }

    public SerializedString serializedValueFor(Enum enum_) {
        return (SerializedString)this._values.get(enum_);
    }

    public Collection values() {
        return this._values.values();
    }
}

