/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;

public abstract class ArraySerializerBase
extends ContainerSerializer {
    protected final BeanProperty _property;

    protected ArraySerializerBase(Class clazz) {
        super(clazz);
        this._property = null;
    }

    public ArraySerializerBase(Class clazz, BeanProperty beanProperty) {
        super(clazz);
        this._property = beanProperty;
    }

    protected ArraySerializerBase(ArraySerializerBase arraySerializerBase) {
        super(arraySerializerBase._handledType, false);
        this._property = arraySerializerBase._property;
    }

    public ArraySerializerBase(ArraySerializerBase arraySerializerBase, BeanProperty beanProperty) {
        super(arraySerializerBase._handledType, false);
        this._property = beanProperty;
    }

    public final void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) && this.hasSingleElement(object)) {
            this.serializeContents(object, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray();
        this.serializeContents(object, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    public final void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        typeSerializer.writeTypePrefixForArray(object, jsonGenerator);
        this.serializeContents(object, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffixForArray(object, jsonGenerator);
    }

    protected abstract void serializeContents(Object var1, JsonGenerator var2, SerializerProvider var3);
}

