/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

public final class NumberOutput {
    private static final char NULL_CHAR = '\u0000';
    private static int MILLION = 1000000;
    private static int BILLION = 1000000000;
    private static long TEN_BILLION_L = 10000000000L;
    private static long THOUSAND_L = 1000L;
    private static long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    private static long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    static final String SMALLEST_LONG = String.valueOf(Long.MIN_VALUE);
    static final char[] LEADING_TRIPLETS = new char[4000];
    static final char[] FULL_TRIPLETS = new char[4000];
    static final byte[] FULL_TRIPLETS_B;
    static final String[] sSmallIntStrs;
    static final String[] sSmallIntStrs2;

    public static int outputInt(int n2, char[] cArray, int n3) {
        boolean bl;
        if (n2 < 0) {
            if (n2 == Integer.MIN_VALUE) {
                return NumberOutput.outputLong((long)n2, cArray, n3);
            }
            cArray[n3++] = 45;
            n2 = -n2;
        }
        if (n2 < MILLION) {
            if (n2 < 1000) {
                if (n2 < 10) {
                    cArray[n3++] = (char)(48 + n2);
                } else {
                    n3 = NumberOutput.outputLeadingTriplet(n2, cArray, n3);
                }
            } else {
                int n4 = n2 / 1000;
                n3 = NumberOutput.outputLeadingTriplet(n4, cArray, n3);
                n3 = NumberOutput.outputFullTriplet(n2 -= n4 * 1000, cArray, n3);
            }
            return n3;
        }
        boolean bl2 = bl = n2 >= BILLION;
        if (bl) {
            if ((n2 -= BILLION) >= BILLION) {
                n2 -= BILLION;
                cArray[n3++] = 50;
            } else {
                cArray[n3++] = 49;
            }
        }
        int n5 = n2 / 1000;
        int n6 = n2 - n5 * 1000;
        n2 = n5;
        int n7 = n2 - (n5 /= 1000) * 1000;
        n3 = bl ? NumberOutput.outputFullTriplet(n5, cArray, n3) : NumberOutput.outputLeadingTriplet(n5, cArray, n3);
        n3 = NumberOutput.outputFullTriplet(n7, cArray, n3);
        n3 = NumberOutput.outputFullTriplet(n6, cArray, n3);
        return n3;
    }

    public static int outputInt(int n2, byte[] byArray, int n3) {
        boolean bl;
        if (n2 < 0) {
            if (n2 == Integer.MIN_VALUE) {
                return NumberOutput.outputLong((long)n2, byArray, n3);
            }
            byArray[n3++] = 45;
            n2 = -n2;
        }
        if (n2 < MILLION) {
            if (n2 < 1000) {
                if (n2 < 10) {
                    byArray[n3++] = (byte)(48 + n2);
                } else {
                    n3 = NumberOutput.outputLeadingTriplet(n2, byArray, n3);
                }
            } else {
                int n4 = n2 / 1000;
                n3 = NumberOutput.outputLeadingTriplet(n4, byArray, n3);
                n3 = NumberOutput.outputFullTriplet(n2 -= n4 * 1000, byArray, n3);
            }
            return n3;
        }
        boolean bl2 = bl = n2 >= BILLION;
        if (bl) {
            if ((n2 -= BILLION) >= BILLION) {
                n2 -= BILLION;
                byArray[n3++] = 50;
            } else {
                byArray[n3++] = 49;
            }
        }
        int n5 = n2 / 1000;
        int n6 = n2 - n5 * 1000;
        n2 = n5;
        int n7 = n2 - (n5 /= 1000) * 1000;
        n3 = bl ? NumberOutput.outputFullTriplet(n5, byArray, n3) : NumberOutput.outputLeadingTriplet(n5, byArray, n3);
        n3 = NumberOutput.outputFullTriplet(n7, byArray, n3);
        n3 = NumberOutput.outputFullTriplet(n6, byArray, n3);
        return n3;
    }

    public static int outputLong(long l2, char[] cArray, int n2) {
        int n3;
        if (l2 < 0L) {
            if (l2 > MIN_INT_AS_LONG) {
                return NumberOutput.outputInt((int)l2, cArray, n2);
            }
            if (l2 == Long.MIN_VALUE) {
                int n4 = SMALLEST_LONG.length();
                SMALLEST_LONG.getChars(0, n4, cArray, n2);
                return n2 + n4;
            }
            cArray[n2++] = 45;
            l2 = -l2;
        } else if (l2 <= MAX_INT_AS_LONG) {
            return NumberOutput.outputInt((int)l2, cArray, n2);
        }
        int n5 = n2;
        int n6 = n2 += NumberOutput.calcLongStrLength(l2);
        while (l2 > MAX_INT_AS_LONG) {
            long l3 = l2 / THOUSAND_L;
            n3 = (int)(l2 - l3 * THOUSAND_L);
            NumberOutput.outputFullTriplet(n3, cArray, n6 -= 3);
            l2 = l3;
        }
        int n7 = (int)l2;
        while (n7 >= 1000) {
            int n8 = n7 / 1000;
            n3 = n7 - n8 * 1000;
            NumberOutput.outputFullTriplet(n3, cArray, n6 -= 3);
            n7 = n8;
        }
        NumberOutput.outputLeadingTriplet(n7, cArray, n5);
        return n2;
    }

    public static int outputLong(long l2, byte[] byArray, int n2) {
        int n3;
        if (l2 < 0L) {
            if (l2 > MIN_INT_AS_LONG) {
                return NumberOutput.outputInt((int)l2, byArray, n2);
            }
            if (l2 == Long.MIN_VALUE) {
                int n4 = SMALLEST_LONG.length();
                for (int i2 = 0; i2 < n4; ++i2) {
                    byArray[n2++] = (byte)SMALLEST_LONG.charAt(i2);
                }
                return n2;
            }
            byArray[n2++] = 45;
            l2 = -l2;
        } else if (l2 <= MAX_INT_AS_LONG) {
            return NumberOutput.outputInt((int)l2, byArray, n2);
        }
        int n5 = n2;
        int n6 = n2 += NumberOutput.calcLongStrLength(l2);
        while (l2 > MAX_INT_AS_LONG) {
            long l3 = l2 / THOUSAND_L;
            n3 = (int)(l2 - l3 * THOUSAND_L);
            NumberOutput.outputFullTriplet(n3, byArray, n6 -= 3);
            l2 = l3;
        }
        int n7 = (int)l2;
        while (n7 >= 1000) {
            int n8 = n7 / 1000;
            n3 = n7 - n8 * 1000;
            NumberOutput.outputFullTriplet(n3, byArray, n6 -= 3);
            n7 = n8;
        }
        NumberOutput.outputLeadingTriplet(n7, byArray, n5);
        return n2;
    }

    public static String toString(int n2) {
        if (n2 < sSmallIntStrs.length) {
            if (n2 >= 0) {
                return sSmallIntStrs[n2];
            }
            int n3 = -n2 - 1;
            if (n3 < sSmallIntStrs2.length) {
                return sSmallIntStrs2[n3];
            }
        }
        return Integer.toString(n2);
    }

    public static String toString(long l2) {
        if (l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE) {
            return NumberOutput.toString((int)l2);
        }
        return Long.toString(l2);
    }

    public static String toString(double d2) {
        return Double.toString(d2);
    }

    private static int outputLeadingTriplet(int n2, char[] cArray, int n3) {
        char c2;
        int n4 = n2 << 2;
        if ((c2 = LEADING_TRIPLETS[n4++]) != '\u0000') {
            cArray[n3++] = c2;
        }
        if ((c2 = LEADING_TRIPLETS[n4++]) != '\u0000') {
            cArray[n3++] = c2;
        }
        cArray[n3++] = LEADING_TRIPLETS[n4];
        return n3;
    }

    private static int outputLeadingTriplet(int n2, byte[] byArray, int n3) {
        char c2;
        int n4 = n2 << 2;
        if ((c2 = LEADING_TRIPLETS[n4++]) != '\u0000') {
            byArray[n3++] = (byte)c2;
        }
        if ((c2 = LEADING_TRIPLETS[n4++]) != '\u0000') {
            byArray[n3++] = (byte)c2;
        }
        byArray[n3++] = (byte)LEADING_TRIPLETS[n4];
        return n3;
    }

    private static int outputFullTriplet(int n2, char[] cArray, int n3) {
        int n4 = n2 << 2;
        cArray[n3++] = FULL_TRIPLETS[n4++];
        cArray[n3++] = FULL_TRIPLETS[n4++];
        cArray[n3++] = FULL_TRIPLETS[n4];
        return n3;
    }

    private static int outputFullTriplet(int n2, byte[] byArray, int n3) {
        int n4 = n2 << 2;
        byArray[n3++] = FULL_TRIPLETS_B[n4++];
        byArray[n3++] = FULL_TRIPLETS_B[n4++];
        byArray[n3++] = FULL_TRIPLETS_B[n4];
        return n3;
    }

    private static int calcLongStrLength(long l2) {
        int n2;
        long l3 = TEN_BILLION_L;
        for (n2 = 10; l2 >= l3 && n2 != 19; ++n2) {
            l3 = (l3 << 3) + (l3 << 1);
        }
        return n2;
    }

    static {
        int n2 = 0;
        for (int i2 = 0; i2 < 10; ++i2) {
            char c2 = (char)(48 + i2);
            char c3 = i2 == 0 ? (char)'\u0000' : c2;
            for (int i3 = 0; i3 < 10; ++i3) {
                char c4 = (char)(48 + i3);
                char c5 = i2 == 0 && i3 == 0 ? (char)'\u0000' : c4;
                for (int i4 = 0; i4 < 10; ++i4) {
                    char c6 = (char)(48 + i4);
                    NumberOutput.LEADING_TRIPLETS[n2] = c3;
                    NumberOutput.LEADING_TRIPLETS[n2 + 1] = c5;
                    NumberOutput.LEADING_TRIPLETS[n2 + 2] = c6;
                    NumberOutput.FULL_TRIPLETS[n2] = c2;
                    NumberOutput.FULL_TRIPLETS[n2 + 1] = c4;
                    NumberOutput.FULL_TRIPLETS[n2 + 2] = c6;
                    n2 += 4;
                }
            }
        }
        FULL_TRIPLETS_B = new byte[4000];
        for (n2 = 0; n2 < 4000; ++n2) {
            NumberOutput.FULL_TRIPLETS_B[n2] = (byte)FULL_TRIPLETS[n2];
        }
        sSmallIntStrs = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
        sSmallIntStrs2 = new String[]{"-1", "-2", "-3", "-4", "-5", "-6", "-7", "-8", "-9", "-10"};
    }
}

