/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import java.lang.reflect.Method;
import java.util.HashMap;

public class EnumResolver {
    protected final Class _enumClass;
    protected final Enum[] _enums;
    protected final HashMap _enumsById;

    protected EnumResolver(Class clazz, Enum[] enumArray, HashMap hashMap) {
        this._enumClass = clazz;
        this._enums = enumArray;
        this._enumsById = hashMap;
    }

    public static EnumResolver constructFor(Class clazz, AnnotationIntrospector annotationIntrospector) {
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("No enum constants for class " + clazz.getName());
        }
        HashMap<String, Enum> hashMap = new HashMap<String, Enum>();
        for (Enum enum_ : enumArray) {
            hashMap.put(annotationIntrospector.findEnumValue(enum_), enum_);
        }
        return new EnumResolver(clazz, enumArray, hashMap);
    }

    public static EnumResolver constructUsingToString(Class clazz) {
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        HashMap<String, Enum> hashMap = new HashMap<String, Enum>();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum enum_ = enumArray[n2];
            hashMap.put(enum_.toString(), enum_);
        }
        return new EnumResolver(clazz, enumArray, hashMap);
    }

    public static EnumResolver constructUsingMethod(Class clazz, Method method) {
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        HashMap<String, Enum> hashMap = new HashMap<String, Enum>();
        int n2 = enumArray.length;
        while (--n2 >= 0) {
            Enum enum_ = enumArray[n2];
            try {
                Object object = method.invoke((Object)enum_, new Object[0]);
                if (object == null) continue;
                hashMap.put(object.toString(), enum_);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Failed to access @JsonValue of Enum value " + enum_ + ": " + exception.getMessage());
            }
        }
        return new EnumResolver(clazz, enumArray, hashMap);
    }

    public static EnumResolver constructUnsafe(Class clazz, AnnotationIntrospector annotationIntrospector) {
        Class clazz2 = clazz;
        return EnumResolver.constructFor(clazz2, annotationIntrospector);
    }

    public static EnumResolver constructUnsafeUsingToString(Class clazz) {
        Class clazz2 = clazz;
        return EnumResolver.constructUsingToString(clazz2);
    }

    public static EnumResolver constructUnsafeUsingMethod(Class clazz, Method method) {
        Class clazz2 = clazz;
        return EnumResolver.constructUsingMethod(clazz2, method);
    }

    public Enum findEnum(String string) {
        return (Enum)this._enumsById.get(string);
    }

    public Enum getEnum(int n2) {
        if (n2 < 0 || n2 >= this._enums.length) {
            return null;
        }
        return this._enums[n2];
    }

    public Class getEnumClass() {
        return this._enumClass;
    }

    public int lastValidIndex() {
        return this._enums.length - 1;
    }
}

