/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeParser$MyTokenizer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.ArrayList;
import java.util.List;

public class TypeParser {
    final TypeFactory _factory;

    public TypeParser(TypeFactory typeFactory) {
        this._factory = typeFactory;
    }

    public JavaType parse(String string) {
        string = string.trim();
        TypeParser$MyTokenizer typeParser$MyTokenizer = new TypeParser$MyTokenizer(string);
        JavaType javaType = this.parseType(typeParser$MyTokenizer);
        if (typeParser$MyTokenizer.hasMoreTokens()) {
            throw this._problem(typeParser$MyTokenizer, "Unexpected tokens after complete type");
        }
        return javaType;
    }

    protected JavaType parseType(TypeParser$MyTokenizer typeParser$MyTokenizer) {
        if (!typeParser$MyTokenizer.hasMoreTokens()) {
            throw this._problem(typeParser$MyTokenizer, "Unexpected end-of-string");
        }
        Class clazz = this.findClass(typeParser$MyTokenizer.nextToken(), typeParser$MyTokenizer);
        if (typeParser$MyTokenizer.hasMoreTokens()) {
            String string = typeParser$MyTokenizer.nextToken();
            if ("<".equals(string)) {
                return this._factory._fromParameterizedClass(clazz, this.parseTypes(typeParser$MyTokenizer));
            }
            typeParser$MyTokenizer.pushBack(string);
        }
        return this._factory._fromClass(clazz, null);
    }

    protected List parseTypes(TypeParser$MyTokenizer typeParser$MyTokenizer) {
        ArrayList<JavaType> arrayList = new ArrayList<JavaType>();
        while (typeParser$MyTokenizer.hasMoreTokens()) {
            arrayList.add(this.parseType(typeParser$MyTokenizer));
            if (!typeParser$MyTokenizer.hasMoreTokens()) break;
            String string = typeParser$MyTokenizer.nextToken();
            if (">".equals(string)) {
                return arrayList;
            }
            if (",".equals(string)) continue;
            throw this._problem(typeParser$MyTokenizer, "Unexpected token '" + string + "', expected ',' or '>')");
        }
        throw this._problem(typeParser$MyTokenizer, "Unexpected end-of-string");
    }

    protected Class findClass(String string, TypeParser$MyTokenizer typeParser$MyTokenizer) {
        try {
            return ClassUtil.findClass(string);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw this._problem(typeParser$MyTokenizer, "Can not locate class '" + string + "', problem: " + exception.getMessage());
        }
    }

    protected IllegalArgumentException _problem(TypeParser$MyTokenizer typeParser$MyTokenizer, String string) {
        return new IllegalArgumentException("Failed to parse type '" + typeParser$MyTokenizer.getAllInput() + "' (remaining: '" + typeParser$MyTokenizer.getRemainingInput() + "'): " + string);
    }
}

