/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap$SerializerAndMapResult;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class AsArraySerializerBase
extends ContainerSerializer
implements ContextualSerializer {
    protected final boolean _staticTyping;
    protected final JavaType _elementType;
    protected final TypeSerializer _valueTypeSerializer;
    protected final JsonSerializer _elementSerializer;
    protected final BeanProperty _property;
    protected PropertySerializerMap _dynamicSerializers;

    public AsArraySerializerBase(Class clazz, JavaType javaType, boolean bl, TypeSerializer typeSerializer, BeanProperty beanProperty, JsonSerializer jsonSerializer) {
        super(clazz, false);
        this._elementType = javaType;
        this._staticTyping = bl || javaType != null && javaType.isFinal();
        this._valueTypeSerializer = typeSerializer;
        this._property = beanProperty;
        this._elementSerializer = jsonSerializer;
        this._dynamicSerializers = PropertySerializerMap.emptyMap();
    }

    public AsArraySerializerBase(AsArraySerializerBase asArraySerializerBase, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer jsonSerializer) {
        super(asArraySerializerBase);
        this._elementType = asArraySerializerBase._elementType;
        this._staticTyping = asArraySerializerBase._staticTyping;
        this._valueTypeSerializer = typeSerializer;
        this._property = asArraySerializerBase._property;
        this._elementSerializer = jsonSerializer;
        this._dynamicSerializers = asArraySerializerBase._dynamicSerializers;
    }

    public abstract AsArraySerializerBase withResolved(BeanProperty var1, TypeSerializer var2, JsonSerializer var3);

    public JsonSerializer createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) {
        JsonSerializer jsonSerializer;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        if (typeSerializer != null) {
            typeSerializer = typeSerializer.forProperty(beanProperty);
        }
        if ((jsonSerializer = this._elementSerializer) == null) {
            if (this._staticTyping && this._elementType != null) {
                jsonSerializer = serializerProvider.findValueSerializer(this._elementType, beanProperty);
            }
        } else if (jsonSerializer instanceof ContextualSerializer) {
            jsonSerializer = ((ContextualSerializer)((Object)jsonSerializer)).createContextual(serializerProvider, beanProperty);
        }
        if (jsonSerializer != this._elementSerializer || beanProperty != this._property || this._valueTypeSerializer != typeSerializer) {
            return this.withResolved(beanProperty, typeSerializer, jsonSerializer);
        }
        return this;
    }

    public JavaType getContentType() {
        return this._elementType;
    }

    public JsonSerializer getContentSerializer() {
        return this._elementSerializer;
    }

    public final void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) && this.hasSingleElement(object)) {
            this.serializeContents(object, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray();
        this.serializeContents(object, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    public final void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        typeSerializer.writeTypePrefixForArray(object, jsonGenerator);
        this.serializeContents(object, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffixForArray(object, jsonGenerator);
    }

    protected abstract void serializeContents(Object var1, JsonGenerator var2, SerializerProvider var3);

    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        Object object;
        Object object2;
        ObjectNode objectNode = this.createSchemaNode("array", true);
        JavaType javaType = null;
        if (type != null && (javaType = ((JavaType)(object2 = serializerProvider.constructType(type))).getContentType()) == null && type instanceof ParameterizedType && ((Type[])(object = ((ParameterizedType)type).getActualTypeArguments())).length == 1) {
            javaType = serializerProvider.constructType(object[0]);
        }
        if (javaType == null && this._elementType != null) {
            javaType = this._elementType;
        }
        if (javaType != null) {
            object2 = null;
            if (javaType.getRawClass() != Object.class && (object = serializerProvider.findValueSerializer(javaType, this._property)) instanceof SchemaAware) {
                object2 = ((SchemaAware)object).getSchema(serializerProvider, null);
            }
            if (object2 == null) {
                object2 = JsonSchema.getDefaultSchemaNode();
            }
            objectNode.put("items", (JsonNode)object2);
        }
        return objectNode;
    }

    protected final JsonSerializer _findAndAddDynamic(PropertySerializerMap propertySerializerMap, Class clazz, SerializerProvider serializerProvider) {
        PropertySerializerMap$SerializerAndMapResult propertySerializerMap$SerializerAndMapResult = propertySerializerMap.findAndAddSerializer(clazz, serializerProvider, this._property);
        if (propertySerializerMap != propertySerializerMap$SerializerAndMapResult.map) {
            this._dynamicSerializers = propertySerializerMap$SerializerAndMapResult.map;
        }
        return propertySerializerMap$SerializerAndMapResult.serializer;
    }

    protected final JsonSerializer _findAndAddDynamic(PropertySerializerMap propertySerializerMap, JavaType javaType, SerializerProvider serializerProvider) {
        PropertySerializerMap$SerializerAndMapResult propertySerializerMap$SerializerAndMapResult = propertySerializerMap.findAndAddSerializer(javaType, serializerProvider, this._property);
        if (propertySerializerMap != propertySerializerMap$SerializerAndMapResult.map) {
            this._dynamicSerializers = propertySerializerMap$SerializerAndMapResult.map;
        }
        return propertySerializerMap$SerializerAndMapResult.serializer;
    }
}

