/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.JsonSerializer$None;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.NoClass;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;

public abstract class DefaultSerializerProvider
extends SerializerProvider {
    protected IdentityHashMap _seenObjectIds;
    protected ArrayList _objectIdGenerators;

    protected DefaultSerializerProvider() {
    }

    protected DefaultSerializerProvider(SerializerProvider serializerProvider, SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
        super(serializerProvider, serializationConfig, serializerFactory);
    }

    public abstract DefaultSerializerProvider createInstance(SerializationConfig var1, SerializerFactory var2);

    public void serializeValue(JsonGenerator jsonGenerator, Object object) {
        String string;
        boolean bl;
        JsonSerializer jsonSerializer;
        if (object == null) {
            jsonSerializer = this.getDefaultNullValueSerializer();
            bl = false;
        } else {
            Class<?> clazz = object.getClass();
            jsonSerializer = this.findTypedValueSerializer(clazz, true, null);
            string = this._config.getRootName();
            if (string == null) {
                bl = this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE);
                if (bl) {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeFieldName(this._rootNames.findRootName(object.getClass(), (MapperConfig)this._config));
                }
            } else if (string.length() == 0) {
                bl = false;
            } else {
                bl = true;
                jsonGenerator.writeStartObject();
                jsonGenerator.writeFieldName(string);
            }
        }
        try {
            jsonSerializer.serialize(object, jsonGenerator, this);
            if (bl) {
                jsonGenerator.writeEndObject();
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            string = exception.getMessage();
            if (string == null) {
                string = "[no message for " + exception.getClass().getName() + "]";
            }
            throw new JsonMappingException(string, exception);
        }
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object, JavaType javaType) {
        boolean bl;
        JsonSerializer jsonSerializer;
        if (object == null) {
            jsonSerializer = this.getDefaultNullValueSerializer();
            bl = false;
        } else {
            if (!javaType.getRawClass().isAssignableFrom(object.getClass())) {
                this._reportIncompatibleRootType(object, javaType);
            }
            jsonSerializer = this.findTypedValueSerializer(javaType, true, null);
            bl = this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE);
            if (bl) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeFieldName(this._rootNames.findRootName(javaType, (MapperConfig)this._config));
            }
        }
        try {
            jsonSerializer.serialize(object, jsonGenerator, this);
            if (bl) {
                jsonGenerator.writeEndObject();
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "[no message for " + exception.getClass().getName() + "]";
            }
            throw new JsonMappingException(string, exception);
        }
    }

    public JsonSchema generateJsonSchema(Class clazz) {
        JsonNode jsonNode;
        if (clazz == null) {
            throw new IllegalArgumentException("A class must be provided");
        }
        JsonSerializer jsonSerializer = this.findValueSerializer(clazz, null);
        JsonNode jsonNode2 = jsonNode = jsonSerializer instanceof SchemaAware ? ((SchemaAware)((Object)jsonSerializer)).getSchema(this, null) : JsonSchema.getDefaultSchemaNode();
        if (!(jsonNode instanceof ObjectNode)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " would not be serialized as a JSON object and therefore has no schema");
        }
        return new JsonSchema((ObjectNode)jsonNode);
    }

    public boolean hasSerializerFor(Class clazz) {
        return this._findExplicitUntypedSerializer(clazz, null) != null;
    }

    public int cachedSerializersCount() {
        return this._serializerCache.size();
    }

    public void flushCachedSerializers() {
        this._serializerCache.flush();
    }

    public ObjectIdGenerator objectIdGeneratorInstance(Annotated annotated, ObjectIdInfo objectIdInfo) {
        Class clazz = objectIdInfo.getGeneratorType();
        HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
        ObjectIdGenerator objectIdGenerator = handlerInstantiator != null ? handlerInstantiator.objectIdGeneratorInstance(this._config, annotated, clazz) : (ObjectIdGenerator)ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
        return objectIdGenerator.forScope(objectIdInfo.getScope());
    }

    public WritableObjectId findObjectId(Object object, ObjectIdGenerator objectIdGenerator) {
        Object object2;
        if (this._seenObjectIds == null) {
            this._seenObjectIds = new IdentityHashMap();
        } else {
            object2 = (WritableObjectId)this._seenObjectIds.get(object);
            if (object2 != null) {
                return object2;
            }
        }
        object2 = null;
        if (this._objectIdGenerators == null) {
            this._objectIdGenerators = new ArrayList(8);
        } else {
            int n2 = this._objectIdGenerators.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ObjectIdGenerator objectIdGenerator2 = (ObjectIdGenerator)this._objectIdGenerators.get(i2);
                if (!objectIdGenerator2.canUseFor(objectIdGenerator)) continue;
                object2 = objectIdGenerator2;
                break;
            }
        }
        if (object2 == null) {
            object2 = objectIdGenerator.newForSerialization(this);
            this._objectIdGenerators.add(object2);
        }
        WritableObjectId writableObjectId = new WritableObjectId((ObjectIdGenerator)object2);
        this._seenObjectIds.put(object, writableObjectId);
        return writableObjectId;
    }

    public JsonSerializer serializerInstance(Annotated annotated, Object object) {
        JsonSerializer jsonSerializer;
        if (object == null) {
            return null;
        }
        if (object instanceof JsonSerializer) {
            jsonSerializer = (JsonSerializer)object;
        } else {
            if (!(object instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned serializer definition of type " + object.getClass().getName() + "; expected type JsonSerializer or Class<JsonSerializer> instead");
            }
            Class clazz = (Class)object;
            if (clazz == JsonSerializer$None.class || clazz == NoClass.class) {
                return null;
            }
            if (!JsonSerializer.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + clazz.getName() + "; expected Class<JsonSerializer>");
            }
            HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
            jsonSerializer = handlerInstantiator != null ? handlerInstantiator.serializerInstance(this._config, annotated, clazz) : (JsonSerializer)ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
        }
        return this._handleResolvable(jsonSerializer);
    }
}

