/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.module;

import com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.ClassKey;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public class SimpleAbstractTypeResolver
extends AbstractTypeResolver {
    protected final HashMap _mappings = new HashMap();

    public SimpleAbstractTypeResolver addMapping(Class clazz, Class clazz2) {
        if (clazz == clazz2) {
            throw new IllegalArgumentException("Can not add mapping from class to itself");
        }
        if (!clazz.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException("Can not add mapping from class " + clazz.getName() + " to " + clazz2.getName() + ", as latter is not a subtype of former");
        }
        if (!Modifier.isAbstract(clazz.getModifiers())) {
            throw new IllegalArgumentException("Can not add mapping from class " + clazz.getName() + " since it is not abstract");
        }
        this._mappings.put(new ClassKey(clazz), clazz2);
        return this;
    }

    public JavaType findTypeMapping(DeserializationConfig deserializationConfig, JavaType javaType) {
        Class clazz = javaType.getRawClass();
        Class clazz2 = (Class)this._mappings.get(new ClassKey(clazz));
        if (clazz2 == null) {
            return null;
        }
        return javaType.narrowBy(clazz2);
    }

    public JavaType resolveAbstractType(DeserializationConfig deserializationConfig, JavaType javaType) {
        return null;
    }
}

