/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter$FixedSpaceIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter$Indenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter$Lf2SpacesIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter$NopIndenter;

public class DefaultPrettyPrinter
implements PrettyPrinter {
    protected DefaultPrettyPrinter$Indenter _arrayIndenter = new DefaultPrettyPrinter$FixedSpaceIndenter();
    protected DefaultPrettyPrinter$Indenter _objectIndenter = new DefaultPrettyPrinter$Lf2SpacesIndenter();
    protected boolean _spacesInObjectEntries = true;
    protected int _nesting = 0;

    public void indentArraysWith(DefaultPrettyPrinter$Indenter defaultPrettyPrinter$Indenter) {
        this._arrayIndenter = defaultPrettyPrinter$Indenter == null ? new DefaultPrettyPrinter$NopIndenter() : defaultPrettyPrinter$Indenter;
    }

    public void indentObjectsWith(DefaultPrettyPrinter$Indenter defaultPrettyPrinter$Indenter) {
        this._objectIndenter = defaultPrettyPrinter$Indenter == null ? new DefaultPrettyPrinter$NopIndenter() : defaultPrettyPrinter$Indenter;
    }

    public void spacesInObjectEntries(boolean bl) {
        this._spacesInObjectEntries = bl;
    }

    public void writeRootValueSeparator(JsonGenerator jsonGenerator) {
        jsonGenerator.writeRaw(' ');
    }

    public void writeStartObject(JsonGenerator jsonGenerator) {
        jsonGenerator.writeRaw('{');
        if (!this._objectIndenter.isInline()) {
            ++this._nesting;
        }
    }

    public void beforeObjectEntries(JsonGenerator jsonGenerator) {
        this._objectIndenter.writeIndentation(jsonGenerator, this._nesting);
    }

    public void writeObjectFieldValueSeparator(JsonGenerator jsonGenerator) {
        if (this._spacesInObjectEntries) {
            jsonGenerator.writeRaw(" : ");
        } else {
            jsonGenerator.writeRaw(':');
        }
    }

    public void writeObjectEntrySeparator(JsonGenerator jsonGenerator) {
        jsonGenerator.writeRaw(',');
        this._objectIndenter.writeIndentation(jsonGenerator, this._nesting);
    }

    public void writeEndObject(JsonGenerator jsonGenerator, int n2) {
        if (!this._objectIndenter.isInline()) {
            --this._nesting;
        }
        if (n2 > 0) {
            this._objectIndenter.writeIndentation(jsonGenerator, this._nesting);
        } else {
            jsonGenerator.writeRaw(' ');
        }
        jsonGenerator.writeRaw('}');
    }

    public void writeStartArray(JsonGenerator jsonGenerator) {
        if (!this._arrayIndenter.isInline()) {
            ++this._nesting;
        }
        jsonGenerator.writeRaw('[');
    }

    public void beforeArrayValues(JsonGenerator jsonGenerator) {
        this._arrayIndenter.writeIndentation(jsonGenerator, this._nesting);
    }

    public void writeArrayValueSeparator(JsonGenerator jsonGenerator) {
        jsonGenerator.writeRaw(',');
        this._arrayIndenter.writeIndentation(jsonGenerator, this._nesting);
    }

    public void writeEndArray(JsonGenerator jsonGenerator, int n2) {
        if (!this._arrayIndenter.isInline()) {
            --this._nesting;
        }
        if (n2 > 0) {
            this._arrayIndenter.writeIndentation(jsonGenerator, this._nesting);
        } else {
            jsonGenerator.writeRaw(' ');
        }
        jsonGenerator.writeRaw(']');
    }
}

