/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.io.CharTypes;

public final class JsonReadContext
extends JsonStreamContext {
    protected final JsonReadContext _parent;
    protected int _lineNr;
    protected int _columnNr;
    protected String _currentName;
    protected JsonReadContext _child = null;

    public JsonReadContext(JsonReadContext jsonReadContext, int n2, int n3, int n4) {
        this._type = n2;
        this._parent = jsonReadContext;
        this._lineNr = n3;
        this._columnNr = n4;
        this._index = -1;
    }

    protected final void reset(int n2, int n3, int n4) {
        this._type = n2;
        this._index = -1;
        this._lineNr = n3;
        this._columnNr = n4;
        this._currentName = null;
    }

    public static JsonReadContext createRootContext(int n2, int n3) {
        return new JsonReadContext(null, 0, n2, n3);
    }

    public static JsonReadContext createRootContext() {
        return new JsonReadContext(null, 0, 1, 0);
    }

    public final JsonReadContext createChildArrayContext(int n2, int n3) {
        JsonReadContext jsonReadContext = this._child;
        if (jsonReadContext == null) {
            this._child = jsonReadContext = new JsonReadContext(this, 1, n2, n3);
            return jsonReadContext;
        }
        jsonReadContext.reset(1, n2, n3);
        return jsonReadContext;
    }

    public final JsonReadContext createChildObjectContext(int n2, int n3) {
        JsonReadContext jsonReadContext = this._child;
        if (jsonReadContext == null) {
            this._child = jsonReadContext = new JsonReadContext(this, 2, n2, n3);
            return jsonReadContext;
        }
        jsonReadContext.reset(2, n2, n3);
        return jsonReadContext;
    }

    public final String getCurrentName() {
        return this._currentName;
    }

    public final JsonReadContext getParent() {
        return this._parent;
    }

    public final JsonLocation getStartLocation(Object object) {
        long l2 = -1L;
        return new JsonLocation(object, l2, this._lineNr, this._columnNr);
    }

    public final boolean expectComma() {
        int n2 = ++this._index;
        return this._type != 0 && n2 > 0;
    }

    public void setCurrentName(String string) {
        this._currentName = string;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        switch (this._type) {
            case 0: {
                stringBuilder.append("/");
                break;
            }
            case 1: {
                stringBuilder.append('[');
                stringBuilder.append(this.getCurrentIndex());
                stringBuilder.append(']');
                break;
            }
            case 2: {
                stringBuilder.append('{');
                if (this._currentName != null) {
                    stringBuilder.append('\"');
                    CharTypes.appendQuoted(stringBuilder, this._currentName);
                    stringBuilder.append('\"');
                } else {
                    stringBuilder.append('?');
                }
                stringBuilder.append('}');
            }
        }
        return stringBuilder.toString();
    }
}

