/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jaxrs.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.jaxrs.json.Annotations;
import com.fasterxml.jackson.jaxrs.json.ModuleVersion;
import com.fasterxml.jackson.jaxrs.json.annotation.EndpointConfig;
import com.fasterxml.jackson.jaxrs.json.cfg.MapperConfigurator;
import com.fasterxml.jackson.jaxrs.json.util.AnnotationBundleKey;
import com.fasterxml.jackson.jaxrs.json.util.ClassKey;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

@Provider
@Consumes(value={"*/*"})
@Produces(value={"*/*"})
public class JacksonJsonProvider
implements Versioned,
MessageBodyReader,
MessageBodyWriter {
    public static final Annotations[] BASIC_ANNOTATIONS = new Annotations[]{Annotations.JACKSON};
    public static final HashSet _untouchables = new HashSet();
    public static final Class[] _unreadableClasses;
    public static final Class[] _unwritableClasses;
    protected final LRUMap _readers = new LRUMap(16, 120);
    protected final LRUMap _writers = new LRUMap(16, 120);
    protected final MapperConfigurator _mapperConfig;
    protected HashSet _cfgCustomUntouchables;
    protected String _jsonpFunctionName;
    @Context
    protected Providers _providers;
    protected boolean _cfgCheckCanSerialize = false;
    protected boolean _cfgCheckCanDeserialize = false;

    public JacksonJsonProvider() {
        this((ObjectMapper)null, BASIC_ANNOTATIONS);
    }

    public JacksonJsonProvider(Annotations ... annotationsArray) {
        this((ObjectMapper)null, annotationsArray);
    }

    public JacksonJsonProvider(ObjectMapper objectMapper) {
        this(objectMapper, BASIC_ANNOTATIONS);
    }

    public JacksonJsonProvider(ObjectMapper objectMapper, Annotations[] annotationsArray) {
        this._mapperConfig = new MapperConfigurator(objectMapper, annotationsArray);
    }

    public Version version() {
        return ModuleVersion.instance.version();
    }

    public void checkCanDeserialize(boolean bl) {
        this._cfgCheckCanDeserialize = bl;
    }

    public void checkCanSerialize(boolean bl) {
        this._cfgCheckCanSerialize = bl;
    }

    public void setAnnotationsToUse(Annotations[] annotationsArray) {
        this._mapperConfig.setAnnotationsToUse(annotationsArray);
    }

    public void setMapper(ObjectMapper objectMapper) {
        this._mapperConfig.setMapper(objectMapper);
    }

    public JacksonJsonProvider configure(DeserializationFeature deserializationFeature, boolean bl) {
        this._mapperConfig.configure(deserializationFeature, bl);
        return this;
    }

    public JacksonJsonProvider configure(SerializationFeature serializationFeature, boolean bl) {
        this._mapperConfig.configure(serializationFeature, bl);
        return this;
    }

    public JacksonJsonProvider configure(JsonParser$Feature jsonParser$Feature, boolean bl) {
        this._mapperConfig.configure(jsonParser$Feature, bl);
        return this;
    }

    public JacksonJsonProvider configure(JsonGenerator$Feature jsonGenerator$Feature, boolean bl) {
        this._mapperConfig.configure(jsonGenerator$Feature, bl);
        return this;
    }

    public JacksonJsonProvider enable(DeserializationFeature deserializationFeature, boolean bl) {
        this._mapperConfig.configure(deserializationFeature, true);
        return this;
    }

    public JacksonJsonProvider enable(SerializationFeature serializationFeature, boolean bl) {
        this._mapperConfig.configure(serializationFeature, true);
        return this;
    }

    public JacksonJsonProvider enable(JsonParser$Feature jsonParser$Feature, boolean bl) {
        this._mapperConfig.configure(jsonParser$Feature, true);
        return this;
    }

    public JacksonJsonProvider enable(JsonGenerator$Feature jsonGenerator$Feature, boolean bl) {
        this._mapperConfig.configure(jsonGenerator$Feature, true);
        return this;
    }

    public JacksonJsonProvider disable(DeserializationFeature deserializationFeature, boolean bl) {
        this._mapperConfig.configure(deserializationFeature, false);
        return this;
    }

    public JacksonJsonProvider disable(SerializationFeature serializationFeature, boolean bl) {
        this._mapperConfig.configure(serializationFeature, false);
        return this;
    }

    public JacksonJsonProvider disable(JsonParser$Feature jsonParser$Feature, boolean bl) {
        this._mapperConfig.configure(jsonParser$Feature, false);
        return this;
    }

    public JacksonJsonProvider disable(JsonGenerator$Feature jsonGenerator$Feature, boolean bl) {
        this._mapperConfig.configure(jsonGenerator$Feature, false);
        return this;
    }

    public void addUntouchable(Class clazz) {
        if (this._cfgCustomUntouchables == null) {
            this._cfgCustomUntouchables = new HashSet();
        }
        this._cfgCustomUntouchables.add(new ClassKey(clazz));
    }

    public void setJSONPFunctionName(String string) {
        this._jsonpFunctionName = string;
    }

    public boolean isReadable(Class clazz, Type type, Annotation[] annotationArray, MediaType mediaType) {
        if (!this.isJsonType(mediaType)) {
            return false;
        }
        if (_untouchables.contains(new ClassKey(clazz))) {
            return false;
        }
        Object object = _unreadableClasses;
        int n2 = ((Class[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Class clazz2 = object[i2];
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return false;
        }
        if (JacksonJsonProvider._containedIn(clazz, this._cfgCustomUntouchables)) {
            return false;
        }
        return !this._cfgCheckCanSerialize || ((ObjectMapper)(object = this.locateMapper(clazz, mediaType))).canDeserialize(((ObjectMapper)object).constructType(clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readFrom(Class clazz, Type type, Annotation[] annotationArray, MediaType mediaType, MultivaluedMap multivaluedMap, InputStream inputStream) {
        Object object;
        EndpointConfig endpointConfig;
        AnnotationBundleKey annotationBundleKey = new AnnotationBundleKey(annotationArray);
        Object object2 = this._readers;
        synchronized (object2) {
            endpointConfig = (EndpointConfig)this._readers.get(annotationBundleKey);
        }
        if (endpointConfig == null) {
            object2 = this.locateMapper(clazz, mediaType);
            endpointConfig = EndpointConfig.forReading((ObjectMapper)object2, annotationArray);
            object = this._readers;
            synchronized (object) {
                this._readers.put(annotationBundleKey.immutableKey(), endpointConfig);
            }
        }
        object2 = endpointConfig.getReader();
        object = ((ObjectReader)object2).getJsonFactory().createJsonParser(inputStream);
        return ((ObjectReader)object2).withType(type).readValue((JsonParser)object);
    }

    public long getSize(Object object, Class clazz, Type type, Annotation[] annotationArray, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class clazz, Type type, Annotation[] annotationArray, MediaType mediaType) {
        if (!this.isJsonType(mediaType)) {
            return false;
        }
        if (_untouchables.contains(new ClassKey(clazz))) {
            return false;
        }
        for (Class clazz2 : _unwritableClasses) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return false;
        }
        if (JacksonJsonProvider._containedIn(clazz, this._cfgCustomUntouchables)) {
            return false;
        }
        return !this._cfgCheckCanSerialize || this.locateMapper(clazz, mediaType).canSerialize(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Object object, Class clazz, Type type, Annotation[] annotationArray, MediaType mediaType, MultivaluedMap multivaluedMap, OutputStream outputStream) {
        Object object2;
        EndpointConfig endpointConfig;
        AnnotationBundleKey annotationBundleKey = new AnnotationBundleKey(annotationArray);
        Object object3 = this._writers;
        synchronized (object3) {
            endpointConfig = (EndpointConfig)this._writers.get(annotationBundleKey);
        }
        if (endpointConfig == null) {
            object3 = this.locateMapper(clazz, mediaType);
            endpointConfig = EndpointConfig.forWriting((ObjectMapper)object3, annotationArray, this._jsonpFunctionName);
            object2 = this._writers;
            synchronized (object2) {
                this._writers.put(annotationBundleKey.immutableKey(), endpointConfig);
            }
        }
        object3 = endpointConfig.getWriter();
        object2 = this.findEncoding(mediaType, multivaluedMap);
        JsonGenerator jsonGenerator = ((ObjectWriter)object3).getJsonFactory().createJsonGenerator(outputStream, (JsonEncoding)((Object)object2));
        if (((ObjectWriter)object3).isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            jsonGenerator.useDefaultPrettyPrinter();
        }
        JavaType javaType = null;
        if (type != null && object != null && type.getClass() != Class.class && (javaType = ((ObjectWriter)object3).getTypeFactory().constructType(type)).getRawClass() == Object.class) {
            javaType = null;
        }
        if (javaType != null) {
            object3 = ((ObjectWriter)object3).withType(javaType);
        }
        object = endpointConfig.applyJSONP(object);
        ((ObjectWriter)object3).writeValue(jsonGenerator, object);
    }

    protected JsonEncoding findEncoding(MediaType mediaType, MultivaluedMap multivaluedMap) {
        return JsonEncoding.UTF8;
    }

    protected boolean isJsonType(MediaType mediaType) {
        if (mediaType != null) {
            String string = mediaType.getSubtype();
            return "json".equalsIgnoreCase(string) || string.endsWith("+json");
        }
        return true;
    }

    public ObjectMapper locateMapper(Class clazz, MediaType mediaType) {
        ObjectMapper objectMapper = this._mapperConfig.getConfiguredMapper();
        if (objectMapper == null) {
            if (this._providers != null) {
                ContextResolver contextResolver = this._providers.getContextResolver(ObjectMapper.class, mediaType);
                if (contextResolver == null) {
                    contextResolver = this._providers.getContextResolver(ObjectMapper.class, null);
                }
                if (contextResolver != null) {
                    objectMapper = (ObjectMapper)contextResolver.getContext(clazz);
                }
            }
            if (objectMapper == null) {
                objectMapper = this._mapperConfig.getDefaultMapper();
            }
        }
        return objectMapper;
    }

    protected static boolean _containedIn(Class clazz, HashSet hashSet) {
        if (hashSet != null) {
            ClassKey classKey = new ClassKey(clazz);
            if (hashSet.contains(classKey)) {
                return true;
            }
            for (Class clazz2 : JacksonJsonProvider.findSuperTypes(clazz, null)) {
                classKey.reset(clazz2);
                if (!hashSet.contains(classKey)) continue;
                return true;
            }
        }
        return false;
    }

    private static List findSuperTypes(Class clazz, Class clazz2) {
        return JacksonJsonProvider.findSuperTypes(clazz, clazz2, new ArrayList(8));
    }

    private static List findSuperTypes(Class clazz, Class clazz2, List list) {
        JacksonJsonProvider._addSuperTypes(clazz, clazz2, list, false);
        return list;
    }

    private static void _addSuperTypes(Class clazz, Class clazz2, Collection collection, boolean bl) {
        if (clazz == clazz2 || clazz == null || clazz == Object.class) {
            return;
        }
        if (bl) {
            if (collection.contains(clazz)) {
                return;
            }
            collection.add(clazz);
        }
        for (Class<?> clazz3 : clazz.getInterfaces()) {
            JacksonJsonProvider._addSuperTypes(clazz3, clazz2, collection, true);
        }
        JacksonJsonProvider._addSuperTypes(clazz.getSuperclass(), clazz2, collection, true);
    }

    static {
        _untouchables.add(new ClassKey(InputStream.class));
        _untouchables.add(new ClassKey(Reader.class));
        _untouchables.add(new ClassKey(OutputStream.class));
        _untouchables.add(new ClassKey(Writer.class));
        _untouchables.add(new ClassKey(char[].class));
        _untouchables.add(new ClassKey(String.class));
        _untouchables.add(new ClassKey(byte[].class));
        _unreadableClasses = new Class[]{InputStream.class, Reader.class};
        _unwritableClasses = new Class[]{OutputStream.class, Writer.class, StreamingOutput.class, Response.class};
    }
}

