/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat$Value;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public abstract class DateDeserializers$DateBasedDeserializer
extends StdScalarDeserializer
implements ContextualDeserializer {
    protected final DateFormat _customFormat;
    protected final String _formatString;

    protected DateDeserializers$DateBasedDeserializer(Class clazz) {
        super(clazz);
        this._customFormat = null;
        this._formatString = null;
    }

    protected DateDeserializers$DateBasedDeserializer(DateDeserializers$DateBasedDeserializer dateDeserializers$DateBasedDeserializer, DateFormat dateFormat, String string) {
        super(dateDeserializers$DateBasedDeserializer._valueClass);
        this._customFormat = dateFormat;
        this._formatString = string;
    }

    protected abstract DateDeserializers$DateBasedDeserializer withDateFormat(DateFormat var1, String var2);

    public JsonDeserializer createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) {
        JsonFormat$Value jsonFormat$Value;
        if (beanProperty != null && (jsonFormat$Value = deserializationContext.getAnnotationIntrospector().findFormat(beanProperty.getMember())) != null) {
            TimeZone timeZone = jsonFormat$Value.getTimeZone();
            String string = jsonFormat$Value.getPattern();
            if (string.length() > 0) {
                Locale locale = jsonFormat$Value.getLocale();
                if (locale == null) {
                    locale = deserializationContext.getLocale();
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
                if (timeZone == null) {
                    timeZone = deserializationContext.getTimeZone();
                }
                simpleDateFormat.setTimeZone(timeZone);
                return this.withDateFormat(simpleDateFormat, string);
            }
            if (timeZone != null) {
                DateFormat dateFormat = deserializationContext.getConfig().getDateFormat();
                if (dateFormat.getClass() == StdDateFormat.class) {
                    dateFormat = ((StdDateFormat)dateFormat).withTimeZone(timeZone);
                } else {
                    dateFormat = (DateFormat)dateFormat.clone();
                    dateFormat.setTimeZone(timeZone);
                }
                return this.withDateFormat(dateFormat, string);
            }
        }
        return this;
    }

    protected Date _parseDate(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (this._customFormat != null && jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return (Date)this.getEmptyValue();
            }
            DateFormat dateFormat = this._customFormat;
            synchronized (dateFormat) {
                try {
                    return this._customFormat.parse(string);
                }
                catch (ParseException parseException) {
                    throw new IllegalArgumentException("Failed to parse Date value '" + string + "' (format: \"" + this._formatString + "\"): " + parseException.getMessage());
                }
            }
        }
        return super._parseDate(jsonParser, deserializationContext);
    }
}

