/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.ArraySerializerBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;

@JacksonStdImpl
public class StringArraySerializer
extends ArraySerializerBase
implements ContextualSerializer {
    private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(String.class);
    public static final StringArraySerializer instance = new StringArraySerializer();
    protected final JsonSerializer _elementSerializer;

    protected StringArraySerializer() {
        super(String[].class, null);
        this._elementSerializer = null;
    }

    public StringArraySerializer(StringArraySerializer stringArraySerializer, BeanProperty beanProperty, JsonSerializer jsonSerializer) {
        super(stringArraySerializer, beanProperty);
        this._elementSerializer = jsonSerializer;
    }

    public ContainerSerializer _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return this;
    }

    public JsonSerializer createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) {
        JsonSerializer jsonSerializer = this._elementSerializer;
        if (jsonSerializer == null) {
            jsonSerializer = serializerProvider.findValueSerializer(String.class, beanProperty);
        } else if (jsonSerializer instanceof ContextualSerializer) {
            jsonSerializer = ((ContextualSerializer)((Object)jsonSerializer)).createContextual(serializerProvider, beanProperty);
        }
        if (this.isDefaultSerializer(jsonSerializer)) {
            jsonSerializer = null;
        }
        if (jsonSerializer == this._elementSerializer) {
            return this;
        }
        return new StringArraySerializer(this, beanProperty, jsonSerializer);
    }

    public JavaType getContentType() {
        return VALUE_TYPE;
    }

    public JsonSerializer getContentSerializer() {
        return this._elementSerializer;
    }

    public boolean isEmpty(String[] stringArray) {
        return stringArray == null || stringArray.length == 0;
    }

    public boolean hasSingleElement(String[] stringArray) {
        return stringArray.length == 1;
    }

    public void serializeContents(String[] stringArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        int n2 = stringArray.length;
        if (n2 == 0) {
            return;
        }
        if (this._elementSerializer != null) {
            this.serializeContentsSlow(stringArray, jsonGenerator, serializerProvider, this._elementSerializer);
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            if (string == null) {
                jsonGenerator.writeNull();
                continue;
            }
            jsonGenerator.writeString(stringArray[i2]);
        }
    }

    private void serializeContentsSlow(String[] stringArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer jsonSerializer) {
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            if (string == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            jsonSerializer.serialize(stringArray[i2], jsonGenerator, serializerProvider);
        }
    }

    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        ObjectNode objectNode = this.createSchemaNode("array", true);
        objectNode.put("items", this.createSchemaNode("string"));
        return objectNode;
    }
}

