/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;

public abstract class FromStringDeserializer
extends StdScalarDeserializer {
    public FromStringDeserializer(Class clazz) {
        super(clazz);
    }

    public final Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return null;
            }
            try {
                Object object = this._deserialize(string, deserializationContext);
                if (object != null) {
                    return object;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            throw deserializationContext.weirdStringException(this._valueClass, "not a valid textual representation");
        }
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object object = jsonParser.getEmbeddedObject();
            if (object == null) {
                return null;
            }
            if (this._valueClass.isAssignableFrom(object.getClass())) {
                return object;
            }
            return this._deserializeEmbedded(object, deserializationContext);
        }
        throw deserializationContext.mappingException(this._valueClass);
    }

    protected abstract Object _deserialize(String var1, DeserializationContext var2);

    protected Object _deserializeEmbedded(Object object, DeserializationContext deserializationContext) {
        throw deserializationContext.mappingException("Don't know how to convert embedded Object of type " + object.getClass().getName() + " into " + this._valueClass.getName());
    }
}

