/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.PropertyValue;
import com.fasterxml.jackson.databind.deser.impl.PropertyValue$Any;
import com.fasterxml.jackson.databind.deser.impl.PropertyValue$Map;
import com.fasterxml.jackson.databind.deser.impl.PropertyValue$Regular;

public final class PropertyValueBuffer {
    protected final JsonParser _parser;
    protected final DeserializationContext _context;
    protected final Object[] _creatorParameters;
    private int _paramsNeeded;
    private PropertyValue _buffered;

    public PropertyValueBuffer(JsonParser jsonParser, DeserializationContext deserializationContext, int n2) {
        this._parser = jsonParser;
        this._context = deserializationContext;
        this._paramsNeeded = n2;
        this._creatorParameters = new Object[n2];
    }

    public void inject(SettableBeanProperty[] settableBeanPropertyArray) {
        for (SettableBeanProperty settableBeanProperty : settableBeanPropertyArray) {
            if (settableBeanProperty == null) continue;
            this._creatorParameters[var2_2] = this._context.findInjectableValue(settableBeanProperty.getInjectableValueId(), settableBeanProperty, null);
        }
    }

    protected final Object[] getParameters(Object[] objectArray) {
        if (objectArray != null) {
            int n2 = this._creatorParameters.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object;
                if (this._creatorParameters[i2] != null || (object = objectArray[i2]) == null) continue;
                this._creatorParameters[i2] = object;
            }
        }
        return this._creatorParameters;
    }

    protected PropertyValue buffered() {
        return this._buffered;
    }

    public boolean isComplete() {
        return this._paramsNeeded <= 0;
    }

    public boolean assignParameter(int n2, Object object) {
        this._creatorParameters[n2] = object;
        return --this._paramsNeeded <= 0;
    }

    public void bufferProperty(SettableBeanProperty settableBeanProperty, Object object) {
        this._buffered = new PropertyValue$Regular(this._buffered, object, settableBeanProperty);
    }

    public void bufferAnyProperty(SettableAnyProperty settableAnyProperty, String string, Object object) {
        this._buffered = new PropertyValue$Any(this._buffered, object, settableAnyProperty, string);
    }

    public void bufferMapProperty(Object object, Object object2) {
        this._buffered = new PropertyValue$Map(this._buffered, object2, object);
    }
}

