/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.Annotations;
import java.lang.annotation.Annotation;

public class CreatorProperty
extends SettableBeanProperty {
    protected final AnnotatedParameter _annotated;
    protected final Object _injectableValueId;

    public CreatorProperty(String string, JavaType javaType, TypeDeserializer typeDeserializer, Annotations annotations, AnnotatedParameter annotatedParameter, int n2, Object object) {
        super(string, javaType, typeDeserializer, annotations);
        this._annotated = annotatedParameter;
        this._propertyIndex = n2;
        this._injectableValueId = object;
    }

    protected CreatorProperty(CreatorProperty creatorProperty, String string) {
        super((SettableBeanProperty)creatorProperty, string);
        this._annotated = creatorProperty._annotated;
        this._injectableValueId = creatorProperty._injectableValueId;
    }

    protected CreatorProperty(CreatorProperty creatorProperty, JsonDeserializer jsonDeserializer) {
        super((SettableBeanProperty)creatorProperty, jsonDeserializer);
        this._annotated = creatorProperty._annotated;
        this._injectableValueId = creatorProperty._injectableValueId;
    }

    public CreatorProperty withName(String string) {
        return new CreatorProperty(this, string);
    }

    public CreatorProperty withValueDeserializer(JsonDeserializer jsonDeserializer) {
        return new CreatorProperty(this, jsonDeserializer);
    }

    public Object findInjectableValue(DeserializationContext deserializationContext, Object object) {
        if (this._injectableValueId == null) {
            throw new IllegalStateException("Property '" + this.getName() + "' (type " + this.getClass().getName() + ") has no injectable value id configured");
        }
        return deserializationContext.findInjectableValue(this._injectableValueId, this, object);
    }

    public void inject(DeserializationContext deserializationContext, Object object) {
        this.set(object, this.findInjectableValue(deserializationContext, object));
    }

    public Annotation getAnnotation(Class clazz) {
        if (this._annotated == null) {
            return null;
        }
        return this._annotated.getAnnotation(clazz);
    }

    public AnnotatedMember getMember() {
        return this._annotated;
    }

    public void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        this.set(object, this.deserialize(jsonParser, deserializationContext));
    }

    public Object deserializeSetAndReturn(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        return this.setAndReturn(object, this.deserialize(jsonParser, deserializationContext));
    }

    public void set(Object object, Object object2) {
        throw new IllegalStateException("Method should never be called on a " + this.getClass().getName());
    }

    public Object setAndReturn(Object object, Object object2) {
        return object;
    }

    public Object getInjectableValueId() {
        return this._injectableValueId;
    }

    public String toString() {
        return "[creator property, name '" + this.getName() + "'; inject id '" + this._injectableValueId + "']";
    }
}

