/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserBase;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.CoreVersion;
import com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.TextBuffer;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public final class ReaderBasedJsonParser
extends ParserBase {
    protected Reader _reader;
    protected char[] _inputBuffer;
    protected ObjectCodec _objectCodec;
    protected final CharsToNameCanonicalizer _symbols;
    protected final int _hashSeed;
    protected boolean _tokenIncomplete = false;

    public ReaderBasedJsonParser(IOContext iOContext, int n2, Reader reader, ObjectCodec objectCodec, CharsToNameCanonicalizer charsToNameCanonicalizer) {
        super(iOContext, n2);
        this._reader = reader;
        this._inputBuffer = iOContext.allocTokenBuffer();
        this._objectCodec = objectCodec;
        this._symbols = charsToNameCanonicalizer;
        this._hashSeed = charsToNameCanonicalizer.hashSeed();
    }

    public Version version() {
        return CoreVersion.instance.version();
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    public int releaseBuffered(Writer writer) {
        int n2 = this._inputEnd - this._inputPtr;
        if (n2 < 1) {
            return 0;
        }
        int n3 = this._inputPtr;
        writer.write(this._inputBuffer, n3, n2);
        return n2;
    }

    public Object getInputSource() {
        return this._reader;
    }

    protected final boolean loadMore() {
        this._currInputProcessed += (long)this._inputEnd;
        this._currInputRowStart -= this._inputEnd;
        if (this._reader != null) {
            int n2 = this._reader.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (n2 > 0) {
                this._inputPtr = 0;
                this._inputEnd = n2;
                return true;
            }
            this._closeInput();
            if (n2 == 0) {
                throw new IOException("Reader returned 0 characters when trying to read " + this._inputEnd);
            }
        }
        return false;
    }

    protected final char getNextChar(String string) {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(string);
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected void _closeInput() {
        if (this._reader != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser$Feature.AUTO_CLOSE_SOURCE)) {
                this._reader.close();
            }
            this._reader = null;
        }
    }

    protected void _releaseBuffers() {
        super._releaseBuffers();
        char[] cArray = this._inputBuffer;
        if (cArray != null) {
            this._inputBuffer = null;
            this._ioContext.releaseTokenBuffer(cArray);
        }
    }

    public final String getText() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return this._getText2(jsonToken);
    }

    protected final String _getText2(JsonToken jsonToken) {
        if (jsonToken == null) {
            return null;
        }
        switch (jsonToken) {
            case FIELD_NAME: {
                return this._parsingContext.getCurrentName();
            }
            case VALUE_STRING: 
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return this._textBuffer.contentsAsString();
            }
        }
        return jsonToken.asString();
    }

    public char[] getTextCharacters() {
        if (this._currToken != null) {
            switch (this._currToken) {
                case FIELD_NAME: {
                    if (!this._nameCopied) {
                        String string = this._parsingContext.getCurrentName();
                        int n2 = string.length();
                        if (this._nameCopyBuffer == null) {
                            this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n2);
                        } else if (this._nameCopyBuffer.length < n2) {
                            this._nameCopyBuffer = new char[n2];
                        }
                        string.getChars(0, n2, this._nameCopyBuffer, 0);
                        this._nameCopied = true;
                    }
                    return this._nameCopyBuffer;
                }
                case VALUE_STRING: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this._textBuffer.getTextBuffer();
                }
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    public int getTextLength() {
        if (this._currToken != null) {
            switch (this._currToken) {
                case FIELD_NAME: {
                    return this._parsingContext.getCurrentName().length();
                }
                case VALUE_STRING: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this._textBuffer.size();
                }
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    public int getTextOffset() {
        if (this._currToken != null) {
            switch (this._currToken) {
                case FIELD_NAME: {
                    return 0;
                }
                case VALUE_STRING: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this._textBuffer.getTextOffset();
                }
            }
        }
        return 0;
    }

    public Object getEmbeddedObject() {
        return null;
    }

    public byte[] getBinaryValue(Base64Variant base64Variant) {
        if (this._currToken != JsonToken.VALUE_STRING && (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT || this._binaryValue == null)) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._tokenIncomplete) {
            try {
                this._binaryValue = this._decodeBase64(base64Variant);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
            }
            this._tokenIncomplete = false;
        } else if (this._binaryValue == null) {
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            this._decodeBase64(this.getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    public JsonToken nextToken() {
        Object object;
        boolean bl;
        int n2;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nextAfterName();
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n2 = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr - 1L;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = this._inputPtr - this._currInputRowStart - 1;
        this._binaryValue = null;
        if (n2 == 93) {
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n2, '}');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_ARRAY;
            return this._currToken;
        }
        if (n2 == 125) {
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n2, ']');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_OBJECT;
            return this._currToken;
        }
        if (this._parsingContext.expectComma()) {
            if (n2 != 44) {
                this._reportUnexpectedChar(n2, "was expecting comma to separate " + this._parsingContext.getTypeDesc() + " entries");
            }
            n2 = this._skipWS();
        }
        if (bl = this._parsingContext.inObject()) {
            object = this._parseFieldName(n2);
            this._parsingContext.setCurrentName((String)object);
            this._currToken = JsonToken.FIELD_NAME;
            n2 = this._skipWS();
            if (n2 != 58) {
                this._reportUnexpectedChar(n2, "was expecting a colon to separate field name and value");
            }
            n2 = this._skipWS();
        }
        switch (n2) {
            case 34: {
                this._tokenIncomplete = true;
                object = JsonToken.VALUE_STRING;
                break;
            }
            case 91: {
                if (!bl) {
                    this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                }
                object = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                if (!bl) {
                    this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                }
                object = JsonToken.START_OBJECT;
                break;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(n2, "expected a value");
            }
            case 116: {
                this._matchToken("true", 1);
                object = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                this._matchToken("false", 1);
                object = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchToken("null", 1);
                object = JsonToken.VALUE_NULL;
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                object = this.parseNumberText(n2);
                break;
            }
            default: {
                object = this._handleUnexpectedValue(n2);
            }
        }
        if (bl) {
            this._nextToken = object;
            return this._currToken;
        }
        this._currToken = object;
        return object;
    }

    private final JsonToken _nextAfterName() {
        this._nameCopied = false;
        JsonToken jsonToken = this._nextToken;
        this._nextToken = null;
        if (jsonToken == JsonToken.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
        } else if (jsonToken == JsonToken.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
        }
        this._currToken = jsonToken;
        return this._currToken;
    }

    public String nextTextValue() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_STRING) {
                if (this._tokenIncomplete) {
                    this._tokenIncomplete = false;
                    this._finishString();
                }
                return this._textBuffer.contentsAsString();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getText() : null;
    }

    public int nextIntValue(int n2) {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getIntValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return n2;
        }
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getIntValue() : n2;
    }

    public long nextLongValue(long l2) {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getLongValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return l2;
        }
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getLongValue() : l2;
    }

    public Boolean nextBooleanValue() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        switch (this.nextToken()) {
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public void close() {
        super.close();
        this._symbols.release();
    }

    /*
     * Unable to fully structure code
     */
    protected final JsonToken parseNumberText(int var1_1) {
        block12: {
            block11: {
                var2_2 = var1_1 == 45;
                var3_3 = this._inputPtr;
                var4_4 = var3_3 - 1;
                var5_5 = this._inputEnd;
                if (!var2_2) break block11;
                if (var3_3 < this._inputEnd) {
                    if ((var1_1 = this._inputBuffer[var3_3++]) > 57 || var1_1 < 48) {
                        this._inputPtr = var3_3;
                        return this._handleInvalidNumberStart(var1_1, true);
                    } else {
                        ** GOTO lbl11
                    }
                }
                break block12;
            }
            if (var1_1 == 48) break block12;
            var6_6 = 1;
            block0: while (var3_3 < this._inputEnd) {
                if ((var1_1 = this._inputBuffer[var3_3++]) >= 48 && var1_1 <= 57) {
                    ++var6_6;
                    continue;
                }
                var7_7 = 0;
                if (var1_1 != 46) ** GOTO lbl26
                while (var3_3 < var5_5) {
                    if ((var1_1 = this._inputBuffer[var3_3++]) >= 48 && var1_1 <= 57) {
                        ++var7_7;
                        continue;
                    }
                    if (var7_7 == 0) {
                        this.reportUnexpectedNumberChar(var1_1, "Decimal point not followed by a digit");
                    }
lbl26:
                    // 4 sources

                    var8_8 = 0;
                    if (var1_1 == 101 || var1_1 == 69) {
                        if (var3_3 >= var5_5) break block0;
                        if ((var1_1 = this._inputBuffer[var3_3++]) == 45 || var1_1 == 43) {
                            if (var3_3 >= var5_5) break block0;
                            var1_1 = this._inputBuffer[var3_3++];
                        }
                        while (var1_1 <= 57 && var1_1 >= 48) {
                            ++var8_8;
                            if (var3_3 >= var5_5) break block0;
                            var1_1 = this._inputBuffer[var3_3++];
                        }
                        if (var8_8 == 0) {
                            this.reportUnexpectedNumberChar(var1_1, "Exponent indicator not followed by a digit");
                        }
                    }
                    this._inputPtr = --var3_3;
                    var9_9 = var3_3 - var4_4;
                    this._textBuffer.resetWithShared(this._inputBuffer, var4_4, var9_9);
                    return this.reset(var2_2, var6_6, var7_7, var8_8);
                }
                break block0;
            }
        }
        this._inputPtr = var2_2 != false ? var4_4 + 1 : var4_4;
        return this.parseNumberText2(var2_2);
    }

    private final JsonToken parseNumberText2(boolean bl) {
        char c2;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n2 = 0;
        if (bl) {
            cArray[n2++] = 45;
        }
        int n3 = 0;
        char c3 = c2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("No digit following minus sign");
        if (c2 == '0') {
            c2 = this._verifyNoLeadingZeroes();
        }
        boolean bl2 = false;
        while (c2 >= '0' && c2 <= '9') {
            ++n3;
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = c2;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                c2 = '\u0000';
                bl2 = true;
                break;
            }
            c2 = this._inputBuffer[this._inputPtr++];
        }
        if (n3 == 0) {
            this.reportInvalidNumber("Missing integer part (next char " + ReaderBasedJsonParser._getCharDesc(c2) + ")");
        }
        int n4 = 0;
        if (c2 == '.') {
            cArray[n2++] = c2;
            while (true) {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    bl2 = true;
                    break;
                }
                if ((c2 = this._inputBuffer[this._inputPtr++]) < '0' || c2 > '9') break;
                ++n4;
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = c2;
            }
            if (n4 == 0) {
                this.reportUnexpectedNumberChar(c2, "Decimal point not followed by a digit");
            }
        }
        int n5 = 0;
        if (c2 == 'e' || c2 == 'E') {
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = c2;
            char c4 = c2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("expected a digit for number exponent");
            if (c2 == '-' || c2 == '+') {
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = c2;
                char c5 = c2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("expected a digit for number exponent");
            }
            while (c2 <= '9' && c2 >= '0') {
                ++n5;
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = c2;
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    bl2 = true;
                    break;
                }
                c2 = this._inputBuffer[this._inputPtr++];
            }
            if (n5 == 0) {
                this.reportUnexpectedNumberChar(c2, "Exponent indicator not followed by a digit");
            }
        }
        if (!bl2) {
            --this._inputPtr;
        }
        this._textBuffer.setCurrentLength(n2);
        return this.reset(bl, n3, n4, n5);
    }

    private final char _verifyNoLeadingZeroes() {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return '0';
        }
        char c2 = this._inputBuffer[this._inputPtr];
        if (c2 < '0' || c2 > '9') {
            return '0';
        }
        if (!this.isEnabled(JsonParser$Feature.ALLOW_NUMERIC_LEADING_ZEROS)) {
            this.reportInvalidNumber("Leading zeroes not allowed");
        }
        ++this._inputPtr;
        if (c2 == '0') {
            while (this._inputPtr < this._inputEnd || this.loadMore()) {
                c2 = this._inputBuffer[this._inputPtr];
                if (c2 < '0' || c2 > '9') {
                    return '0';
                }
                ++this._inputPtr;
                if (c2 == '0') continue;
                break;
            }
        }
        return c2;
    }

    protected JsonToken _handleInvalidNumberStart(int n2, boolean bl) {
        if (n2 == 73) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOFInValue();
            }
            if ((n2 = this._inputBuffer[this._inputPtr++]) == 78) {
                String string = bl ? "-INF" : "+INF";
                this._matchToken(string, 3);
                if (this.isEnabled(JsonParser$Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN(string, bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token '" + string + "': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
            } else if (n2 == 110) {
                String string = bl ? "-Infinity" : "+Infinity";
                this._matchToken(string, 3);
                if (this.isEnabled(JsonParser$Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN(string, bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token '" + string + "': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
            }
        }
        this.reportUnexpectedNumberChar(n2, "expected digit (0-9) to follow minus sign, for valid numeric value");
        return null;
    }

    protected final String _parseFieldName(int n2) {
        if (n2 != 34) {
            return this._handleUnusualFieldName(n2);
        }
        int n3 = this._inputPtr;
        int n4 = this._hashSeed;
        int n5 = this._inputEnd;
        if (n3 < n5) {
            int[] nArray = CharTypes.getInputCodeLatin1();
            int n6 = nArray.length;
            do {
                char c2;
                if ((c2 = this._inputBuffer[n3]) < n6 && nArray[c2] != 0) {
                    if (c2 != '\"') break;
                    int n7 = this._inputPtr;
                    this._inputPtr = n3 + 1;
                    return this._symbols.findSymbol(this._inputBuffer, n7, n3 - n7, n4);
                }
                n4 = n4 * 33 + c2;
            } while (++n3 < n5);
        }
        int n8 = this._inputPtr;
        this._inputPtr = n3;
        return this._parseFieldName2(n8, n4, 34);
    }

    private String _parseFieldName2(int n2, int n3, int n4) {
        this._textBuffer.resetWithShared(this._inputBuffer, n2, this._inputPtr - n2);
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n5 = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            char c2;
            char c3;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(": was expecting closing '" + (char)n4 + "' for name");
            }
            if ((c3 = (c2 = this._inputBuffer[this._inputPtr++])) <= '\\') {
                if (c3 == '\\') {
                    c2 = this._decodeEscaped();
                } else if (c3 <= n4) {
                    if (c3 == n4) break;
                    if (c3 < ' ') {
                        this._throwUnquotedSpace(c3, "name");
                    }
                }
            }
            n3 = n3 * 33 + c3;
            cArray[n5++] = c2;
            if (n5 < cArray.length) continue;
            cArray = this._textBuffer.finishCurrentSegment();
            n5 = 0;
        }
        this._textBuffer.setCurrentLength(n5);
        TextBuffer textBuffer = this._textBuffer;
        char[] cArray2 = textBuffer.getTextBuffer();
        int n6 = textBuffer.getTextOffset();
        int n7 = textBuffer.size();
        return this._symbols.findSymbol(cArray2, n6, n7, n3);
    }

    protected final String _handleUnusualFieldName(int n2) {
        int n3;
        int[] nArray;
        int n4;
        boolean bl;
        if (n2 == 39 && this.isEnabled(JsonParser$Feature.ALLOW_SINGLE_QUOTES)) {
            return this._parseApostropheFieldName();
        }
        if (!this.isEnabled(JsonParser$Feature.ALLOW_UNQUOTED_FIELD_NAMES)) {
            this._reportUnexpectedChar(n2, "was expecting double-quote to start field name");
        }
        if (!(bl = n2 < (n4 = (nArray = CharTypes.getInputCodeLatin1JsNames()).length) ? nArray[n2] == 0 && (n2 < 48 || n2 > 57) : Character.isJavaIdentifierPart((char)n2))) {
            this._reportUnexpectedChar(n2, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        int n5 = this._inputPtr;
        int n6 = this._hashSeed;
        int n7 = this._inputEnd;
        if (n5 < n7) {
            do {
                if ((n3 = this._inputBuffer[n5]) < n4) {
                    if (nArray[n3] != 0) {
                        int n8 = this._inputPtr - 1;
                        this._inputPtr = n5;
                        return this._symbols.findSymbol(this._inputBuffer, n8, n5 - n8, n6);
                    }
                } else if (!Character.isJavaIdentifierPart((char)n3)) {
                    int n9 = this._inputPtr - 1;
                    this._inputPtr = n5;
                    return this._symbols.findSymbol(this._inputBuffer, n9, n5 - n9, n6);
                }
                n6 = n6 * 33 + n3;
            } while (++n5 < n7);
        }
        n3 = this._inputPtr - 1;
        this._inputPtr = n5;
        return this._parseUnusualFieldName2(n3, n6, nArray);
    }

    protected final String _parseApostropheFieldName() {
        int n2 = this._inputPtr;
        int n3 = this._hashSeed;
        int n4 = this._inputEnd;
        if (n2 < n4) {
            int[] nArray = CharTypes.getInputCodeLatin1();
            int n5 = nArray.length;
            do {
                char c2;
                if ((c2 = this._inputBuffer[n2]) == '\'') {
                    int n6 = this._inputPtr;
                    this._inputPtr = n2 + 1;
                    return this._symbols.findSymbol(this._inputBuffer, n6, n2 - n6, n3);
                }
                if (c2 < n5 && nArray[c2] != 0) break;
                n3 = n3 * 33 + c2;
            } while (++n2 < n4);
        }
        int n7 = this._inputPtr;
        this._inputPtr = n2;
        return this._parseFieldName2(n7, n3, 39);
    }

    protected final JsonToken _handleUnexpectedValue(int n2) {
        switch (n2) {
            case 39: {
                if (!this.isEnabled(JsonParser$Feature.ALLOW_SINGLE_QUOTES)) break;
                return this._handleApostropheValue();
            }
            case 78: {
                this._matchToken("NaN", 1);
                if (this.isEnabled(JsonParser$Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN("NaN", Double.NaN);
                }
                this._reportError("Non-standard token 'NaN': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 43: {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    this._reportInvalidEOFInValue();
                }
                return this._handleInvalidNumberStart(this._inputBuffer[this._inputPtr++], false);
            }
        }
        this._reportUnexpectedChar(n2, "expected a valid value (number, String, array, object, 'true', 'false' or 'null')");
        return null;
    }

    protected final JsonToken _handleApostropheValue() {
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n2 = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            char c2;
            char c3;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(": was expecting closing quote for a string value");
            }
            if ((c3 = (c2 = this._inputBuffer[this._inputPtr++])) <= '\\') {
                if (c3 == '\\') {
                    c2 = this._decodeEscaped();
                } else if (c3 <= '\'') {
                    if (c3 == '\'') break;
                    if (c3 < ' ') {
                        this._throwUnquotedSpace(c3, "string value");
                    }
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = c2;
        }
        this._textBuffer.setCurrentLength(n2);
        return JsonToken.VALUE_STRING;
    }

    private String _parseUnusualFieldName2(int n2, int n3, int[] nArray) {
        char c2;
        char c3;
        this._textBuffer.resetWithShared(this._inputBuffer, n2, this._inputPtr - n2);
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n4 = this._textBuffer.getCurrentSegmentSize();
        int n5 = nArray.length;
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && !((c3 = (c2 = this._inputBuffer[this._inputPtr])) <= n5 ? nArray[c3] != 0 : !Character.isJavaIdentifierPart(c2))) {
            ++this._inputPtr;
            n3 = n3 * 33 + c3;
            cArray[n4++] = c2;
            if (n4 < cArray.length) continue;
            cArray = this._textBuffer.finishCurrentSegment();
            n4 = 0;
        }
        this._textBuffer.setCurrentLength(n4);
        TextBuffer textBuffer = this._textBuffer;
        char[] cArray2 = textBuffer.getTextBuffer();
        int n6 = textBuffer.getTextOffset();
        int n7 = textBuffer.size();
        return this._symbols.findSymbol(cArray2, n6, n7, n3);
    }

    protected void _finishString() {
        int n2 = this._inputPtr;
        int n3 = this._inputEnd;
        if (n2 < n3) {
            int[] nArray = CharTypes.getInputCodeLatin1();
            int n4 = nArray.length;
            do {
                char c2;
                if ((c2 = this._inputBuffer[n2]) >= n4 || nArray[c2] == 0) continue;
                if (c2 != '\"') break;
                this._textBuffer.resetWithShared(this._inputBuffer, this._inputPtr, n2 - this._inputPtr);
                this._inputPtr = n2 + 1;
                return;
            } while (++n2 < n3);
        }
        this._textBuffer.resetWithCopy(this._inputBuffer, this._inputPtr, n2 - this._inputPtr);
        this._inputPtr = n2;
        this._finishString2();
    }

    protected void _finishString2() {
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n2 = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            char c2;
            char c3;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(": was expecting closing quote for a string value");
            }
            if ((c3 = (c2 = this._inputBuffer[this._inputPtr++])) <= '\\') {
                if (c3 == '\\') {
                    c2 = this._decodeEscaped();
                } else if (c3 <= '\"') {
                    if (c3 == '\"') break;
                    if (c3 < ' ') {
                        this._throwUnquotedSpace(c3, "string value");
                    }
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = c2;
        }
        this._textBuffer.setCurrentLength(n2);
    }

    protected void _skipString() {
        this._tokenIncomplete = false;
        int n2 = this._inputPtr;
        int n3 = this._inputEnd;
        char[] cArray = this._inputBuffer;
        while (true) {
            char c2;
            char c3;
            if (n2 >= n3) {
                this._inputPtr = n2;
                if (!this.loadMore()) {
                    this._reportInvalidEOF(": was expecting closing quote for a string value");
                }
                n2 = this._inputPtr;
                n3 = this._inputEnd;
            }
            if ((c3 = (c2 = cArray[n2++])) > '\\') continue;
            if (c3 == '\\') {
                this._inputPtr = n2;
                c2 = this._decodeEscaped();
                n2 = this._inputPtr;
                n3 = this._inputEnd;
                continue;
            }
            if (c3 > '\"') continue;
            if (c3 == '\"') break;
            if (c3 >= ' ') continue;
            this._inputPtr = n2;
            this._throwUnquotedSpace(c3, "string value");
        }
        this._inputPtr = n2;
    }

    protected final void _skipCR() {
        if ((this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == '\n') {
            ++this._inputPtr;
        }
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    protected final void _skipLF() {
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    private final int _skipWS() {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char c2;
            if ((c2 = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c2 != '/') {
                    return c2;
                }
                this._skipComment();
                continue;
            }
            if (c2 == ' ') continue;
            if (c2 == '\n') {
                this._skipLF();
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.getTypeDesc() + " entries");
    }

    private final int _skipWSOrEnd() {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char c2;
            if ((c2 = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c2 == '/') {
                    this._skipComment();
                    continue;
                }
                return c2;
            }
            if (c2 == ' ') continue;
            if (c2 == '\n') {
                this._skipLF();
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
        this._handleEOF();
        return -1;
    }

    private final void _skipComment() {
        char c2;
        if (!this.isEnabled(JsonParser$Feature.ALLOW_COMMENTS)) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in a comment");
        }
        if ((c2 = this._inputBuffer[this._inputPtr++]) == '/') {
            this._skipCppComment();
        } else if (c2 == '*') {
            this._skipCComment();
        } else {
            this._reportUnexpectedChar(c2, "was expecting either '*' or '/' for a comment");
        }
    }

    private final void _skipCComment() {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char c2;
            if ((c2 = this._inputBuffer[this._inputPtr++]) > '*') continue;
            if (c2 == '*') {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) break;
                if (this._inputBuffer[this._inputPtr] != '/') continue;
                ++this._inputPtr;
                return;
            }
            if (c2 >= ' ') continue;
            if (c2 == '\n') {
                this._skipLF();
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
        this._reportInvalidEOF(" in a comment");
    }

    private final void _skipCppComment() {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char c2;
            if ((c2 = this._inputBuffer[this._inputPtr++]) >= ' ') continue;
            if (c2 == '\n') {
                this._skipLF();
                break;
            }
            if (c2 == '\r') {
                this._skipCR();
                break;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
    }

    protected final char _decodeEscaped() {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in character escape sequence");
        }
        char c2 = this._inputBuffer[this._inputPtr++];
        switch (c2) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case '\"': 
            case '/': 
            case '\\': {
                return c2;
            }
            case 'u': {
                break;
            }
            default: {
                return this._handleUnrecognizedCharacterEscape(c2);
            }
        }
        int n2 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            char c3;
            int n3;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in character escape sequence");
            }
            if ((n3 = CharTypes.charToHex(c3 = this._inputBuffer[this._inputPtr++])) < 0) {
                this._reportUnexpectedChar(c3, "expected a hex-digit for character escape sequence");
            }
            n2 = n2 << 4 | n3;
        }
        return (char)n2;
    }

    protected final void _matchToken(String string, int n2) {
        int n3 = string.length();
        do {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOFInValue();
            }
            if (this._inputBuffer[this._inputPtr] != string.charAt(n2)) {
                this._reportInvalidToken(string.substring(0, n2), "'null', 'true', 'false' or NaN");
            }
            ++this._inputPtr;
        } while (++n2 < n3);
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return;
        }
        char c2 = this._inputBuffer[this._inputPtr];
        if (c2 < '0' || c2 == ']' || c2 == '}') {
            return;
        }
        if (Character.isJavaIdentifierPart(c2)) {
            this._reportInvalidToken(string.substring(0, n2), "'null', 'true', 'false' or NaN");
        }
    }

    protected byte[] _decodeBase64(Base64Variant base64Variant) {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        while (true) {
            char c2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) <= ' ') continue;
            int n2 = base64Variant.decodeBase64Char(c2);
            if (n2 < 0) {
                if (c2 == '\"') {
                    return byteArrayBuilder.toByteArray();
                }
                n2 = this._decodeBase64Escape(base64Variant, c2, 0);
                if (n2 < 0) continue;
            }
            int n3 = n2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                n2 = this._decodeBase64Escape(base64Variant, c2, 1);
            }
            n3 = n3 << 6 | n2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n2 != -2) {
                    if (c2 == '\"' && !base64Variant.usesPadding()) {
                        byteArrayBuilder.append(n3 >>= 4);
                        return byteArrayBuilder.toByteArray();
                    }
                    n2 = this._decodeBase64Escape(base64Variant, c2, 2);
                }
                if (n2 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(c2 = this._inputBuffer[this._inputPtr++])) {
                        throw this.reportInvalidBase64Char(base64Variant, c2, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byteArrayBuilder.append(n3 >>= 4);
                    continue;
                }
            }
            n3 = n3 << 6 | n2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n2 = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n2 != -2) {
                    if (c2 == '\"' && !base64Variant.usesPadding()) {
                        byteArrayBuilder.appendTwoBytes(n3 >>= 2);
                        return byteArrayBuilder.toByteArray();
                    }
                    n2 = this._decodeBase64Escape(base64Variant, c2, 3);
                }
                if (n2 == -2) {
                    byteArrayBuilder.appendTwoBytes(n3 >>= 2);
                    continue;
                }
            }
            n3 = n3 << 6 | n2;
            byteArrayBuilder.appendThreeBytes(n3);
        }
    }

    protected void _reportInvalidToken(String string, String string2) {
        char c2;
        StringBuilder stringBuilder = new StringBuilder(string);
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && Character.isJavaIdentifierPart(c2 = this._inputBuffer[this._inputPtr])) {
            ++this._inputPtr;
            stringBuilder.append(c2);
        }
        this._reportError("Unrecognized token '" + stringBuilder.toString() + "': was expecting ");
    }
}

