/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser$NumberType;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.json.JsonReadContext;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.databind.cfg.DatabindVersion;
import com.fasterxml.jackson.databind.util.TokenBuffer$Segment;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class TokenBuffer$Parser
extends ParserMinimalBase {
    protected ObjectCodec _codec;
    protected TokenBuffer$Segment _segment;
    protected int _segmentPtr;
    protected JsonReadContext _parsingContext;
    protected boolean _closed;
    protected transient ByteArrayBuilder _byteBuilder;
    protected JsonLocation _location = null;

    public TokenBuffer$Parser(TokenBuffer$Segment segment, ObjectCodec objectCodec) {
        super(0);
        this._segment = segment;
        this._segmentPtr = -1;
        this._codec = objectCodec;
        this._parsingContext = JsonReadContext.createRootContext(-1, -1);
    }

    public void setLocation(JsonLocation jsonLocation) {
        this._location = jsonLocation;
    }

    public ObjectCodec getCodec() {
        return this._codec;
    }

    public void setCodec(ObjectCodec objectCodec) {
        this._codec = objectCodec;
    }

    public Version version() {
        return DatabindVersion.instance.version();
    }

    public JsonToken peekNextToken() {
        if (this._closed) {
            return null;
        }
        TokenBuffer$Segment tokenBuffer$Segment = this._segment;
        int n2 = this._segmentPtr + 1;
        if (n2 >= 16) {
            n2 = 0;
            tokenBuffer$Segment = tokenBuffer$Segment == null ? null : tokenBuffer$Segment.next();
        }
        return tokenBuffer$Segment == null ? null : tokenBuffer$Segment.type(n2);
    }

    public void close() {
        if (!this._closed) {
            this._closed = true;
        }
    }

    public JsonToken nextToken() {
        if (this._closed || this._segment == null) {
            return null;
        }
        if (++this._segmentPtr >= 16) {
            this._segmentPtr = 0;
            this._segment = this._segment.next();
            if (this._segment == null) {
                return null;
            }
        }
        this._currToken = this._segment.type(this._segmentPtr);
        if (this._currToken == JsonToken.FIELD_NAME) {
            Object object = this._currentObject();
            String string = object instanceof String ? (String)object : object.toString();
            this._parsingContext.setCurrentName(string);
        } else if (this._currToken == JsonToken.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
        } else if (this._currToken == JsonToken.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext(-1, -1);
        } else if (this._currToken == JsonToken.END_OBJECT || this._currToken == JsonToken.END_ARRAY) {
            this._parsingContext = this._parsingContext.getParent();
            if (this._parsingContext == null) {
                this._parsingContext = JsonReadContext.createRootContext(-1, -1);
            }
        }
        return this._currToken;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public JsonStreamContext getParsingContext() {
        return this._parsingContext;
    }

    public JsonLocation getTokenLocation() {
        return this.getCurrentLocation();
    }

    public JsonLocation getCurrentLocation() {
        return this._location == null ? JsonLocation.NA : this._location;
    }

    public String getCurrentName() {
        return this._parsingContext.getCurrentName();
    }

    public void overrideCurrentName(String string) {
        JsonReadContext jsonReadContext = this._parsingContext;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            jsonReadContext = jsonReadContext.getParent();
        }
        jsonReadContext.setCurrentName(string);
    }

    public String getText() {
        if (this._currToken == JsonToken.VALUE_STRING || this._currToken == JsonToken.FIELD_NAME) {
            Object object = this._currentObject();
            if (object instanceof String) {
                return (String)object;
            }
            return object == null ? null : object.toString();
        }
        if (this._currToken == null) {
            return null;
        }
        switch (this._currToken) {
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                Object object = this._currentObject();
                return object == null ? null : object.toString();
            }
        }
        return this._currToken.asString();
    }

    public char[] getTextCharacters() {
        String string = this.getText();
        return string == null ? null : string.toCharArray();
    }

    public int getTextLength() {
        String string = this.getText();
        return string == null ? 0 : string.length();
    }

    public int getTextOffset() {
        return 0;
    }

    public boolean hasTextCharacters() {
        return false;
    }

    public BigInteger getBigIntegerValue() {
        Number number = this.getNumberValue();
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        switch (this.getNumberType()) {
            case BIG_DECIMAL: {
                return ((BigDecimal)number).toBigInteger();
            }
        }
        return BigInteger.valueOf(number.longValue());
    }

    public BigDecimal getDecimalValue() {
        Number number = this.getNumberValue();
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        switch (this.getNumberType()) {
            case INT: 
            case LONG: {
                return BigDecimal.valueOf(number.longValue());
            }
            case BIG_INTEGER: {
                return new BigDecimal((BigInteger)number);
            }
        }
        return BigDecimal.valueOf(number.doubleValue());
    }

    public double getDoubleValue() {
        return this.getNumberValue().doubleValue();
    }

    public float getFloatValue() {
        return this.getNumberValue().floatValue();
    }

    public int getIntValue() {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            return ((Number)this._currentObject()).intValue();
        }
        return this.getNumberValue().intValue();
    }

    public long getLongValue() {
        return this.getNumberValue().longValue();
    }

    public JsonParser$NumberType getNumberType() {
        Number number = this.getNumberValue();
        if (number instanceof Integer) {
            return JsonParser$NumberType.INT;
        }
        if (number instanceof Long) {
            return JsonParser$NumberType.LONG;
        }
        if (number instanceof Double) {
            return JsonParser$NumberType.DOUBLE;
        }
        if (number instanceof BigDecimal) {
            return JsonParser$NumberType.BIG_DECIMAL;
        }
        if (number instanceof Float) {
            return JsonParser$NumberType.FLOAT;
        }
        if (number instanceof BigInteger) {
            return JsonParser$NumberType.BIG_INTEGER;
        }
        return null;
    }

    public final Number getNumberValue() {
        this._checkIsNumber();
        return (Number)this._currentObject();
    }

    public Object getEmbeddedObject() {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return this._currentObject();
        }
        return null;
    }

    public byte[] getBinaryValue(Base64Variant base64Variant) {
        Object object;
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT && (object = this._currentObject()) instanceof byte[]) {
            return (byte[])object;
        }
        if (this._currToken != JsonToken.VALUE_STRING) {
            throw this._constructError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING (or VALUE_EMBEDDED_OBJECT with byte[]), can not access as binary");
        }
        object = this.getText();
        if (object == null) {
            return null;
        }
        ByteArrayBuilder byteArrayBuilder = this._byteBuilder;
        if (byteArrayBuilder == null) {
            this._byteBuilder = byteArrayBuilder = new ByteArrayBuilder(100);
        } else {
            this._byteBuilder.reset();
        }
        this._decodeBase64((String)object, byteArrayBuilder, base64Variant);
        return byteArrayBuilder.toByteArray();
    }

    protected final Object _currentObject() {
        return this._segment.get(this._segmentPtr);
    }

    protected final void _checkIsNumber() {
        if (this._currToken == null || !this._currToken.isNumeric()) {
            throw this._constructError("Current token (" + (Object)((Object)this._currToken) + ") not numeric, can not use numeric value accessors");
        }
    }

    protected void _handleEOF() {
        this._throwInternal();
    }
}

