/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;

public abstract class StdSerializer
extends JsonSerializer
implements SchemaAware {
    protected final Class _handledType;

    public StdSerializer(Class clazz) {
        this._handledType = clazz;
    }

    protected StdSerializer(JavaType javaType) {
        this._handledType = javaType.getRawClass();
    }

    public StdSerializer(Class clazz, boolean bl) {
        this._handledType = clazz;
    }

    public final Class handledType() {
        return this._handledType;
    }

    public abstract void serialize(Object var1, JsonGenerator var2, SerializerProvider var3);

    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode("string");
    }

    protected ObjectNode createObjectNode() {
        return JsonNodeFactory.instance.objectNode();
    }

    protected ObjectNode createSchemaNode(String string) {
        ObjectNode objectNode = this.createObjectNode();
        objectNode.put("type", string);
        return objectNode;
    }

    protected ObjectNode createSchemaNode(String string, boolean bl) {
        ObjectNode objectNode = this.createSchemaNode(string);
        if (!bl) {
            objectNode.put("required", !bl);
        }
        return objectNode;
    }

    public void wrapAndThrow(SerializerProvider serializerProvider, Throwable throwable, Object object, String string) {
        boolean bl;
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        boolean bl2 = bl = serializerProvider == null || serializerProvider.isEnabled(SerializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl || !(throwable instanceof JsonMappingException)) {
                throw (IOException)throwable;
            }
        } else if (!bl && throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw JsonMappingException.wrapWithPath(throwable, object, string);
    }

    public void wrapAndThrow(SerializerProvider serializerProvider, Throwable throwable, Object object, int n2) {
        boolean bl;
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        boolean bl2 = bl = serializerProvider == null || serializerProvider.isEnabled(SerializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl || !(throwable instanceof JsonMappingException)) {
                throw (IOException)throwable;
            }
        } else if (!bl && throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw JsonMappingException.wrapWithPath(throwable, object, n2);
    }

    protected boolean isDefaultSerializer(JsonSerializer jsonSerializer) {
        return jsonSerializer != null && jsonSerializer.getClass().getAnnotation(JacksonStdImpl.class) != null;
    }
}

