/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.std.AsArraySerializerBase;
import java.util.Iterator;

@JacksonStdImpl
public class IterableSerializer
extends AsArraySerializerBase {
    public IterableSerializer(JavaType javaType, boolean bl, TypeSerializer typeSerializer, BeanProperty beanProperty) {
        super(Iterable.class, javaType, bl, typeSerializer, beanProperty, null);
    }

    public IterableSerializer(IterableSerializer iterableSerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer jsonSerializer) {
        super(iterableSerializer, beanProperty, typeSerializer, jsonSerializer);
    }

    public ContainerSerializer _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return new IterableSerializer(this._elementType, this._staticTyping, typeSerializer, this._property);
    }

    public IterableSerializer withResolved(BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer jsonSerializer) {
        return new IterableSerializer(this, beanProperty, typeSerializer, jsonSerializer);
    }

    public boolean isEmpty(Iterable iterable) {
        return iterable == null || !iterable.iterator().hasNext();
    }

    public boolean hasSingleElement(Iterable iterable) {
        return false;
    }

    public void serializeContents(Iterable iterable, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        Iterator iterator = iterable.iterator();
        if (iterator.hasNext()) {
            TypeSerializer typeSerializer = this._valueTypeSerializer;
            JsonSerializer jsonSerializer = null;
            Class<?> clazz = null;
            do {
                JsonSerializer jsonSerializer2;
                Object t2;
                if ((t2 = iterator.next()) == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                Class<?> clazz2 = t2.getClass();
                if (clazz2 == clazz) {
                    jsonSerializer2 = jsonSerializer;
                } else {
                    jsonSerializer = jsonSerializer2 = serializerProvider.findValueSerializer(clazz2, this._property);
                    clazz = clazz2;
                }
                if (typeSerializer == null) {
                    jsonSerializer2.serialize(t2, jsonGenerator, serializerProvider);
                    continue;
                }
                jsonSerializer2.serializeWithType(t2, jsonGenerator, serializerProvider, typeSerializer);
            } while (iterator.hasNext());
        }
    }
}

