/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.module;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.Module$SetupContext;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleKeyDeserializers;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.module.SimpleValueInstantiators;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class SimpleModule
extends Module {
    protected final String _name;
    protected final Version _version;
    protected SimpleSerializers _serializers = null;
    protected SimpleDeserializers _deserializers = null;
    protected SimpleSerializers _keySerializers = null;
    protected SimpleKeyDeserializers _keyDeserializers = null;
    protected SimpleAbstractTypeResolver _abstractTypes = null;
    protected SimpleValueInstantiators _valueInstantiators = null;
    protected HashMap _mixins = null;
    protected LinkedHashSet _subtypes = null;

    public SimpleModule() {
        this._name = "SimpleModule-" + System.identityHashCode(this);
        this._version = Version.unknownVersion();
    }

    public SimpleModule(String string) {
        this(string, Version.unknownVersion());
    }

    public SimpleModule(Version version) {
        this._name = version.getArtifactId();
        this._version = version;
    }

    public SimpleModule(String string, Version version) {
        this._name = string;
        this._version = version;
    }

    public void setSerializers(SimpleSerializers simpleSerializers) {
        this._serializers = simpleSerializers;
    }

    public void setDeserializers(SimpleDeserializers simpleDeserializers) {
        this._deserializers = simpleDeserializers;
    }

    public void setKeySerializers(SimpleSerializers simpleSerializers) {
        this._keySerializers = simpleSerializers;
    }

    public void setKeyDeserializers(SimpleKeyDeserializers simpleKeyDeserializers) {
        this._keyDeserializers = simpleKeyDeserializers;
    }

    public void setAbstractTypes(SimpleAbstractTypeResolver simpleAbstractTypeResolver) {
        this._abstractTypes = simpleAbstractTypeResolver;
    }

    public void setValueInstantiators(SimpleValueInstantiators simpleValueInstantiators) {
        this._valueInstantiators = simpleValueInstantiators;
    }

    public SimpleModule addSerializer(JsonSerializer jsonSerializer) {
        if (this._serializers == null) {
            this._serializers = new SimpleSerializers();
        }
        this._serializers.addSerializer(jsonSerializer);
        return this;
    }

    public SimpleModule addSerializer(Class clazz, JsonSerializer jsonSerializer) {
        if (this._serializers == null) {
            this._serializers = new SimpleSerializers();
        }
        this._serializers.addSerializer(clazz, jsonSerializer);
        return this;
    }

    public SimpleModule addKeySerializer(Class clazz, JsonSerializer jsonSerializer) {
        if (this._keySerializers == null) {
            this._keySerializers = new SimpleSerializers();
        }
        this._keySerializers.addSerializer(clazz, jsonSerializer);
        return this;
    }

    public SimpleModule addDeserializer(Class clazz, JsonDeserializer jsonDeserializer) {
        if (this._deserializers == null) {
            this._deserializers = new SimpleDeserializers();
        }
        this._deserializers.addDeserializer(clazz, jsonDeserializer);
        return this;
    }

    public SimpleModule addKeyDeserializer(Class clazz, KeyDeserializer keyDeserializer) {
        if (this._keyDeserializers == null) {
            this._keyDeserializers = new SimpleKeyDeserializers();
        }
        this._keyDeserializers.addDeserializer(clazz, keyDeserializer);
        return this;
    }

    public SimpleModule addAbstractTypeMapping(Class clazz, Class clazz2) {
        if (this._abstractTypes == null) {
            this._abstractTypes = new SimpleAbstractTypeResolver();
        }
        this._abstractTypes = this._abstractTypes.addMapping(clazz, clazz2);
        return this;
    }

    public SimpleModule addValueInstantiator(Class clazz, ValueInstantiator valueInstantiator) {
        if (this._valueInstantiators == null) {
            this._valueInstantiators = new SimpleValueInstantiators();
        }
        this._valueInstantiators = this._valueInstantiators.addValueInstantiator(clazz, valueInstantiator);
        return this;
    }

    public SimpleModule registerSubtypes(Class ... classArray) {
        if (this._subtypes == null) {
            this._subtypes = new LinkedHashSet(Math.max(16, classArray.length));
        }
        for (Class clazz : classArray) {
            this._subtypes.add(new NamedType(clazz));
        }
        return this;
    }

    public SimpleModule registerSubtypes(NamedType ... namedTypeArray) {
        if (this._subtypes == null) {
            this._subtypes = new LinkedHashSet(Math.max(16, namedTypeArray.length));
        }
        for (NamedType namedType : namedTypeArray) {
            this._subtypes.add(namedType);
        }
        return this;
    }

    public SimpleModule setMixInAnnotation(Class clazz, Class clazz2) {
        if (this._mixins == null) {
            this._mixins = new HashMap();
        }
        this._mixins.put(clazz, clazz2);
        return this;
    }

    public String getModuleName() {
        return this._name;
    }

    public void setupModule(Module$SetupContext module$SetupContext) {
        if (this._serializers != null) {
            module$SetupContext.addSerializers(this._serializers);
        }
        if (this._deserializers != null) {
            module$SetupContext.addDeserializers(this._deserializers);
        }
        if (this._keySerializers != null) {
            module$SetupContext.addKeySerializers(this._keySerializers);
        }
        if (this._keyDeserializers != null) {
            module$SetupContext.addKeyDeserializers(this._keyDeserializers);
        }
        if (this._abstractTypes != null) {
            module$SetupContext.addAbstractTypeResolver(this._abstractTypes);
        }
        if (this._valueInstantiators != null) {
            module$SetupContext.addValueInstantiators(this._valueInstantiators);
        }
        if (this._subtypes != null && this._subtypes.size() > 0) {
            module$SetupContext.registerSubtypes(this._subtypes.toArray(new NamedType[this._subtypes.size()]));
        }
        if (this._mixins != null) {
            for (Map.Entry entry : this._mixins.entrySet()) {
                module$SetupContext.setMixInAnnotations((Class)entry.getKey(), (Class)entry.getValue());
            }
        }
    }

    public Version version() {
        return this._version;
    }
}

