/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo$Id;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;

public class MinimalClassNameIdResolver
extends ClassNameIdResolver {
    protected final String _basePackageName;
    protected final String _basePackagePrefix;

    protected MinimalClassNameIdResolver(JavaType javaType, TypeFactory typeFactory) {
        super(javaType, typeFactory);
        String string = javaType.getRawClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            this._basePackageName = "";
            this._basePackagePrefix = ".";
        } else {
            this._basePackagePrefix = string.substring(0, n2 + 1);
            this._basePackageName = string.substring(0, n2);
        }
    }

    public JsonTypeInfo$Id getMechanism() {
        return JsonTypeInfo$Id.MINIMAL_CLASS;
    }

    public String idFromValue(Object object) {
        String string = object.getClass().getName();
        if (string.startsWith(this._basePackagePrefix)) {
            return string.substring(this._basePackagePrefix.length() - 1);
        }
        return string;
    }

    public JavaType typeFromId(String string) {
        if (string.startsWith(".")) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + this._basePackageName.length());
            if (this._basePackageName.length() == 0) {
                stringBuilder.append(string.substring(1));
            } else {
                stringBuilder.append(this._basePackageName).append(string);
            }
            string = stringBuilder.toString();
        }
        return super.typeFromId(string);
    }
}

