/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers$Base;
import com.fasterxml.jackson.databind.util.ArrayBuilders$FloatBuilder;

@JacksonStdImpl
final class PrimitiveArrayDeserializers$FloatDeser
extends PrimitiveArrayDeserializers$Base {
    public PrimitiveArrayDeserializers$FloatDeser() {
        super(float[].class);
    }

    public float[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext);
        }
        ArrayBuilders$FloatBuilder arrayBuilders$FloatBuilder = deserializationContext.getArrayBuilders().getFloatBuilder();
        float[] fArray = (float[])arrayBuilders$FloatBuilder.resetAndStart();
        int n2 = 0;
        while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
            float f2 = this._parseFloatPrimitive(jsonParser, deserializationContext);
            if (n2 >= fArray.length) {
                fArray = (float[])arrayBuilders$FloatBuilder.appendCompletedChunk(fArray, n2);
                n2 = 0;
            }
            fArray[n2++] = f2;
        }
        return (float[])arrayBuilders$FloatBuilder.completeAndClearBuffer(fArray, n2);
    }

    private final float[] handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && jsonParser.getText().length() == 0) {
            return null;
        }
        if (!deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) {
            throw deserializationContext.mappingException(this._valueClass);
        }
        return new float[]{this._parseFloatPrimitive(jsonParser, deserializationContext)};
    }
}

