/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Method;

public class EnumDeserializer$FactoryBasedDeserializer
extends StdScalarDeserializer {
    protected final Class _enumClass;
    protected final Class _inputType;
    protected final Method _factory;

    public EnumDeserializer$FactoryBasedDeserializer(Class clazz, AnnotatedMethod annotatedMethod, Class clazz2) {
        super(Enum.class);
        this._enumClass = clazz;
        this._factory = annotatedMethod.getAnnotated();
        this._inputType = clazz2;
    }

    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object;
        if (this._inputType == null) {
            object = jsonParser.getText();
        } else if (this._inputType == Integer.class) {
            object = jsonParser.getValueAsInt();
        } else if (this._inputType == Long.class) {
            object = jsonParser.getValueAsLong();
        } else {
            throw deserializationContext.mappingException(this._enumClass);
        }
        try {
            return this._factory.invoke((Object)this._enumClass, object);
        }
        catch (Exception exception) {
            ClassUtil.unwrapAndThrowAsIAE(exception);
            return null;
        }
    }
}

