/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.sym;

import com.fasterxml.jackson.core.sym.BytesToNameCanonicalizer$Bucket;
import com.fasterxml.jackson.core.sym.Name;
import com.fasterxml.jackson.core.sym.Name1;
import com.fasterxml.jackson.core.sym.Name2;
import com.fasterxml.jackson.core.sym.Name3;
import com.fasterxml.jackson.core.sym.NameN;
import com.fasterxml.jackson.core.util.InternCache;
import java.util.Arrays;

public final class BytesToNameCanonicalizer {
    protected static final int DEFAULT_TABLE_SIZE = 64;
    protected static final int MAX_TABLE_SIZE = 65536;
    static final int MAX_ENTRIES_FOR_REUSE = 6000;
    static final int MAX_COLL_CHAIN_LENGTH = 255;
    static final int MAX_COLL_CHAIN_FOR_REUSE = 63;
    static final int MIN_HASH_SIZE = 16;
    static final int INITIAL_COLLISION_LEN = 32;
    static final int LAST_VALID_BUCKET = 254;
    protected final BytesToNameCanonicalizer _parent;
    private final int _hashSeed;
    private final boolean _intern;
    private int _count;
    protected int _longestCollisionList;
    private int _mainHashMask;
    private int[] _mainHash;
    private Name[] _mainNames;
    private BytesToNameCanonicalizer$Bucket[] _collList;
    private int _collCount;
    private int _collEnd;
    private transient boolean _needRehash;
    private boolean _mainHashShared;
    private boolean _mainNamesShared;
    private boolean _collListShared;
    private static final int MULT = 33;
    private static final int MULT2 = 65599;
    private static final int MULT3 = 31;

    public static BytesToNameCanonicalizer createRoot() {
        long l2 = System.currentTimeMillis();
        int n2 = (int)l2 + ((int)l2 >>> 32) | 1;
        return BytesToNameCanonicalizer.createRoot(n2);
    }

    protected static BytesToNameCanonicalizer createRoot(int n2) {
        return new BytesToNameCanonicalizer(64, true, n2);
    }

    public synchronized BytesToNameCanonicalizer makeChild(boolean bl, boolean bl2) {
        return new BytesToNameCanonicalizer(this, bl2, this._hashSeed);
    }

    public void release() {
        if (this.maybeDirty() && this._parent != null) {
            this._parent.mergeChild(this);
            this.markAsShared();
        }
    }

    private BytesToNameCanonicalizer(int n2, boolean bl, int n3) {
        this._parent = null;
        this._hashSeed = n3;
        this._intern = bl;
        if (n2 < 16) {
            n2 = 16;
        } else if ((n2 & n2 - 1) != 0) {
            int n4;
            for (n4 = 16; n4 < n2; n4 += n4) {
            }
            n2 = n4;
        }
        this.initTables(n2);
    }

    private BytesToNameCanonicalizer(BytesToNameCanonicalizer bytesToNameCanonicalizer, boolean bl, int n2) {
        this._parent = bytesToNameCanonicalizer;
        this._hashSeed = n2;
        this._intern = bl;
        this._count = bytesToNameCanonicalizer._count;
        this._mainHashMask = bytesToNameCanonicalizer._mainHashMask;
        this._mainHash = bytesToNameCanonicalizer._mainHash;
        this._mainNames = bytesToNameCanonicalizer._mainNames;
        this._collList = bytesToNameCanonicalizer._collList;
        this._collCount = bytesToNameCanonicalizer._collCount;
        this._collEnd = bytesToNameCanonicalizer._collEnd;
        this._longestCollisionList = bytesToNameCanonicalizer._longestCollisionList;
        this._needRehash = false;
        this._mainHashShared = true;
        this._mainNamesShared = true;
        this._collListShared = true;
    }

    private void initTables(int n2) {
        this._count = 0;
        this._longestCollisionList = 0;
        this._mainHash = new int[n2];
        this._mainNames = new Name[n2];
        this._mainHashShared = false;
        this._mainNamesShared = false;
        this._mainHashMask = n2 - 1;
        this._collListShared = true;
        this._collList = null;
        this._collEnd = 0;
        this._needRehash = false;
    }

    private synchronized void mergeChild(BytesToNameCanonicalizer bytesToNameCanonicalizer) {
        int n2 = bytesToNameCanonicalizer._count;
        if (n2 <= this._count) {
            return;
        }
        if (bytesToNameCanonicalizer.size() > 6000 || bytesToNameCanonicalizer._longestCollisionList > 63) {
            this.initTables(64);
        } else {
            this._count = bytesToNameCanonicalizer._count;
            this._longestCollisionList = bytesToNameCanonicalizer._longestCollisionList;
            this._mainHash = bytesToNameCanonicalizer._mainHash;
            this._mainNames = bytesToNameCanonicalizer._mainNames;
            this._mainHashShared = true;
            this._mainNamesShared = true;
            this._mainHashMask = bytesToNameCanonicalizer._mainHashMask;
            this._collList = bytesToNameCanonicalizer._collList;
            this._collCount = bytesToNameCanonicalizer._collCount;
            this._collEnd = bytesToNameCanonicalizer._collEnd;
        }
    }

    private void markAsShared() {
        this._mainHashShared = true;
        this._mainNamesShared = true;
        this._collListShared = true;
    }

    public int size() {
        return this._count;
    }

    public int bucketCount() {
        return this._mainHash.length;
    }

    public boolean maybeDirty() {
        return !this._mainHashShared;
    }

    public int hashSeed() {
        return this._hashSeed;
    }

    public int collisionCount() {
        return this._collCount;
    }

    public int maxCollisionLength() {
        return this._longestCollisionList;
    }

    public static Name getEmptyName() {
        return Name1.getEmptyName();
    }

    public Name findName(int n2) {
        Object object;
        int n3 = this.calcHash(n2);
        int n4 = n3 & this._mainHashMask;
        int n5 = this._mainHash[n4];
        if ((n5 >> 8 ^ n3) << 8 == 0) {
            object = this._mainNames[n4];
            if (object == null) {
                return null;
            }
            if (((Name)object).equals(n2)) {
                return object;
            }
        } else if (n5 == 0) {
            return null;
        }
        if ((n5 &= 0xFF) > 0 && (object = this._collList[--n5]) != null) {
            return ((BytesToNameCanonicalizer$Bucket)object).find(n3, n2, 0);
        }
        return null;
    }

    public Name findName(int n2, int n3) {
        Object object;
        int n4 = n3 == 0 ? this.calcHash(n2) : this.calcHash(n2, n3);
        int n5 = n4 & this._mainHashMask;
        int n6 = this._mainHash[n5];
        if ((n6 >> 8 ^ n4) << 8 == 0) {
            object = this._mainNames[n5];
            if (object == null) {
                return null;
            }
            if (((Name)object).equals(n2, n3)) {
                return object;
            }
        } else if (n6 == 0) {
            return null;
        }
        if ((n6 &= 0xFF) > 0 && (object = this._collList[--n6]) != null) {
            return ((BytesToNameCanonicalizer$Bucket)object).find(n4, n2, n3);
        }
        return null;
    }

    public Name findName(int[] nArray, int n2) {
        Object object;
        if (n2 < 3) {
            return this.findName(nArray[0], n2 < 2 ? 0 : nArray[1]);
        }
        int n3 = this.calcHash(nArray, n2);
        int n4 = n3 & this._mainHashMask;
        int n5 = this._mainHash[n4];
        if ((n5 >> 8 ^ n3) << 8 == 0) {
            object = this._mainNames[n4];
            if (object == null || ((Name)object).equals(nArray, n2)) {
                return object;
            }
        } else if (n5 == 0) {
            return null;
        }
        if ((n5 &= 0xFF) > 0 && (object = this._collList[--n5]) != null) {
            return ((BytesToNameCanonicalizer$Bucket)object).find(n3, nArray, n2);
        }
        return null;
    }

    public Name addName(String string, int n2, int n3) {
        if (this._intern) {
            string = InternCache.instance.intern(string);
        }
        int n4 = n3 == 0 ? this.calcHash(n2) : this.calcHash(n2, n3);
        Name name = BytesToNameCanonicalizer.constructName(n4, string, n2, n3);
        this._addSymbol(n4, name);
        return name;
    }

    public Name addName(String string, int[] nArray, int n2) {
        if (this._intern) {
            string = InternCache.instance.intern(string);
        }
        int n3 = n2 < 3 ? (n2 == 1 ? this.calcHash(nArray[0]) : this.calcHash(nArray[0], nArray[1])) : this.calcHash(nArray, n2);
        Name name = BytesToNameCanonicalizer.constructName(n3, string, nArray, n2);
        this._addSymbol(n3, name);
        return name;
    }

    public final int calcHash(int n2) {
        int n3 = n2 ^ this._hashSeed;
        n3 += n3 >>> 15;
        n3 ^= n3 >>> 9;
        return n3;
    }

    public final int calcHash(int n2, int n3) {
        int n4 = n2;
        n4 ^= n4 >>> 15;
        n4 += n3 * 33;
        n4 ^= this._hashSeed;
        n4 += n4 >>> 7;
        return n4;
    }

    public final int calcHash(int[] nArray, int n2) {
        if (n2 < 3) {
            throw new IllegalArgumentException();
        }
        int n3 = nArray[0] ^ this._hashSeed;
        n3 += n3 >>> 9;
        n3 *= 33;
        int n4 = nArray[1];
        n3 += nArray[1];
        n3 *= 65599;
        n3 += n3 >>> 15;
        n3 ^= nArray[2];
        n3 += n3 >>> 17;
        for (int i2 = 3; i2 < n2; ++i2) {
            n3 = n3 * 31 ^ nArray[i2];
            n3 += n3 >>> 3;
            n3 ^= n3 << 7;
        }
        n3 += n3 >>> 15;
        n3 ^= n3 << 9;
        return n3;
    }

    protected static int[] calcQuads(byte[] byArray) {
        int n2 = byArray.length;
        int[] nArray = new int[(n2 + 3) / 4];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray[i2] & 0xFF;
            if (++i2 < n2) {
                n3 = n3 << 8 | byArray[i2] & 0xFF;
                if (++i2 < n2) {
                    n3 = n3 << 8 | byArray[i2] & 0xFF;
                    if (++i2 < n2) {
                        n3 = n3 << 8 | byArray[i2] & 0xFF;
                    }
                }
            }
            nArray[i2 >> 2] = n3;
        }
        return nArray;
    }

    private void _addSymbol(int n2, Name name) {
        int n3;
        int n4;
        if (this._mainHashShared) {
            this.unshareMain();
        }
        if (this._needRehash) {
            this.rehash();
        }
        ++this._count;
        int n5 = n2 & this._mainHashMask;
        if (this._mainNames[n5] == null) {
            this._mainHash[n5] = n2 << 8;
            if (this._mainNamesShared) {
                this.unshareNames();
            }
            this._mainNames[n5] = name;
        } else {
            BytesToNameCanonicalizer$Bucket bytesToNameCanonicalizer$Bucket;
            if (this._collListShared) {
                this.unshareCollision();
            }
            ++this._collCount;
            n4 = this._mainHash[n5];
            n3 = n4 & 0xFF;
            if (n3 == 0) {
                if (this._collEnd <= 254) {
                    if ((n3 = this._collEnd++) >= this._collList.length) {
                        this.expandCollision();
                    }
                } else {
                    n3 = this.findBestBucket();
                }
                this._mainHash[n5] = n4 & 0xFFFFFF00 | n3 + 1;
            } else {
                --n3;
            }
            this._collList[n3] = bytesToNameCanonicalizer$Bucket = new BytesToNameCanonicalizer$Bucket(name, this._collList[n3]);
            this._longestCollisionList = Math.max(bytesToNameCanonicalizer$Bucket.length(), this._longestCollisionList);
            if (this._longestCollisionList > 255) {
                this.reportTooManyCollisions(255);
            }
        }
        n4 = this._mainHash.length;
        if (this._count > n4 >> 1) {
            n3 = n4 >> 2;
            if (this._count > n4 - n3) {
                this._needRehash = true;
            } else if (this._collCount >= n3) {
                this._needRehash = true;
            }
        }
    }

    private void rehash() {
        int n2;
        int n3;
        this._needRehash = false;
        this._mainNamesShared = false;
        int[] nArray = this._mainHash;
        int n4 = nArray.length;
        int n5 = n4 + n4;
        if (n5 > 65536) {
            this.nukeSymbols();
            return;
        }
        this._mainHash = new int[n5];
        this._mainHashMask = n5 - 1;
        Name[] nameArray = this._mainNames;
        this._mainNames = new Name[n5];
        int n6 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            Name name = nameArray[n3];
            if (name == null) continue;
            ++n6;
            int n7 = name.hashCode();
            n2 = n7 & this._mainHashMask;
            this._mainNames[n2] = name;
            this._mainHash[n2] = n7 << 8;
        }
        n3 = this._collEnd;
        if (n3 == 0) {
            this._longestCollisionList = 0;
            return;
        }
        this._collCount = 0;
        this._collEnd = 0;
        this._collListShared = false;
        int n8 = 0;
        BytesToNameCanonicalizer$Bucket[] bytesToNameCanonicalizer$BucketArray = this._collList;
        this._collList = new BytesToNameCanonicalizer$Bucket[bytesToNameCanonicalizer$BucketArray.length];
        for (n2 = 0; n2 < n3; ++n2) {
            BytesToNameCanonicalizer$Bucket bytesToNameCanonicalizer$Bucket = bytesToNameCanonicalizer$BucketArray[n2];
            while (bytesToNameCanonicalizer$Bucket != null) {
                ++n6;
                Name name = bytesToNameCanonicalizer$Bucket._name;
                int n9 = name.hashCode();
                int n10 = n9 & this._mainHashMask;
                int n11 = this._mainHash[n10];
                if (this._mainNames[n10] == null) {
                    this._mainHash[n10] = n9 << 8;
                    this._mainNames[n10] = name;
                } else {
                    BytesToNameCanonicalizer$Bucket bytesToNameCanonicalizer$Bucket2;
                    ++this._collCount;
                    int n12 = n11 & 0xFF;
                    if (n12 == 0) {
                        if (this._collEnd <= 254) {
                            if ((n12 = this._collEnd++) >= this._collList.length) {
                                this.expandCollision();
                            }
                        } else {
                            n12 = this.findBestBucket();
                        }
                        this._mainHash[n10] = n11 & 0xFFFFFF00 | n12 + 1;
                    } else {
                        --n12;
                    }
                    this._collList[n12] = bytesToNameCanonicalizer$Bucket2 = new BytesToNameCanonicalizer$Bucket(name, this._collList[n12]);
                    n8 = Math.max(n8, bytesToNameCanonicalizer$Bucket2.length());
                }
                bytesToNameCanonicalizer$Bucket = bytesToNameCanonicalizer$Bucket._next;
            }
        }
        this._longestCollisionList = n8;
        if (n6 != this._count) {
            throw new RuntimeException("Internal error: count after rehash " + n6 + "; should be " + this._count);
        }
    }

    private void nukeSymbols() {
        this._count = 0;
        this._longestCollisionList = 0;
        Arrays.fill(this._mainHash, 0);
        Arrays.fill(this._mainNames, null);
        Arrays.fill(this._collList, null);
        this._collCount = 0;
        this._collEnd = 0;
    }

    private int findBestBucket() {
        BytesToNameCanonicalizer$Bucket[] bytesToNameCanonicalizer$BucketArray = this._collList;
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        int n4 = this._collEnd;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = bytesToNameCanonicalizer$BucketArray[i2].length();
            if (n5 >= n2) continue;
            if (n5 == 1) {
                return i2;
            }
            n2 = n5;
            n3 = i2;
        }
        return n3;
    }

    private void unshareMain() {
        int[] nArray = this._mainHash;
        int n2 = this._mainHash.length;
        this._mainHash = new int[n2];
        System.arraycopy(nArray, 0, this._mainHash, 0, n2);
        this._mainHashShared = false;
    }

    private void unshareCollision() {
        BytesToNameCanonicalizer$Bucket[] bytesToNameCanonicalizer$BucketArray = this._collList;
        if (bytesToNameCanonicalizer$BucketArray == null) {
            this._collList = new BytesToNameCanonicalizer$Bucket[32];
        } else {
            int n2 = bytesToNameCanonicalizer$BucketArray.length;
            this._collList = new BytesToNameCanonicalizer$Bucket[n2];
            System.arraycopy(bytesToNameCanonicalizer$BucketArray, 0, this._collList, 0, n2);
        }
        this._collListShared = false;
    }

    private void unshareNames() {
        Name[] nameArray = this._mainNames;
        int n2 = nameArray.length;
        this._mainNames = new Name[n2];
        System.arraycopy(nameArray, 0, this._mainNames, 0, n2);
        this._mainNamesShared = false;
    }

    private void expandCollision() {
        BytesToNameCanonicalizer$Bucket[] bytesToNameCanonicalizer$BucketArray = this._collList;
        int n2 = bytesToNameCanonicalizer$BucketArray.length;
        this._collList = new BytesToNameCanonicalizer$Bucket[n2 + n2];
        System.arraycopy(bytesToNameCanonicalizer$BucketArray, 0, this._collList, 0, n2);
    }

    private static Name constructName(int n2, String string, int n3, int n4) {
        if (n4 == 0) {
            return new Name1(string, n2, n3);
        }
        return new Name2(string, n2, n3, n4);
    }

    private static Name constructName(int n2, String string, int[] nArray, int n3) {
        if (n3 < 4) {
            switch (n3) {
                case 1: {
                    return new Name1(string, n2, nArray[0]);
                }
                case 2: {
                    return new Name2(string, n2, nArray[0], nArray[1]);
                }
                case 3: {
                    return new Name3(string, n2, nArray[0], nArray[1], nArray[2]);
                }
            }
        }
        int[] nArray2 = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray2[i2] = nArray[i2];
        }
        return new NameN(string, n2, nArray2, n3);
    }

    protected void reportTooManyCollisions(int n2) {
        throw new IllegalStateException("Longest collision chain in symbol table (of size " + this._count + ") now exceeds maximum, " + n2 + " -- suspect a DoS attack based on hash collisions");
    }
}

