/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.MergedStream;
import com.fasterxml.jackson.core.io.UTF32Reader;
import com.fasterxml.jackson.core.json.ReaderBasedJsonParser;
import com.fasterxml.jackson.core.json.UTF8StreamJsonParser;
import com.fasterxml.jackson.core.sym.BytesToNameCanonicalizer;
import com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer;
import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class ByteSourceJsonBootstrapper {
    static final byte UTF8_BOM_1 = -17;
    static final byte UTF8_BOM_2 = -69;
    static final byte UTF8_BOM_3 = -65;
    protected final IOContext _context;
    protected final InputStream _in;
    protected final byte[] _inputBuffer;
    private int _inputPtr;
    private int _inputEnd;
    private final boolean _bufferRecyclable;
    protected int _inputProcessed;
    protected boolean _bigEndian = true;
    protected int _bytesPerChar = 0;

    public ByteSourceJsonBootstrapper(IOContext iOContext, InputStream inputStream) {
        this._context = iOContext;
        this._in = inputStream;
        this._inputBuffer = iOContext.allocReadIOBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._inputProcessed = 0;
        this._bufferRecyclable = true;
    }

    public ByteSourceJsonBootstrapper(IOContext iOContext, byte[] byArray, int n2, int n3) {
        this._context = iOContext;
        this._in = null;
        this._inputBuffer = byArray;
        this._inputPtr = n2;
        this._inputEnd = n2 + n3;
        this._inputProcessed = -n2;
        this._bufferRecyclable = false;
    }

    public JsonEncoding detectEncoding() {
        JsonEncoding jsonEncoding;
        int n2;
        boolean bl = false;
        if (this.ensureLoaded(4)) {
            n2 = this._inputBuffer[this._inputPtr] << 24 | (this._inputBuffer[this._inputPtr + 1] & 0xFF) << 16 | (this._inputBuffer[this._inputPtr + 2] & 0xFF) << 8 | this._inputBuffer[this._inputPtr + 3] & 0xFF;
            if (this.handleBOM(n2)) {
                bl = true;
            } else if (this.checkUTF32(n2)) {
                bl = true;
            } else if (this.checkUTF16(n2 >>> 16)) {
                bl = true;
            }
        } else if (this.ensureLoaded(2) && this.checkUTF16(n2 = (this._inputBuffer[this._inputPtr] & 0xFF) << 8 | this._inputBuffer[this._inputPtr + 1] & 0xFF)) {
            bl = true;
        }
        if (!bl) {
            jsonEncoding = JsonEncoding.UTF8;
        } else {
            switch (this._bytesPerChar) {
                case 1: {
                    jsonEncoding = JsonEncoding.UTF8;
                    break;
                }
                case 2: {
                    jsonEncoding = this._bigEndian ? JsonEncoding.UTF16_BE : JsonEncoding.UTF16_LE;
                    break;
                }
                case 4: {
                    jsonEncoding = this._bigEndian ? JsonEncoding.UTF32_BE : JsonEncoding.UTF32_LE;
                    break;
                }
                default: {
                    throw new RuntimeException("Internal error");
                }
            }
        }
        this._context.setEncoding(jsonEncoding);
        return jsonEncoding;
    }

    public Reader constructReader() {
        JsonEncoding jsonEncoding = this._context.getEncoding();
        switch (jsonEncoding) {
            case UTF32_BE: 
            case UTF32_LE: {
                return new UTF32Reader(this._context, this._in, this._inputBuffer, this._inputPtr, this._inputEnd, this._context.getEncoding().isBigEndian());
            }
            case UTF16_BE: 
            case UTF16_LE: 
            case UTF8: {
                InputStream inputStream = this._in;
                if (inputStream == null) {
                    inputStream = new ByteArrayInputStream(this._inputBuffer, this._inputPtr, this._inputEnd);
                } else if (this._inputPtr < this._inputEnd) {
                    inputStream = new MergedStream(this._context, inputStream, this._inputBuffer, this._inputPtr, this._inputEnd);
                }
                return new InputStreamReader(inputStream, jsonEncoding.getJavaName());
            }
        }
        throw new RuntimeException("Internal error");
    }

    public JsonParser constructParser(int n2, ObjectCodec objectCodec, BytesToNameCanonicalizer bytesToNameCanonicalizer, CharsToNameCanonicalizer charsToNameCanonicalizer, boolean bl, boolean bl2) {
        JsonEncoding jsonEncoding = this.detectEncoding();
        if (jsonEncoding == JsonEncoding.UTF8 && bl) {
            BytesToNameCanonicalizer bytesToNameCanonicalizer2 = bytesToNameCanonicalizer.makeChild(bl, bl2);
            return new UTF8StreamJsonParser(this._context, n2, this._in, objectCodec, bytesToNameCanonicalizer2, this._inputBuffer, this._inputPtr, this._inputEnd, this._bufferRecyclable);
        }
        return new ReaderBasedJsonParser(this._context, n2, this.constructReader(), objectCodec, charsToNameCanonicalizer.makeChild(bl, bl2));
    }

    public static MatchStrength hasJSONFormat(InputAccessor inputAccessor) {
        int n2;
        if (!inputAccessor.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte by2 = inputAccessor.nextByte();
        if (by2 == -17) {
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -69) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -65) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            by2 = inputAccessor.nextByte();
        }
        if ((n2 = ByteSourceJsonBootstrapper.skipSpace(inputAccessor, by2)) < 0) {
            return MatchStrength.INCONCLUSIVE;
        }
        if (n2 == 123) {
            n2 = ByteSourceJsonBootstrapper.skipSpace(inputAccessor);
            if (n2 < 0) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (n2 == 34 || n2 == 125) {
                return MatchStrength.SOLID_MATCH;
            }
            return MatchStrength.NO_MATCH;
        }
        if (n2 == 91) {
            n2 = ByteSourceJsonBootstrapper.skipSpace(inputAccessor);
            if (n2 < 0) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (n2 == 93 || n2 == 91) {
                return MatchStrength.SOLID_MATCH;
            }
            return MatchStrength.SOLID_MATCH;
        }
        MatchStrength matchStrength = MatchStrength.WEAK_MATCH;
        if (n2 == 34) {
            return matchStrength;
        }
        if (n2 <= 57 && n2 >= 48) {
            return matchStrength;
        }
        if (n2 == 45) {
            n2 = ByteSourceJsonBootstrapper.skipSpace(inputAccessor);
            if (n2 < 0) {
                return MatchStrength.INCONCLUSIVE;
            }
            return n2 <= 57 && n2 >= 48 ? matchStrength : MatchStrength.NO_MATCH;
        }
        if (n2 == 110) {
            return ByteSourceJsonBootstrapper.tryMatch(inputAccessor, "ull", matchStrength);
        }
        if (n2 == 116) {
            return ByteSourceJsonBootstrapper.tryMatch(inputAccessor, "rue", matchStrength);
        }
        if (n2 == 102) {
            return ByteSourceJsonBootstrapper.tryMatch(inputAccessor, "alse", matchStrength);
        }
        return MatchStrength.NO_MATCH;
    }

    private static final MatchStrength tryMatch(InputAccessor inputAccessor, String string, MatchStrength matchStrength) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() == string.charAt(i2)) continue;
            return MatchStrength.NO_MATCH;
        }
        return matchStrength;
    }

    private static final int skipSpace(InputAccessor inputAccessor) {
        if (!inputAccessor.hasMoreBytes()) {
            return -1;
        }
        return ByteSourceJsonBootstrapper.skipSpace(inputAccessor, inputAccessor.nextByte());
    }

    private static final int skipSpace(InputAccessor inputAccessor, byte by2) {
        int n2;
        while ((n2 = by2 & 0xFF) == 32 || n2 == 13 || n2 == 10 || n2 == 9) {
            if (!inputAccessor.hasMoreBytes()) {
                return -1;
            }
            by2 = inputAccessor.nextByte();
            n2 = by2 & 0xFF;
        }
        return n2;
    }

    private boolean handleBOM(int n2) {
        switch (n2) {
            case 65279: {
                this._bigEndian = true;
                this._inputPtr += 4;
                this._bytesPerChar = 4;
                return true;
            }
            case -131072: {
                this._inputPtr += 4;
                this._bytesPerChar = 4;
                this._bigEndian = false;
                return true;
            }
            case 65534: {
                this.reportWeirdUCS4("2143");
            }
            case -16842752: {
                this.reportWeirdUCS4("3412");
            }
        }
        int n3 = n2 >>> 16;
        if (n3 == 65279) {
            this._inputPtr += 2;
            this._bytesPerChar = 2;
            this._bigEndian = true;
            return true;
        }
        if (n3 == 65534) {
            this._inputPtr += 2;
            this._bytesPerChar = 2;
            this._bigEndian = false;
            return true;
        }
        if (n2 >>> 8 == 0xEFBBBF) {
            this._inputPtr += 3;
            this._bytesPerChar = 1;
            this._bigEndian = true;
            return true;
        }
        return false;
    }

    private boolean checkUTF32(int n2) {
        if (n2 >> 8 == 0) {
            this._bigEndian = true;
        } else if ((n2 & 0xFFFFFF) == 0) {
            this._bigEndian = false;
        } else if ((n2 & 0xFF00FFFF) == 0) {
            this.reportWeirdUCS4("3412");
        } else if ((n2 & 0xFFFF00FF) == 0) {
            this.reportWeirdUCS4("2143");
        } else {
            return false;
        }
        this._bytesPerChar = 4;
        return true;
    }

    private boolean checkUTF16(int n2) {
        if ((n2 & 0xFF00) == 0) {
            this._bigEndian = true;
        } else if ((n2 & 0xFF) == 0) {
            this._bigEndian = false;
        } else {
            return false;
        }
        this._bytesPerChar = 2;
        return true;
    }

    private void reportWeirdUCS4(String string) {
        throw new CharConversionException("Unsupported UCS-4 endianness (" + string + ") detected");
    }

    protected boolean ensureLoaded(int n2) {
        int n3;
        for (int i2 = this._inputEnd - this._inputPtr; i2 < n2; i2 += n3) {
            n3 = this._in == null ? -1 : this._in.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (n3 < 1) {
                return false;
            }
            this._inputEnd += n3;
        }
        return true;
    }
}

