/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Member;
import java.util.HashMap;

public class CreatorCollector {
    final BeanDescription _beanDesc;
    final boolean _canFixAccess;
    protected AnnotatedConstructor _defaultConstructor;
    protected AnnotatedWithParams _stringCreator;
    protected AnnotatedWithParams _intCreator;
    protected AnnotatedWithParams _longCreator;
    protected AnnotatedWithParams _doubleCreator;
    protected AnnotatedWithParams _booleanCreator;
    protected AnnotatedWithParams _delegateCreator;
    protected CreatorProperty[] _delegateArgs;
    protected AnnotatedWithParams _propertyBasedCreator;
    protected CreatorProperty[] _propertyBasedArgs = null;

    public CreatorCollector(BeanDescription beanDescription, boolean bl) {
        this._beanDesc = beanDescription;
        this._canFixAccess = bl;
    }

    public ValueInstantiator constructValueInstantiator(DeserializationConfig deserializationConfig) {
        JavaType javaType;
        StdValueInstantiator stdValueInstantiator = new StdValueInstantiator(deserializationConfig, this._beanDesc.getType());
        if (this._delegateCreator == null) {
            javaType = null;
        } else {
            int n2 = 0;
            if (this._delegateArgs != null) {
                int n3 = this._delegateArgs.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (this._delegateArgs[i2] != null) continue;
                    n2 = i2;
                    break;
                }
            }
            TypeBindings typeBindings = this._beanDesc.bindingsForBeanType();
            javaType = typeBindings.resolveType(this._delegateCreator.getGenericParameterType(n2));
        }
        stdValueInstantiator.configureFromObjectSettings(this._defaultConstructor, this._delegateCreator, javaType, this._delegateArgs, this._propertyBasedCreator, this._propertyBasedArgs);
        stdValueInstantiator.configureFromStringCreator(this._stringCreator);
        stdValueInstantiator.configureFromIntCreator(this._intCreator);
        stdValueInstantiator.configureFromLongCreator(this._longCreator);
        stdValueInstantiator.configureFromDoubleCreator(this._doubleCreator);
        stdValueInstantiator.configureFromBooleanCreator(this._booleanCreator);
        return stdValueInstantiator;
    }

    public void setDefaultConstructor(AnnotatedConstructor annotatedConstructor) {
        this._defaultConstructor = annotatedConstructor;
    }

    public void addStringCreator(AnnotatedWithParams annotatedWithParams) {
        this._stringCreator = this.verifyNonDup(annotatedWithParams, this._stringCreator, "String");
    }

    public void addIntCreator(AnnotatedWithParams annotatedWithParams) {
        this._intCreator = this.verifyNonDup(annotatedWithParams, this._intCreator, "int");
    }

    public void addLongCreator(AnnotatedWithParams annotatedWithParams) {
        this._longCreator = this.verifyNonDup(annotatedWithParams, this._longCreator, "long");
    }

    public void addDoubleCreator(AnnotatedWithParams annotatedWithParams) {
        this._doubleCreator = this.verifyNonDup(annotatedWithParams, this._doubleCreator, "double");
    }

    public void addBooleanCreator(AnnotatedWithParams annotatedWithParams) {
        this._booleanCreator = this.verifyNonDup(annotatedWithParams, this._booleanCreator, "boolean");
    }

    public void addDelegatingCreator(AnnotatedWithParams annotatedWithParams, CreatorProperty[] creatorPropertyArray) {
        this._delegateCreator = this.verifyNonDup(annotatedWithParams, this._delegateCreator, "delegate");
        this._delegateArgs = creatorPropertyArray;
    }

    public void addPropertyCreator(AnnotatedWithParams annotatedWithParams, CreatorProperty[] creatorPropertyArray) {
        this._propertyBasedCreator = this.verifyNonDup(annotatedWithParams, this._propertyBasedCreator, "property-based");
        if (creatorPropertyArray.length > 1) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            int n2 = creatorPropertyArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Integer n3;
                String string = creatorPropertyArray[i2].getName();
                if (string.length() == 0 && creatorPropertyArray[i2].getInjectableValueId() != null || (n3 = hashMap.put(string, i2)) == null) continue;
                throw new IllegalArgumentException("Duplicate creator property \"" + string + "\" (index " + n3 + " vs " + i2 + ")");
            }
        }
        this._propertyBasedArgs = creatorPropertyArray;
    }

    protected AnnotatedWithParams verifyNonDup(AnnotatedWithParams annotatedWithParams, AnnotatedWithParams annotatedWithParams2, String string) {
        if (annotatedWithParams2 != null && annotatedWithParams2.getClass() == annotatedWithParams.getClass()) {
            throw new IllegalArgumentException("Conflicting " + string + " creators: already had " + annotatedWithParams2 + ", encountered " + annotatedWithParams);
        }
        if (this._canFixAccess) {
            ClassUtil.checkAndFixAccess((Member)((Object)annotatedWithParams.getAnnotated()));
        }
        return annotatedWithParams;
    }
}

