/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.core.JsonParser$NumberType;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;

public abstract class JsonParser
implements Versioned,
Closeable {
    private static final int MIN_BYTE_I = -128;
    private static final int MAX_BYTE_I = 255;
    private static final int MIN_SHORT_I = Short.MIN_VALUE;
    private static final int MAX_SHORT_I = Short.MAX_VALUE;
    protected int _features;

    public JsonParser() {
    }

    public JsonParser(int n2) {
        this._features = n2;
    }

    public abstract ObjectCodec getCodec();

    public abstract void setCodec(ObjectCodec var1);

    public void setSchema(FormatSchema formatSchema) {
        throw new UnsupportedOperationException("Parser of type " + this.getClass().getName() + " does not support schema of type '" + formatSchema.getSchemaType() + "'");
    }

    public FormatSchema getSchema() {
        return null;
    }

    public boolean canUseSchema(FormatSchema formatSchema) {
        return false;
    }

    public abstract Version version();

    public Object getInputSource() {
        return null;
    }

    public abstract void close();

    public int releaseBuffered(OutputStream outputStream) {
        return -1;
    }

    public int releaseBuffered(Writer writer) {
        return -1;
    }

    public JsonParser enable(JsonParser$Feature jsonParser$Feature) {
        this._features |= jsonParser$Feature.getMask();
        return this;
    }

    public JsonParser disable(JsonParser$Feature jsonParser$Feature) {
        this._features &= ~jsonParser$Feature.getMask();
        return this;
    }

    public JsonParser configure(JsonParser$Feature jsonParser$Feature, boolean bl) {
        if (bl) {
            this.enable(jsonParser$Feature);
        } else {
            this.disable(jsonParser$Feature);
        }
        return this;
    }

    public boolean isEnabled(JsonParser$Feature jsonParser$Feature) {
        return (this._features & jsonParser$Feature.getMask()) != 0;
    }

    public abstract JsonToken nextToken();

    public abstract JsonToken nextValue();

    public boolean nextFieldName(SerializableString serializableString) {
        return this.nextToken() == JsonToken.FIELD_NAME && serializableString.getValue().equals(this.getCurrentName());
    }

    public String nextTextValue() {
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getText() : null;
    }

    public int nextIntValue(int n2) {
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getIntValue() : n2;
    }

    public long nextLongValue(long l2) {
        return this.nextToken() == JsonToken.VALUE_NUMBER_INT ? this.getLongValue() : l2;
    }

    public Boolean nextBooleanValue() {
        switch (this.nextToken()) {
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public abstract JsonParser skipChildren();

    public abstract boolean isClosed();

    public abstract JsonToken getCurrentToken();

    public abstract boolean hasCurrentToken();

    public abstract String getCurrentName();

    public abstract JsonStreamContext getParsingContext();

    public abstract JsonLocation getTokenLocation();

    public abstract JsonLocation getCurrentLocation();

    public boolean isExpectedStartArrayToken() {
        return this.getCurrentToken() == JsonToken.START_ARRAY;
    }

    public abstract void clearCurrentToken();

    public abstract JsonToken getLastClearedToken();

    public abstract void overrideCurrentName(String var1);

    public abstract String getText();

    public abstract char[] getTextCharacters();

    public abstract int getTextLength();

    public abstract int getTextOffset();

    public abstract boolean hasTextCharacters();

    public abstract Number getNumberValue();

    public abstract JsonParser$NumberType getNumberType();

    public byte getByteValue() {
        int n2 = this.getIntValue();
        if (n2 < -128 || n2 > 255) {
            throw this._constructError("Numeric value (" + this.getText() + ") out of range of Java byte");
        }
        return (byte)n2;
    }

    public short getShortValue() {
        int n2 = this.getIntValue();
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw this._constructError("Numeric value (" + this.getText() + ") out of range of Java short");
        }
        return (short)n2;
    }

    public abstract int getIntValue();

    public abstract long getLongValue();

    public abstract BigInteger getBigIntegerValue();

    public abstract float getFloatValue();

    public abstract double getDoubleValue();

    public abstract BigDecimal getDecimalValue();

    public boolean getBooleanValue() {
        JsonToken jsonToken = this.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (jsonToken == JsonToken.VALUE_FALSE) {
            return false;
        }
        throw new JsonParseException("Current token (" + (Object)((Object)jsonToken) + ") not of boolean type", this.getCurrentLocation());
    }

    public abstract Object getEmbeddedObject();

    public abstract byte[] getBinaryValue(Base64Variant var1);

    public byte[] getBinaryValue() {
        return this.getBinaryValue(Base64Variants.getDefaultVariant());
    }

    public int getValueAsInt() {
        return this.getValueAsInt(0);
    }

    public int getValueAsInt(int n2) {
        return n2;
    }

    public long getValueAsLong() {
        return this.getValueAsLong(0L);
    }

    public long getValueAsLong(long l2) {
        return l2;
    }

    public double getValueAsDouble() {
        return this.getValueAsDouble(0.0);
    }

    public double getValueAsDouble(double d2) {
        return d2;
    }

    public boolean getValueAsBoolean() {
        return this.getValueAsBoolean(false);
    }

    public boolean getValueAsBoolean(boolean bl) {
        return bl;
    }

    public Object readValueAs(Class clazz) {
        ObjectCodec objectCodec = this.getCodec();
        if (objectCodec == null) {
            throw new IllegalStateException("No ObjectCodec defined for the parser, can not deserialize JSON into Java objects");
        }
        return objectCodec.readValue(this, clazz);
    }

    public Object readValueAs(TypeReference typeReference) {
        ObjectCodec objectCodec = this.getCodec();
        if (objectCodec == null) {
            throw new IllegalStateException("No ObjectCodec defined for the parser, can not deserialize JSON into Java objects");
        }
        return objectCodec.readValue(this, typeReference);
    }

    public Iterator readValuesAs(Class clazz) {
        ObjectCodec objectCodec = this.getCodec();
        if (objectCodec == null) {
            throw new IllegalStateException("No ObjectCodec defined for the parser, can not deserialize JSON into Java objects");
        }
        return objectCodec.readValues(this, clazz);
    }

    public Iterator readValuesAs(TypeReference typeReference) {
        ObjectCodec objectCodec = this.getCodec();
        if (objectCodec == null) {
            throw new IllegalStateException("No ObjectCodec defined for the parser, can not deserialize JSON into Java objects");
        }
        return objectCodec.readValues(this, typeReference);
    }

    public TreeNode readValueAsTree() {
        ObjectCodec objectCodec = this.getCodec();
        if (objectCodec == null) {
            throw new IllegalStateException("No ObjectCodec defined for the parser, can not deserialize JSON into JsonNode tree");
        }
        return objectCodec.readTree(this);
    }

    protected JsonParseException _constructError(String string) {
        return new JsonParseException(string, this.getCurrentLocation());
    }
}

