/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.BiomeBase;
import net.minecraft.server.Block;
import net.minecraft.server.BlockFluids;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkCache;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.ChunkProviderLoadOrGenerate;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityWeatherStorm;
import net.minecraft.server.EnumSkyBlock;
import net.minecraft.server.Explosion;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.IChunkLoader;
import net.minecraft.server.IChunkProvider;
import net.minecraft.server.IDataManager;
import net.minecraft.server.IProgressUpdate;
import net.minecraft.server.IWorldAccess;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MetadataChunkBlock;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.NextTickListEntry;
import net.minecraft.server.PathEntity;
import net.minecraft.server.Pathfinder;
import net.minecraft.server.SpawnerCreature;
import net.minecraft.server.TileEntity;
import net.minecraft.server.Vec3D;
import net.minecraft.server.WorldChunkManager;
import net.minecraft.server.WorldData;
import net.minecraft.server.WorldMapBase;
import net.minecraft.server.WorldMapCollection;
import net.minecraft.server.WorldProvider;

public class World
implements IBlockAccess {
    public boolean a = false;
    private List C = new ArrayList();
    public List entityList = new ArrayList();
    private List D = new ArrayList();
    private TreeSet E = new TreeSet();
    private Set F = new HashSet();
    public List c = new ArrayList();
    private List G = new ArrayList();
    public List players = new ArrayList();
    public List e = new ArrayList();
    private long H = 0xFFFFFFL;
    public int f = 0;
    protected int g = new Random().nextInt();
    protected final int h = 1013904223;
    protected float i;
    protected float j;
    protected float k;
    protected float l;
    protected int m = 0;
    public int n = 0;
    public boolean suppressPhysics = false;
    private long I = System.currentTimeMillis();
    protected int p = 40;
    public int spawnMonsters;
    public Random random = new Random();
    public boolean s = false;
    public final WorldProvider worldProvider;
    protected List u = new ArrayList();
    protected IChunkProvider chunkProvider;
    protected final IDataManager w;
    protected WorldData worldData;
    public boolean isLoading;
    private boolean J;
    public WorldMapCollection worldMaps;
    private ArrayList K = new ArrayList();
    private boolean L;
    private int M = 0;
    private boolean allowMonsters = true;
    private boolean allowAnimals = true;
    static int A = 0;
    private Set P = new HashSet();
    private int Q = this.random.nextInt(12000);
    private List R = new ArrayList();
    public boolean isStatic = false;

    public WorldChunkManager getWorldChunkManager() {
        return this.worldProvider.b;
    }

    public World(IDataManager iDataManager, String string, long l, WorldProvider worldProvider) {
        this.w = iDataManager;
        this.worldMaps = new WorldMapCollection(iDataManager);
        this.worldData = iDataManager.c();
        boolean bl = this.s = this.worldData == null;
        this.worldProvider = worldProvider != null ? worldProvider : (this.worldData != null && this.worldData.h() == -1 ? WorldProvider.byDimension(-1) : WorldProvider.byDimension(0));
        boolean bl2 = false;
        if (this.worldData == null) {
            this.worldData = new WorldData(l, string);
            bl2 = true;
        } else {
            this.worldData.a(string);
        }
        this.worldProvider.a(this);
        this.chunkProvider = this.b();
        if (bl2) {
            this.c();
        }
        this.g();
        this.x();
    }

    protected IChunkProvider b() {
        IChunkLoader iChunkLoader = this.w.a(this.worldProvider);
        return new ChunkProviderLoadOrGenerate(this, iChunkLoader, this.worldProvider.getChunkProvider());
    }

    protected void c() {
        this.isLoading = true;
        int n = 0;
        int n2 = 64;
        int n3 = 0;
        while (!this.worldProvider.canSpawn(n, n3)) {
            n += this.random.nextInt(64) - this.random.nextInt(64);
            n3 += this.random.nextInt(64) - this.random.nextInt(64);
        }
        this.worldData.setSpawn(n, n2, n3);
        this.isLoading = false;
    }

    public int a(int n, int n2) {
        int n3 = 63;
        while (!this.isEmpty(n, n3 + 1, n2)) {
            ++n3;
        }
        return this.getTypeId(n, n3, n2);
    }

    public void save(boolean bl, IProgressUpdate iProgressUpdate) {
        if (this.chunkProvider.canSave()) {
            if (iProgressUpdate != null) {
                iProgressUpdate.a("Saving level");
            }
            this.w();
            if (iProgressUpdate != null) {
                iProgressUpdate.b("Saving chunks");
            }
            this.chunkProvider.saveChunks(bl, iProgressUpdate);
        }
    }

    private void w() {
        this.k();
        this.w.a(this.worldData, this.players);
        this.worldMaps.a();
    }

    @Override
    public int getTypeId(int n, int n2, int n3) {
        return n >= -32000000 && n3 >= -32000000 && n < 32000000 && n3 <= 32000000 ? (n2 < 0 ? 0 : (n2 >= 128 ? 0 : this.getChunkAt(n >> 4, n3 >> 4).getTypeId(n & 0xF, n2, n3 & 0xF))) : 0;
    }

    public boolean isEmpty(int n, int n2, int n3) {
        return this.getTypeId(n, n2, n3) == 0;
    }

    public boolean isLoaded(int n, int n2, int n3) {
        return n2 >= 0 && n2 < 128 ? this.isChunkLoaded(n >> 4, n3 >> 4) : false;
    }

    public boolean areChunksLoaded(int n, int n2, int n3, int n4) {
        return this.a(n - n4, n2 - n4, n3 - n4, n + n4, n2 + n4, n3 + n4);
    }

    public boolean a(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 >= 0 && n2 < 128) {
            n >>= 4;
            n2 >>= 4;
            n3 >>= 4;
            n4 >>= 4;
            n5 >>= 4;
            n6 >>= 4;
            for (int i = n; i <= n4; ++i) {
                for (int j = n3; j <= n6; ++j) {
                    if (this.isChunkLoaded(i, j)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean isChunkLoaded(int n, int n2) {
        return this.chunkProvider.isChunkLoaded(n, n2);
    }

    public Chunk getChunkAtWorldCoords(int n, int n2) {
        return this.getChunkAt(n >> 4, n2 >> 4);
    }

    public Chunk getChunkAt(int n, int n2) {
        return this.chunkProvider.getOrCreateChunk(n, n2);
    }

    public boolean setRawTypeIdAndData(int n, int n2, int n3, int n4, int n5) {
        if (n >= -32000000 && n3 >= -32000000 && n < 32000000 && n3 <= 32000000) {
            if (n2 < 0) {
                return false;
            }
            if (n2 >= 128) {
                return false;
            }
            Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
            return chunk.a(n & 0xF, n2, n3 & 0xF, n4, n5);
        }
        return false;
    }

    public boolean setRawTypeId(int n, int n2, int n3, int n4) {
        if (n >= -32000000 && n3 >= -32000000 && n < 32000000 && n3 <= 32000000) {
            if (n2 < 0) {
                return false;
            }
            if (n2 >= 128) {
                return false;
            }
            Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
            return chunk.a(n & 0xF, n2, n3 & 0xF, n4);
        }
        return false;
    }

    @Override
    public Material getMaterial(int n, int n2, int n3) {
        int n4 = this.getTypeId(n, n2, n3);
        return n4 == 0 ? Material.AIR : Block.byId[n4].material;
    }

    @Override
    public int getData(int n, int n2, int n3) {
        if (n >= -32000000 && n3 >= -32000000 && n < 32000000 && n3 <= 32000000) {
            if (n2 < 0) {
                return 0;
            }
            if (n2 >= 128) {
                return 0;
            }
            Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
            return chunk.getData(n &= 0xF, n2, n3 &= 0xF);
        }
        return 0;
    }

    public void setData(int n, int n2, int n3, int n4) {
        if (this.setRawData(n, n2, n3, n4)) {
            int n5 = this.getTypeId(n, n2, n3);
            if (Block.t[n5 & 0xFF]) {
                this.update(n, n2, n3, n5);
            } else {
                this.applyPhysics(n, n2, n3, n5);
            }
        }
    }

    public boolean setRawData(int n, int n2, int n3, int n4) {
        if (n >= -32000000 && n3 >= -32000000 && n < 32000000 && n3 <= 32000000) {
            if (n2 < 0) {
                return false;
            }
            if (n2 >= 128) {
                return false;
            }
            Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
            chunk.b(n &= 0xF, n2, n3 &= 0xF, n4);
            return true;
        }
        return false;
    }

    public boolean setTypeId(int n, int n2, int n3, int n4) {
        if (this.setRawTypeId(n, n2, n3, n4)) {
            this.update(n, n2, n3, n4);
            return true;
        }
        return false;
    }

    public boolean setTypeIdAndData(int n, int n2, int n3, int n4, int n5) {
        if (this.setRawTypeIdAndData(n, n2, n3, n4, n5)) {
            this.update(n, n2, n3, n4);
            return true;
        }
        return false;
    }

    public void notify(int n, int n2, int n3) {
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).a(n, n2, n3);
        }
    }

    protected void update(int n, int n2, int n3, int n4) {
        this.notify(n, n2, n3);
        this.applyPhysics(n, n2, n3, n4);
    }

    public void g(int n, int n2, int n3, int n4) {
        if (n3 > n4) {
            int n5 = n4;
            n4 = n3;
            n3 = n5;
        }
        this.b(n, n3, n2, n, n4, n2);
    }

    public void i(int n, int n2, int n3) {
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).a(n, n2, n3, n, n2, n3);
        }
    }

    public void b(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).a(n, n2, n3, n4, n5, n6);
        }
    }

    public void applyPhysics(int n, int n2, int n3, int n4) {
        this.k(n - 1, n2, n3, n4);
        this.k(n + 1, n2, n3, n4);
        this.k(n, n2 - 1, n3, n4);
        this.k(n, n2 + 1, n3, n4);
        this.k(n, n2, n3 - 1, n4);
        this.k(n, n2, n3 + 1, n4);
    }

    private void k(int n, int n2, int n3, int n4) {
        Block block;
        if (!this.suppressPhysics && !this.isStatic && (block = Block.byId[this.getTypeId(n, n2, n3)]) != null) {
            block.doPhysics(this, n, n2, n3, n4);
        }
    }

    public boolean isChunkLoaded(int n, int n2, int n3) {
        return this.getChunkAt(n >> 4, n3 >> 4).c(n & 0xF, n2, n3 & 0xF);
    }

    public int k(int n, int n2, int n3) {
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= 128) {
            n2 = 127;
        }
        return this.getChunkAt(n >> 4, n3 >> 4).c(n & 0xF, n2, n3 & 0xF, 0);
    }

    public int getLightLevel(int n, int n2, int n3) {
        return this.a(n, n2, n3, true);
    }

    public int a(int n, int n2, int n3, boolean bl) {
        if (n >= -32000000 && n3 >= -32000000 && n < 32000000 && n3 <= 32000000) {
            int n4;
            if (bl && ((n4 = this.getTypeId(n, n2, n3)) == Block.STEP.id || n4 == Block.SOIL.id || n4 == Block.COBBLESTONE_STAIRS.id || n4 == Block.WOOD_STAIRS.id)) {
                int n5 = this.a(n, n2 + 1, n3, false);
                int n6 = this.a(n + 1, n2, n3, false);
                int n7 = this.a(n - 1, n2, n3, false);
                int n8 = this.a(n, n2, n3 + 1, false);
                int n9 = this.a(n, n2, n3 - 1, false);
                if (n6 > n5) {
                    n5 = n6;
                }
                if (n7 > n5) {
                    n5 = n7;
                }
                if (n8 > n5) {
                    n5 = n8;
                }
                if (n9 > n5) {
                    n5 = n9;
                }
                return n5;
            }
            if (n2 < 0) {
                return 0;
            }
            if (n2 >= 128) {
                n2 = 127;
            }
            Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
            return chunk.c(n &= 0xF, n2, n3 &= 0xF, this.f);
        }
        return 15;
    }

    public boolean m(int n, int n2, int n3) {
        if (n >= -32000000 && n3 >= -32000000 && n < 32000000 && n3 <= 32000000) {
            if (n2 < 0) {
                return false;
            }
            if (n2 >= 128) {
                return true;
            }
            if (!this.isChunkLoaded(n >> 4, n3 >> 4)) {
                return false;
            }
            Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
            return chunk.c(n &= 0xF, n2, n3 &= 0xF);
        }
        return false;
    }

    public int getHighestBlockYAt(int n, int n2) {
        if (n >= -32000000 && n2 >= -32000000 && n < 32000000 && n2 <= 32000000) {
            if (!this.isChunkLoaded(n >> 4, n2 >> 4)) {
                return 0;
            }
            Chunk chunk = this.getChunkAt(n >> 4, n2 >> 4);
            return chunk.b(n & 0xF, n2 & 0xF);
        }
        return 0;
    }

    public void a(EnumSkyBlock enumSkyBlock, int n, int n2, int n3, int n4) {
        if ((!this.worldProvider.e || enumSkyBlock != EnumSkyBlock.SKY) && this.isLoaded(n, n2, n3)) {
            int n5;
            if (enumSkyBlock == EnumSkyBlock.SKY) {
                if (this.m(n, n2, n3)) {
                    n4 = 15;
                }
            } else if (enumSkyBlock == EnumSkyBlock.BLOCK && Block.s[n5 = this.getTypeId(n, n2, n3)] > n4) {
                n4 = Block.s[n5];
            }
            if (this.a(enumSkyBlock, n, n2, n3) != n4) {
                this.a(enumSkyBlock, n, n2, n3, n, n2, n3);
            }
        }
    }

    public int a(EnumSkyBlock enumSkyBlock, int n, int n2, int n3) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= 128) {
            n2 = 127;
        }
        if (n2 >= 0 && n2 < 128 && n >= -32000000 && n3 >= -32000000 && n < 32000000 && n3 <= 32000000) {
            int n4 = n >> 4;
            int n5 = n3 >> 4;
            if (!this.isChunkLoaded(n4, n5)) {
                return 0;
            }
            Chunk chunk = this.getChunkAt(n4, n5);
            return chunk.a(enumSkyBlock, n & 0xF, n2, n3 & 0xF);
        }
        return enumSkyBlock.c;
    }

    public void b(EnumSkyBlock enumSkyBlock, int n, int n2, int n3, int n4) {
        if (n >= -32000000 && n3 >= -32000000 && n < 32000000 && n3 <= 32000000 && n2 >= 0 && n2 < 128 && this.isChunkLoaded(n >> 4, n3 >> 4)) {
            Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
            chunk.a(enumSkyBlock, n & 0xF, n2, n3 & 0xF, n4);
            for (int i = 0; i < this.u.size(); ++i) {
                ((IWorldAccess)this.u.get(i)).a(n, n2, n3);
            }
        }
    }

    public float n(int n, int n2, int n3) {
        return this.worldProvider.f[this.getLightLevel(n, n2, n3)];
    }

    public boolean d() {
        return this.f < 4;
    }

    public MovingObjectPosition a(Vec3D vec3D, Vec3D vec3D2) {
        return this.rayTrace(vec3D, vec3D2, false, false);
    }

    public MovingObjectPosition rayTrace(Vec3D vec3D, Vec3D vec3D2, boolean bl) {
        return this.rayTrace(vec3D, vec3D2, bl, false);
    }

    public MovingObjectPosition rayTrace(Vec3D vec3D, Vec3D vec3D2, boolean bl, boolean bl2) {
        if (!(Double.isNaN(vec3D.a) || Double.isNaN(vec3D.b) || Double.isNaN(vec3D.c))) {
            if (!(Double.isNaN(vec3D2.a) || Double.isNaN(vec3D2.b) || Double.isNaN(vec3D2.c))) {
                MovingObjectPosition movingObjectPosition;
                int n = MathHelper.floor(vec3D2.a);
                int n2 = MathHelper.floor(vec3D2.b);
                int n3 = MathHelper.floor(vec3D2.c);
                int n4 = MathHelper.floor(vec3D.a);
                int n5 = MathHelper.floor(vec3D.b);
                int n6 = MathHelper.floor(vec3D.c);
                int n7 = this.getTypeId(n4, n5, n6);
                int n8 = this.getData(n4, n5, n6);
                Block block = Block.byId[n7];
                if ((!bl2 || block == null || block.d(this, n4, n5, n6) != null) && n7 > 0 && block.a(n8, bl) && (movingObjectPosition = block.a(this, n4, n5, n6, vec3D, vec3D2)) != null) {
                    return movingObjectPosition;
                }
                n7 = 200;
                while (n7-- >= 0) {
                    MovingObjectPosition movingObjectPosition2;
                    int n9;
                    if (Double.isNaN(vec3D.a) || Double.isNaN(vec3D.b) || Double.isNaN(vec3D.c)) {
                        return null;
                    }
                    if (n4 == n && n5 == n2 && n6 == n3) {
                        return null;
                    }
                    boolean bl3 = true;
                    boolean bl4 = true;
                    boolean bl5 = true;
                    double d = 999.0;
                    double d2 = 999.0;
                    double d3 = 999.0;
                    if (n > n4) {
                        d = (double)n4 + 1.0;
                    } else if (n < n4) {
                        d = (double)n4 + 0.0;
                    } else {
                        bl3 = false;
                    }
                    if (n2 > n5) {
                        d2 = (double)n5 + 1.0;
                    } else if (n2 < n5) {
                        d2 = (double)n5 + 0.0;
                    } else {
                        bl4 = false;
                    }
                    if (n3 > n6) {
                        d3 = (double)n6 + 1.0;
                    } else if (n3 < n6) {
                        d3 = (double)n6 + 0.0;
                    } else {
                        bl5 = false;
                    }
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = 999.0;
                    double d7 = vec3D2.a - vec3D.a;
                    double d8 = vec3D2.b - vec3D.b;
                    double d9 = vec3D2.c - vec3D.c;
                    if (bl3) {
                        d4 = (d - vec3D.a) / d7;
                    }
                    if (bl4) {
                        d5 = (d2 - vec3D.b) / d8;
                    }
                    if (bl5) {
                        d6 = (d3 - vec3D.c) / d9;
                    }
                    boolean bl6 = false;
                    if (d4 < d5 && d4 < d6) {
                        n9 = n > n4 ? 4 : 5;
                        vec3D.a = d;
                        vec3D.b += d8 * d4;
                        vec3D.c += d9 * d4;
                    } else if (d5 < d6) {
                        n9 = n2 > n5 ? 0 : 1;
                        vec3D.a += d7 * d5;
                        vec3D.b = d2;
                        vec3D.c += d9 * d5;
                    } else {
                        n9 = n3 > n6 ? 2 : 3;
                        vec3D.a += d7 * d6;
                        vec3D.b += d8 * d6;
                        vec3D.c = d3;
                    }
                    Vec3D vec3D3 = Vec3D.create(vec3D.a, vec3D.b, vec3D.c);
                    vec3D3.a = MathHelper.floor(vec3D.a);
                    n4 = (int)vec3D3.a;
                    if (n9 == 5) {
                        --n4;
                        vec3D3.a += 1.0;
                    }
                    vec3D3.b = MathHelper.floor(vec3D.b);
                    n5 = (int)vec3D3.b;
                    if (n9 == 1) {
                        --n5;
                        vec3D3.b += 1.0;
                    }
                    vec3D3.c = MathHelper.floor(vec3D.c);
                    n6 = (int)vec3D3.c;
                    if (n9 == 3) {
                        --n6;
                        vec3D3.c += 1.0;
                    }
                    int n10 = this.getTypeId(n4, n5, n6);
                    int n11 = this.getData(n4, n5, n6);
                    Block block2 = Block.byId[n10];
                    if (bl2 && block2 != null && block2.d(this, n4, n5, n6) == null || n10 <= 0 || !block2.a(n11, bl) || (movingObjectPosition2 = block2.a(this, n4, n5, n6, vec3D, vec3D2)) == null) continue;
                    return movingObjectPosition2;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public void makeSound(Entity entity, String string, float f, float f2) {
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).a(string, entity.locX, entity.locY - (double)entity.height, entity.locZ, f, f2);
        }
    }

    public void makeSound(double d, double d2, double d3, String string, float f, float f2) {
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).a(string, d, d2, d3, f, f2);
        }
    }

    public void a(String string, int n, int n2, int n3) {
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).a(string, n, n2, n3);
        }
    }

    public void a(String string, double d, double d2, double d3, double d4, double d5, double d6) {
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).a(string, d, d2, d3, d4, d5, d6);
        }
    }

    public boolean strikeLightning(Entity entity) {
        this.e.add(entity);
        return true;
    }

    public boolean addEntity(Entity entity) {
        int n = MathHelper.floor(entity.locX / 16.0);
        int n2 = MathHelper.floor(entity.locZ / 16.0);
        boolean bl = false;
        if (entity instanceof EntityHuman) {
            bl = true;
        }
        if (!bl && !this.isChunkLoaded(n, n2)) {
            return false;
        }
        if (entity instanceof EntityHuman) {
            EntityHuman entityHuman = (EntityHuman)entity;
            this.players.add(entityHuman);
            this.everyoneSleeping();
        }
        this.getChunkAt(n, n2).a(entity);
        this.entityList.add(entity);
        this.c(entity);
        return true;
    }

    protected void c(Entity entity) {
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).a(entity);
        }
    }

    protected void d(Entity entity) {
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).b(entity);
        }
    }

    public void kill(Entity entity) {
        if (entity.passenger != null) {
            entity.passenger.mount(null);
        }
        if (entity.vehicle != null) {
            entity.mount(null);
        }
        entity.die();
        if (entity instanceof EntityHuman) {
            this.players.remove((EntityHuman)entity);
            this.everyoneSleeping();
        }
    }

    public void removeEntity(Entity entity) {
        entity.die();
        if (entity instanceof EntityHuman) {
            this.players.remove((EntityHuman)entity);
            this.everyoneSleeping();
        }
        int n = entity.bH;
        int n2 = entity.bJ;
        if (entity.bG && this.isChunkLoaded(n, n2)) {
            this.getChunkAt(n, n2).b(entity);
        }
        this.entityList.remove(entity);
        this.d(entity);
    }

    public void addIWorldAccess(IWorldAccess iWorldAccess) {
        this.u.add(iWorldAccess);
    }

    public List getEntities(Entity entity, AxisAlignedBB axisAlignedBB) {
        this.K.clear();
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n5; j < n6; ++j) {
                if (!this.isLoaded(i, 64, j)) continue;
                for (int k = n3 - 1; k < n4; ++k) {
                    Block block = Block.byId[this.getTypeId(i, k, j)];
                    if (block == null) continue;
                    block.a(this, i, k, j, axisAlignedBB, this.K);
                }
            }
        }
        double d = 0.25;
        List list = this.b(entity, axisAlignedBB.b(d, d, d));
        for (int i = 0; i < list.size(); ++i) {
            AxisAlignedBB axisAlignedBB2 = ((Entity)list.get(i)).e_();
            if (axisAlignedBB2 != null && axisAlignedBB2.a(axisAlignedBB)) {
                this.K.add(axisAlignedBB2);
            }
            if ((axisAlignedBB2 = entity.a_((Entity)list.get(i))) == null || !axisAlignedBB2.a(axisAlignedBB)) continue;
            this.K.add(axisAlignedBB2);
        }
        return this.K;
    }

    public int a(float f) {
        float f2 = this.b(f);
        float f3 = 1.0f - (MathHelper.cos(f2 * (float)Math.PI * 2.0f) * 2.0f + 0.5f);
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        f3 = 1.0f - f3;
        f3 = (float)((double)f3 * (1.0 - (double)(this.d(f) * 5.0f) / 16.0));
        f3 = (float)((double)f3 * (1.0 - (double)(this.c(f) * 5.0f) / 16.0));
        f3 = 1.0f - f3;
        return (int)(f3 * 11.0f);
    }

    public float b(float f) {
        return this.worldProvider.a(this.worldData.f(), f);
    }

    public int e(int n, int n2) {
        Chunk chunk = this.getChunkAtWorldCoords(n, n2);
        n &= 0xF;
        n2 &= 0xF;
        for (int i = 127; i > 0; --i) {
            Material material;
            int n3 = chunk.getTypeId(n, i, n2);
            Material material2 = material = n3 == 0 ? Material.AIR : Block.byId[n3].material;
            if (!material.isSolid() && !material.isLiquid()) continue;
            return i + 1;
        }
        return -1;
    }

    public int f(int n, int n2) {
        Chunk chunk = this.getChunkAtWorldCoords(n, n2);
        n &= 0xF;
        n2 &= 0xF;
        for (int i = 127; i > 0; --i) {
            int n3 = chunk.getTypeId(n, i, n2);
            if (n3 == 0 || !Block.byId[n3].material.isSolid()) continue;
            return i + 1;
        }
        return -1;
    }

    public void c(int n, int n2, int n3, int n4, int n5) {
        NextTickListEntry nextTickListEntry = new NextTickListEntry(n, n2, n3, n4);
        int n6 = 8;
        if (this.a) {
            int n7;
            if (this.a(nextTickListEntry.a - n6, nextTickListEntry.b - n6, nextTickListEntry.c - n6, nextTickListEntry.a + n6, nextTickListEntry.b + n6, nextTickListEntry.c + n6) && (n7 = this.getTypeId(nextTickListEntry.a, nextTickListEntry.b, nextTickListEntry.c)) == nextTickListEntry.d && n7 > 0) {
                Block.byId[n7].a(this, nextTickListEntry.a, nextTickListEntry.b, nextTickListEntry.c, this.random);
            }
        } else if (this.a(n - n6, n2 - n6, n3 - n6, n + n6, n2 + n6, n3 + n6)) {
            if (n4 > 0) {
                nextTickListEntry.a((long)n5 + this.worldData.f());
            }
            if (!this.F.contains(nextTickListEntry)) {
                this.F.add(nextTickListEntry);
                this.E.add(nextTickListEntry);
            }
        }
    }

    public void cleanUp() {
        int n;
        int n2;
        Entity entity;
        int n3;
        for (n3 = 0; n3 < this.e.size(); ++n3) {
            entity = (Entity)this.e.get(n3);
            entity.m_();
            if (!entity.dead) continue;
            this.e.remove(n3--);
        }
        this.entityList.removeAll(this.D);
        for (n3 = 0; n3 < this.D.size(); ++n3) {
            entity = (Entity)this.D.get(n3);
            n2 = entity.bH;
            n = entity.bJ;
            if (!entity.bG || !this.isChunkLoaded(n2, n)) continue;
            this.getChunkAt(n2, n).b(entity);
        }
        for (n3 = 0; n3 < this.D.size(); ++n3) {
            this.d((Entity)this.D.get(n3));
        }
        this.D.clear();
        for (n3 = 0; n3 < this.entityList.size(); ++n3) {
            entity = (Entity)this.entityList.get(n3);
            if (entity.vehicle != null) {
                if (!entity.vehicle.dead && entity.vehicle.passenger == entity) continue;
                entity.vehicle.passenger = null;
                entity.vehicle = null;
            }
            if (!entity.dead) {
                this.playerJoinedWorld(entity);
            }
            if (!entity.dead) continue;
            n2 = entity.bH;
            n = entity.bJ;
            if (entity.bG && this.isChunkLoaded(n2, n)) {
                this.getChunkAt(n2, n).b(entity);
            }
            this.entityList.remove(n3--);
            this.d(entity);
        }
        this.L = true;
        Iterator iterator = this.c.iterator();
        while (iterator.hasNext()) {
            TileEntity tileEntity = (TileEntity)iterator.next();
            if (!tileEntity.g()) {
                tileEntity.g_();
            }
            if (!tileEntity.g()) continue;
            iterator.remove();
            Object object = this.getChunkAt(tileEntity.x >> 4, tileEntity.z >> 4);
            if (object == null) continue;
            ((Chunk)object).e(tileEntity.x & 0xF, tileEntity.y, tileEntity.z & 0xF);
        }
        this.L = false;
        if (!this.G.isEmpty()) {
            for (Object object : this.G) {
                Chunk chunk;
                if (((TileEntity)object).g()) continue;
                if (!this.c.contains(object)) {
                    this.c.add(object);
                }
                if ((chunk = this.getChunkAt(((TileEntity)object).x >> 4, ((TileEntity)object).z >> 4)) != null) {
                    chunk.a(((TileEntity)object).x & 0xF, ((TileEntity)object).y, ((TileEntity)object).z & 0xF, (TileEntity)object);
                }
                this.notify(((TileEntity)object).x, ((TileEntity)object).y, ((TileEntity)object).z);
            }
            this.G.clear();
        }
    }

    public void a(Collection collection) {
        if (this.L) {
            this.G.addAll(collection);
        } else {
            this.c.addAll(collection);
        }
    }

    public void playerJoinedWorld(Entity entity) {
        this.entityJoinedWorld(entity, true);
    }

    public void entityJoinedWorld(Entity entity, boolean bl) {
        int n = MathHelper.floor(entity.locX);
        int n2 = MathHelper.floor(entity.locZ);
        int n3 = 32;
        if (!bl || this.a(n - n3, 0, n2 - n3, n + n3, 128, n2 + n3)) {
            entity.bo = entity.locX;
            entity.bp = entity.locY;
            entity.bq = entity.locZ;
            entity.lastYaw = entity.yaw;
            entity.lastPitch = entity.pitch;
            if (bl && entity.bG) {
                if (entity.vehicle != null) {
                    entity.E();
                } else {
                    entity.m_();
                }
            }
            if (Double.isNaN(entity.locX) || Double.isInfinite(entity.locX)) {
                entity.locX = entity.bo;
            }
            if (Double.isNaN(entity.locY) || Double.isInfinite(entity.locY)) {
                entity.locY = entity.bp;
            }
            if (Double.isNaN(entity.locZ) || Double.isInfinite(entity.locZ)) {
                entity.locZ = entity.bq;
            }
            if (Double.isNaN(entity.pitch) || Double.isInfinite(entity.pitch)) {
                entity.pitch = entity.lastPitch;
            }
            if (Double.isNaN(entity.yaw) || Double.isInfinite(entity.yaw)) {
                entity.yaw = entity.lastYaw;
            }
            int n4 = MathHelper.floor(entity.locX / 16.0);
            int n5 = MathHelper.floor(entity.locY / 16.0);
            int n6 = MathHelper.floor(entity.locZ / 16.0);
            if (!entity.bG || entity.bH != n4 || entity.bI != n5 || entity.bJ != n6) {
                if (entity.bG && this.isChunkLoaded(entity.bH, entity.bJ)) {
                    this.getChunkAt(entity.bH, entity.bJ).a(entity, entity.bI);
                }
                if (this.isChunkLoaded(n4, n6)) {
                    entity.bG = true;
                    this.getChunkAt(n4, n6).a(entity);
                } else {
                    entity.bG = false;
                }
            }
            if (bl && entity.bG && entity.passenger != null) {
                if (!entity.passenger.dead && entity.passenger.vehicle == entity) {
                    this.playerJoinedWorld(entity.passenger);
                } else {
                    entity.passenger.vehicle = null;
                    entity.passenger = null;
                }
            }
        }
    }

    public boolean containsEntity(AxisAlignedBB axisAlignedBB) {
        List list = this.b((Entity)null, axisAlignedBB);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity.dead || !entity.aI) continue;
            return false;
        }
        return true;
    }

    public boolean b(AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        if (axisAlignedBB.a < 0.0) {
            --n;
        }
        if (axisAlignedBB.b < 0.0) {
            --n3;
        }
        if (axisAlignedBB.c < 0.0) {
            --n5;
        }
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = Block.byId[this.getTypeId(i, j, k)];
                    if (block == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean c(AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        if (axisAlignedBB.a < 0.0) {
            --n;
        }
        if (axisAlignedBB.b < 0.0) {
            --n3;
        }
        if (axisAlignedBB.c < 0.0) {
            --n5;
        }
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = Block.byId[this.getTypeId(i, j, k)];
                    if (block == null || !block.material.isLiquid()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean d(AxisAlignedBB axisAlignedBB) {
        int n;
        int n2 = MathHelper.floor(axisAlignedBB.a);
        int n3 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n4 = MathHelper.floor(axisAlignedBB.b);
        int n5 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n6 = MathHelper.floor(axisAlignedBB.c);
        if (this.a(n2, n4, n6, n3, n5, n = MathHelper.floor(axisAlignedBB.f + 1.0))) {
            for (int i = n2; i < n3; ++i) {
                for (int j = n4; j < n5; ++j) {
                    for (int k = n6; k < n; ++k) {
                        int n7 = this.getTypeId(i, j, k);
                        if (n7 != Block.FIRE.id && n7 != Block.LAVA.id && n7 != Block.STATIONARY_LAVA.id) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean a(AxisAlignedBB axisAlignedBB, Material material, Entity entity) {
        int n;
        int n2 = MathHelper.floor(axisAlignedBB.a);
        int n3 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n4 = MathHelper.floor(axisAlignedBB.b);
        int n5 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n6 = MathHelper.floor(axisAlignedBB.c);
        if (!this.a(n2, n4, n6, n3, n5, n = MathHelper.floor(axisAlignedBB.f + 1.0))) {
            return false;
        }
        boolean bl = false;
        Vec3D vec3D = Vec3D.create(0.0, 0.0, 0.0);
        for (int i = n2; i < n3; ++i) {
            for (int j = n4; j < n5; ++j) {
                for (int k = n6; k < n; ++k) {
                    double d;
                    Block block = Block.byId[this.getTypeId(i, j, k)];
                    if (block == null || block.material != material || !((double)n5 >= (d = (double)((float)(j + 1) - BlockFluids.c(this.getData(i, j, k)))))) continue;
                    bl = true;
                    block.a(this, i, j, k, entity, vec3D);
                }
            }
        }
        if (vec3D.c() > 0.0) {
            vec3D = vec3D.b();
            double d = 0.014;
            entity.motX += vec3D.a * d;
            entity.motY += vec3D.b * d;
            entity.motZ += vec3D.c * d;
        }
        return bl;
    }

    public boolean a(AxisAlignedBB axisAlignedBB, Material material) {
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = Block.byId[this.getTypeId(i, j, k)];
                    if (block == null || block.material != material) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean b(AxisAlignedBB axisAlignedBB, Material material) {
        int n = MathHelper.floor(axisAlignedBB.a);
        int n2 = MathHelper.floor(axisAlignedBB.d + 1.0);
        int n3 = MathHelper.floor(axisAlignedBB.b);
        int n4 = MathHelper.floor(axisAlignedBB.e + 1.0);
        int n5 = MathHelper.floor(axisAlignedBB.c);
        int n6 = MathHelper.floor(axisAlignedBB.f + 1.0);
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = Block.byId[this.getTypeId(i, j, k)];
                    if (block == null || block.material != material) continue;
                    int n7 = this.getData(i, j, k);
                    double d = j + 1;
                    if (n7 < 8) {
                        d = (double)(j + 1) - (double)n7 / 8.0;
                    }
                    if (!(d >= axisAlignedBB.b)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Explosion a(Entity entity, double d, double d2, double d3, float f) {
        return this.createExplosion(entity, d, d2, d3, f, false);
    }

    public Explosion createExplosion(Entity entity, double d, double d2, double d3, float f, boolean bl) {
        Explosion explosion = new Explosion(this, entity, d, d2, d3, f);
        explosion.a = bl;
        explosion.a();
        explosion.a(true);
        return explosion;
    }

    public float a(Vec3D vec3D, AxisAlignedBB axisAlignedBB) {
        double d = 1.0 / ((axisAlignedBB.d - axisAlignedBB.a) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisAlignedBB.e - axisAlignedBB.b) * 2.0 + 1.0);
        double d3 = 1.0 / ((axisAlignedBB.f - axisAlignedBB.c) * 2.0 + 1.0);
        int n = 0;
        int n2 = 0;
        float f = 0.0f;
        while (f <= 1.0f) {
            float f2 = 0.0f;
            while (f2 <= 1.0f) {
                float f3 = 0.0f;
                while (f3 <= 1.0f) {
                    double d4 = axisAlignedBB.a + (axisAlignedBB.d - axisAlignedBB.a) * (double)f;
                    double d5 = axisAlignedBB.b + (axisAlignedBB.e - axisAlignedBB.b) * (double)f2;
                    double d6 = axisAlignedBB.c + (axisAlignedBB.f - axisAlignedBB.c) * (double)f3;
                    if (this.a(Vec3D.create(d4, d5, d6), vec3D) == null) {
                        ++n;
                    }
                    ++n2;
                    f3 = (float)((double)f3 + d3);
                }
                f2 = (float)((double)f2 + d2);
            }
            f = (float)((double)f + d);
        }
        return (float)n / (float)n2;
    }

    public void douseFire(EntityHuman entityHuman, int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            --n2;
        }
        if (n4 == 1) {
            ++n2;
        }
        if (n4 == 2) {
            --n3;
        }
        if (n4 == 3) {
            ++n3;
        }
        if (n4 == 4) {
            --n;
        }
        if (n4 == 5) {
            ++n;
        }
        if (this.getTypeId(n, n2, n3) == Block.FIRE.id) {
            this.a(entityHuman, 1004, n, n2, n3, 0);
            this.setTypeId(n, n2, n3, 0);
        }
    }

    @Override
    public TileEntity getTileEntity(int n, int n2, int n3) {
        Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
        return chunk != null ? chunk.d(n & 0xF, n2, n3 & 0xF) : null;
    }

    public void setTileEntity(int n, int n2, int n3, TileEntity tileEntity) {
        if (!tileEntity.g()) {
            if (this.L) {
                tileEntity.x = n;
                tileEntity.y = n2;
                tileEntity.z = n3;
                this.G.add(tileEntity);
            } else {
                this.c.add(tileEntity);
                Chunk chunk = this.getChunkAt(n >> 4, n3 >> 4);
                if (chunk != null) {
                    chunk.a(n & 0xF, n2, n3 & 0xF, tileEntity);
                }
            }
        }
    }

    public void o(int n, int n2, int n3) {
        TileEntity tileEntity = this.getTileEntity(n, n2, n3);
        if (tileEntity != null && this.L) {
            tileEntity.h();
        } else {
            Chunk chunk;
            if (tileEntity != null) {
                this.c.remove(tileEntity);
            }
            if ((chunk = this.getChunkAt(n >> 4, n3 >> 4)) != null) {
                chunk.e(n & 0xF, n2, n3 & 0xF);
            }
        }
    }

    public boolean p(int n, int n2, int n3) {
        Block block = Block.byId[this.getTypeId(n, n2, n3)];
        return block == null ? false : block.a();
    }

    @Override
    public boolean e(int n, int n2, int n3) {
        Block block = Block.byId[this.getTypeId(n, n2, n3)];
        return block == null ? false : block.material.h() && block.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doLighting() {
        boolean bl;
        if (this.M >= 50) {
            return false;
        }
        ++this.M;
        try {
            int n = 500;
            while (this.C.size() > 0) {
                if (--n <= 0) {
                    boolean bl2;
                    boolean bl3 = bl2 = true;
                    return bl3;
                }
                ((MetadataChunkBlock)this.C.remove(this.C.size() - 1)).a(this);
            }
            bl = false;
        }
        finally {
            --this.M;
        }
        return bl;
    }

    public void a(EnumSkyBlock enumSkyBlock, int n, int n2, int n3, int n4, int n5, int n6) {
        this.a(enumSkyBlock, n, n2, n3, n4, n5, n6, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(EnumSkyBlock enumSkyBlock, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (!this.worldProvider.e || enumSkyBlock != EnumSkyBlock.SKY) {
            ++A;
            try {
                int n7;
                if (A == 50) {
                    return;
                }
                int n8 = (n4 + n) / 2;
                int n9 = (n6 + n3) / 2;
                if (!this.isLoaded(n8, 64, n9)) {
                    return;
                }
                if (this.getChunkAtWorldCoords(n8, n9).isEmpty()) {
                    return;
                }
                int n10 = this.C.size();
                if (bl) {
                    n7 = 5;
                    if (n7 > n10) {
                        n7 = n10;
                    }
                    for (int i = 0; i < n7; ++i) {
                        MetadataChunkBlock metadataChunkBlock = (MetadataChunkBlock)this.C.get(this.C.size() - i - 1);
                        if (metadataChunkBlock.a != enumSkyBlock || !metadataChunkBlock.a(n, n2, n3, n4, n5, n6)) continue;
                        return;
                    }
                }
                this.C.add(new MetadataChunkBlock(enumSkyBlock, n, n2, n3, n4, n5, n6));
                n7 = 1000000;
                if (this.C.size() > 1000000) {
                    System.out.println("More than " + n7 + " updates, aborting lighting updates");
                    this.C.clear();
                }
            }
            finally {
                --A;
            }
        }
    }

    public void g() {
        int n = this.a(1.0f);
        if (n != this.f) {
            this.f = n;
        }
    }

    public void setSpawnFlags(boolean bl, boolean bl2) {
        this.allowMonsters = bl;
        this.allowAnimals = bl2;
    }

    public void doTick() {
        long l;
        int n;
        this.i();
        if (this.everyoneDeeplySleeping()) {
            n = 0;
            if (this.allowMonsters && this.spawnMonsters >= 1) {
                n = SpawnerCreature.a(this, this.players);
            }
            if (n == 0) {
                l = this.worldData.f() + 24000L;
                this.worldData.a(l - l % 24000L);
                this.s();
            }
        }
        SpawnerCreature.spawnEntities(this, this.allowMonsters, this.allowAnimals);
        this.chunkProvider.unloadChunks();
        n = this.a(1.0f);
        if (n != this.f) {
            this.f = n;
            for (int i = 0; i < this.u.size(); ++i) {
                ((IWorldAccess)this.u.get(i)).a();
            }
        }
        if ((l = this.worldData.f() + 1L) % (long)this.p == 0L) {
            this.save(false, null);
        }
        this.worldData.a(l);
        this.a(false);
        this.j();
    }

    private void x() {
        if (this.worldData.hasStorm()) {
            this.j = 1.0f;
            if (this.worldData.isThundering()) {
                this.l = 1.0f;
            }
        }
    }

    protected void i() {
        if (!this.worldProvider.e) {
            int n;
            if (this.m > 0) {
                --this.m;
            }
            if ((n = this.worldData.getThunderDuration()) <= 0) {
                if (this.worldData.isThundering()) {
                    this.worldData.setThunderDuration(this.random.nextInt(12000) + 3600);
                } else {
                    this.worldData.setThunderDuration(this.random.nextInt(168000) + 12000);
                }
            } else {
                this.worldData.setThunderDuration(--n);
                if (n <= 0) {
                    this.worldData.setThundering(!this.worldData.isThundering());
                }
            }
            int n2 = this.worldData.getWeatherDuration();
            if (n2 <= 0) {
                if (this.worldData.hasStorm()) {
                    this.worldData.setWeatherDuration(this.random.nextInt(12000) + 12000);
                } else {
                    this.worldData.setWeatherDuration(this.random.nextInt(168000) + 12000);
                }
            } else {
                this.worldData.setWeatherDuration(--n2);
                if (n2 <= 0) {
                    this.worldData.setStorm(!this.worldData.hasStorm());
                }
            }
            this.i = this.j;
            this.j = this.worldData.hasStorm() ? (float)((double)this.j + 0.01) : (float)((double)this.j - 0.01);
            if (this.j < 0.0f) {
                this.j = 0.0f;
            }
            if (this.j > 1.0f) {
                this.j = 1.0f;
            }
            this.k = this.l;
            this.l = this.worldData.isThundering() ? (float)((double)this.l + 0.01) : (float)((double)this.l - 0.01);
            if (this.l < 0.0f) {
                this.l = 0.0f;
            }
            if (this.l > 1.0f) {
                this.l = 1.0f;
            }
        }
    }

    private void y() {
        this.worldData.setWeatherDuration(0);
        this.worldData.setStorm(false);
        this.worldData.setThunderDuration(0);
        this.worldData.setThundering(false);
    }

    protected void j() {
        int n;
        int n2;
        int n3;
        int n4;
        this.P.clear();
        for (int i = 0; i < this.players.size(); ++i) {
            Object object = (EntityHuman)this.players.get(i);
            n4 = MathHelper.floor(((EntityHuman)object).locX / 16.0);
            n3 = MathHelper.floor(((EntityHuman)object).locZ / 16.0);
            int n5 = 9;
            for (n2 = -n5; n2 <= n5; ++n2) {
                for (n = -n5; n <= n5; ++n) {
                    this.P.add(new ChunkCoordIntPair(n2 + n4, n + n3));
                }
            }
        }
        if (this.Q > 0) {
            --this.Q;
        }
        for (Object object : this.P) {
            int n6;
            int n7;
            int n8;
            n4 = ((ChunkCoordIntPair)object).x * 16;
            n3 = ((ChunkCoordIntPair)object).z * 16;
            Chunk chunk = this.getChunkAt(((ChunkCoordIntPair)object).x, ((ChunkCoordIntPair)object).z);
            if (this.Q == 0) {
                EntityHuman entityHuman;
                this.g = this.g * 3 + 1013904223;
                n2 = this.g >> 2;
                n = n2 & 0xF;
                n8 = n2 >> 8 & 0xF;
                n7 = n2 >> 16 & 0x7F;
                n6 = chunk.getTypeId(n, n7, n8);
                if (n6 == 0 && this.k(n += n4, n7, n8 += n3) <= this.random.nextInt(8) && this.a(EnumSkyBlock.SKY, n, n7, n8) <= 0 && (entityHuman = this.a((double)n + 0.5, (double)n7 + 0.5, (double)n8 + 0.5, 8.0)) != null && entityHuman.d((double)n + 0.5, (double)n7 + 0.5, (double)n8 + 0.5) > 4.0) {
                    this.makeSound((double)n + 0.5, (double)n7 + 0.5, (double)n8 + 0.5, "ambient.cave.cave", 0.7f, 0.8f + this.random.nextFloat() * 0.2f);
                    this.Q = this.random.nextInt(12000) + 6000;
                }
            }
            if (this.random.nextInt(100000) == 0 && this.v() && this.u()) {
                this.g = this.g * 3 + 1013904223;
                n2 = this.g >> 2;
                n = n4 + (n2 & 0xF);
                n8 = n3 + (n2 >> 8 & 0xF);
                n7 = this.e(n, n8);
                if (this.s(n, n7, n8)) {
                    this.strikeLightning(new EntityWeatherStorm(this, n, n7, n8));
                    this.m = 2;
                }
            }
            if (this.random.nextInt(16) == 0) {
                this.g = this.g * 3 + 1013904223;
                n2 = this.g >> 2;
                n = n2 & 0xF;
                n8 = n2 >> 8 & 0xF;
                n7 = this.e(n + n4, n8 + n3);
                if (this.getWorldChunkManager().getBiome(n + n4, n8 + n3).c() && n7 >= 0 && n7 < 128 && chunk.a(EnumSkyBlock.BLOCK, n, n7, n8) < 10) {
                    n6 = chunk.getTypeId(n, n7 - 1, n8);
                    int n9 = chunk.getTypeId(n, n7, n8);
                    if (this.v() && n9 == 0 && Block.SNOW.canPlace(this, n + n4, n7, n8 + n3) && n6 != 0 && n6 != Block.ICE.id && Block.byId[n6].material.isSolid()) {
                        this.setTypeId(n + n4, n7, n8 + n3, Block.SNOW.id);
                    }
                    if (n6 == Block.STATIONARY_WATER.id && chunk.getData(n, n7 - 1, n8) == 0) {
                        this.setTypeId(n + n4, n7 - 1, n8 + n3, Block.ICE.id);
                    }
                }
            }
            for (n2 = 0; n2 < 80; ++n2) {
                this.g = this.g * 3 + 1013904223;
                n = this.g >> 2;
                n8 = n & 0xF;
                n7 = n >> 8 & 0xF;
                n6 = n >> 16 & 0x7F;
                int n10 = chunk.b[n8 << 11 | n7 << 7 | n6] & 0xFF;
                if (!Block.n[n10]) continue;
                Block.byId[n10].a(this, n8 + n4, n6, n7 + n3, this.random);
            }
        }
    }

    public boolean a(boolean bl) {
        int n = this.E.size();
        if (n != this.F.size()) {
            throw new IllegalStateException("TickNextTick list out of synch");
        }
        if (n > 1000) {
            n = 1000;
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            NextTickListEntry nextTickListEntry = (NextTickListEntry)this.E.first();
            if (!bl && nextTickListEntry.e > this.worldData.f()) break;
            this.E.remove(nextTickListEntry);
            this.F.remove(nextTickListEntry);
            int n3 = 8;
            if (!this.a(nextTickListEntry.a - n3, nextTickListEntry.b - n3, nextTickListEntry.c - n3, nextTickListEntry.a + n3, nextTickListEntry.b + n3, nextTickListEntry.c + n3) || (n2 = this.getTypeId(nextTickListEntry.a, nextTickListEntry.b, nextTickListEntry.c)) != nextTickListEntry.d || n2 <= 0) continue;
            Block.byId[n2].a(this, nextTickListEntry.a, nextTickListEntry.b, nextTickListEntry.c, this.random);
        }
        return this.E.size() != 0;
    }

    public List b(Entity entity, AxisAlignedBB axisAlignedBB) {
        this.R.clear();
        int n = MathHelper.floor((axisAlignedBB.a - 2.0) / 16.0);
        int n2 = MathHelper.floor((axisAlignedBB.d + 2.0) / 16.0);
        int n3 = MathHelper.floor((axisAlignedBB.c - 2.0) / 16.0);
        int n4 = MathHelper.floor((axisAlignedBB.f + 2.0) / 16.0);
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                if (!this.isChunkLoaded(i, j)) continue;
                this.getChunkAt(i, j).a(entity, axisAlignedBB, this.R);
            }
        }
        return this.R;
    }

    public List a(Class clazz, AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.floor((axisAlignedBB.a - 2.0) / 16.0);
        int n2 = MathHelper.floor((axisAlignedBB.d + 2.0) / 16.0);
        int n3 = MathHelper.floor((axisAlignedBB.c - 2.0) / 16.0);
        int n4 = MathHelper.floor((axisAlignedBB.f + 2.0) / 16.0);
        ArrayList arrayList = new ArrayList();
        for (int i = n; i <= n2; ++i) {
            for (int j = n3; j <= n4; ++j) {
                if (!this.isChunkLoaded(i, j)) continue;
                this.getChunkAt(i, j).a(clazz, axisAlignedBB, arrayList);
            }
        }
        return arrayList;
    }

    public void b(int n, int n2, int n3, TileEntity tileEntity) {
        if (this.isLoaded(n, n2, n3)) {
            this.getChunkAtWorldCoords(n, n3).f();
        }
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).a(n, n2, n3, tileEntity);
        }
    }

    public int a(Class clazz) {
        int n = 0;
        for (int i = 0; i < this.entityList.size(); ++i) {
            Entity entity = (Entity)this.entityList.get(i);
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            ++n;
        }
        return n;
    }

    public void a(List list) {
        this.entityList.addAll(list);
        for (int i = 0; i < list.size(); ++i) {
            this.c((Entity)list.get(i));
        }
    }

    public void b(List list) {
        this.D.addAll(list);
    }

    public boolean a(int n, int n2, int n3, int n4, boolean bl, int n5) {
        int n6 = this.getTypeId(n2, n3, n4);
        Block block = Block.byId[n6];
        Block block2 = Block.byId[n];
        AxisAlignedBB axisAlignedBB = block2.d(this, n2, n3, n4);
        if (bl) {
            axisAlignedBB = null;
        }
        if (axisAlignedBB != null && !this.containsEntity(axisAlignedBB)) {
            return false;
        }
        if (block == Block.WATER || block == Block.STATIONARY_WATER || block == Block.LAVA || block == Block.STATIONARY_LAVA || block == Block.FIRE || block == Block.SNOW) {
            block = null;
        }
        return n > 0 && block == null && block2.canPlace(this, n2, n3, n4, n5);
    }

    public PathEntity findPath(Entity entity, Entity entity2, float f) {
        int n = MathHelper.floor(entity.locX);
        int n2 = MathHelper.floor(entity.locY);
        int n3 = MathHelper.floor(entity.locZ);
        int n4 = (int)(f + 16.0f);
        int n5 = n - n4;
        int n6 = n2 - n4;
        int n7 = n3 - n4;
        int n8 = n + n4;
        int n9 = n2 + n4;
        int n10 = n3 + n4;
        ChunkCache chunkCache = new ChunkCache(this, n5, n6, n7, n8, n9, n10);
        return new Pathfinder(chunkCache).a(entity, entity2, f);
    }

    public PathEntity a(Entity entity, int n, int n2, int n3, float f) {
        int n4 = MathHelper.floor(entity.locX);
        int n5 = MathHelper.floor(entity.locY);
        int n6 = MathHelper.floor(entity.locZ);
        int n7 = (int)(f + 8.0f);
        int n8 = n4 - n7;
        int n9 = n5 - n7;
        int n10 = n6 - n7;
        int n11 = n4 + n7;
        int n12 = n5 + n7;
        int n13 = n6 + n7;
        ChunkCache chunkCache = new ChunkCache(this, n8, n9, n10, n11, n12, n13);
        return new Pathfinder(chunkCache).a(entity, n, n2, n3, f);
    }

    public boolean isBlockFacePowered(int n, int n2, int n3, int n4) {
        int n5 = this.getTypeId(n, n2, n3);
        return n5 == 0 ? false : Block.byId[n5].d(this, n, n2, n3, n4);
    }

    public boolean isBlockPowered(int n, int n2, int n3) {
        return this.isBlockFacePowered(n, n2 - 1, n3, 0) ? true : (this.isBlockFacePowered(n, n2 + 1, n3, 1) ? true : (this.isBlockFacePowered(n, n2, n3 - 1, 2) ? true : (this.isBlockFacePowered(n, n2, n3 + 1, 3) ? true : (this.isBlockFacePowered(n - 1, n2, n3, 4) ? true : this.isBlockFacePowered(n + 1, n2, n3, 5)))));
    }

    public boolean isBlockFaceIndirectlyPowered(int n, int n2, int n3, int n4) {
        if (this.e(n, n2, n3)) {
            return this.isBlockPowered(n, n2, n3);
        }
        int n5 = this.getTypeId(n, n2, n3);
        return n5 == 0 ? false : Block.byId[n5].a((IBlockAccess)this, n, n2, n3, n4);
    }

    public boolean isBlockIndirectlyPowered(int n, int n2, int n3) {
        return this.isBlockFaceIndirectlyPowered(n, n2 - 1, n3, 0) ? true : (this.isBlockFaceIndirectlyPowered(n, n2 + 1, n3, 1) ? true : (this.isBlockFaceIndirectlyPowered(n, n2, n3 - 1, 2) ? true : (this.isBlockFaceIndirectlyPowered(n, n2, n3 + 1, 3) ? true : (this.isBlockFaceIndirectlyPowered(n - 1, n2, n3, 4) ? true : this.isBlockFaceIndirectlyPowered(n + 1, n2, n3, 5)))));
    }

    public EntityHuman findNearbyPlayer(Entity entity, double d) {
        return this.a(entity.locX, entity.locY, entity.locZ, d);
    }

    public EntityHuman a(double d, double d2, double d3, double d4) {
        double d5 = -1.0;
        EntityHuman entityHuman = null;
        for (int i = 0; i < this.players.size(); ++i) {
            EntityHuman entityHuman2 = (EntityHuman)this.players.get(i);
            double d6 = entityHuman2.d(d, d2, d3);
            if (!(d4 < 0.0) && !(d6 < d4 * d4) || d5 != -1.0 && !(d6 < d5)) continue;
            d5 = d6;
            entityHuman = entityHuman2;
        }
        return entityHuman;
    }

    public EntityHuman a(String string) {
        for (int i = 0; i < this.players.size(); ++i) {
            if (!string.equals(((EntityHuman)this.players.get((int)i)).name)) continue;
            return (EntityHuman)this.players.get(i);
        }
        return null;
    }

    public byte[] getMultiChunkData(int n, int n2, int n3, int n4, int n5, int n6) {
        byte[] byArray = new byte[n4 * n5 * n6 * 5 / 2];
        int n7 = n >> 4;
        int n8 = n3 >> 4;
        int n9 = n + n4 - 1 >> 4;
        int n10 = n3 + n6 - 1 >> 4;
        int n11 = 0;
        int n12 = n2;
        int n13 = n2 + n5;
        if (n2 < 0) {
            n12 = 0;
        }
        if (n13 > 128) {
            n13 = 128;
        }
        for (int i = n7; i <= n9; ++i) {
            int n14 = n - i * 16;
            int n15 = n + n4 - i * 16;
            if (n14 < 0) {
                n14 = 0;
            }
            if (n15 > 16) {
                n15 = 16;
            }
            for (int j = n8; j <= n10; ++j) {
                int n16 = n3 - j * 16;
                int n17 = n3 + n6 - j * 16;
                if (n16 < 0) {
                    n16 = 0;
                }
                if (n17 > 16) {
                    n17 = 16;
                }
                n11 = this.getChunkAt(i, j).getData(byArray, n14, n12, n16, n15, n13, n17, n11);
            }
        }
        return byArray;
    }

    public void k() {
        this.w.b();
    }

    public void setTime(long l) {
        this.worldData.a(l);
    }

    public long getSeed() {
        return this.worldData.getSeed();
    }

    public long getTime() {
        return this.worldData.f();
    }

    public ChunkCoordinates getSpawn() {
        return new ChunkCoordinates(this.worldData.c(), this.worldData.d(), this.worldData.e());
    }

    public boolean a(EntityHuman entityHuman, int n, int n2, int n3) {
        return true;
    }

    public void a(Entity entity, byte by) {
    }

    public IChunkProvider o() {
        return this.chunkProvider;
    }

    public void playNote(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.getTypeId(n, n2, n3);
        if (n6 > 0) {
            Block.byId[n6].a(this, n, n2, n3, n4, n5);
        }
    }

    public IDataManager p() {
        return this.w;
    }

    public WorldData q() {
        return this.worldData;
    }

    public void everyoneSleeping() {
        this.J = !this.players.isEmpty();
        for (EntityHuman entityHuman : this.players) {
            if (entityHuman.isSleeping()) continue;
            this.J = false;
            break;
        }
    }

    protected void s() {
        this.J = false;
        for (EntityHuman entityHuman : this.players) {
            if (!entityHuman.isSleeping()) continue;
            entityHuman.a(false, false, true);
        }
        this.y();
    }

    public boolean everyoneDeeplySleeping() {
        if (this.J && !this.isStatic) {
            EntityHuman entityHuman;
            Iterator iterator = this.players.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((entityHuman = (EntityHuman)iterator.next()).isDeeplySleeping());
            return false;
        }
        return false;
    }

    public float c(float f) {
        return (this.k + (this.l - this.k) * f) * this.d(f);
    }

    public float d(float f) {
        return this.i + (this.j - this.i) * f;
    }

    public boolean u() {
        return (double)this.c(1.0f) > 0.9;
    }

    public boolean v() {
        return (double)this.d(1.0f) > 0.2;
    }

    public boolean s(int n, int n2, int n3) {
        if (!this.v()) {
            return false;
        }
        if (!this.isChunkLoaded(n, n2, n3)) {
            return false;
        }
        if (this.e(n, n3) > n2) {
            return false;
        }
        BiomeBase biomeBase = this.getWorldChunkManager().getBiome(n, n3);
        return biomeBase.c() ? false : biomeBase.d();
    }

    public void a(String string, WorldMapBase worldMapBase) {
        this.worldMaps.a(string, worldMapBase);
    }

    public WorldMapBase a(Class clazz, String string) {
        return this.worldMaps.a(clazz, string);
    }

    public int b(String string) {
        return this.worldMaps.a(string);
    }

    public void e(int n, int n2, int n3, int n4, int n5) {
        this.a(null, n, n2, n3, n4, n5);
    }

    public void a(EntityHuman entityHuman, int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < this.u.size(); ++i) {
            ((IWorldAccess)this.u.get(i)).a(entityHuman, n, n2, n3, n4, n5);
        }
    }
}

