/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertyManager {
    public static Logger a = Logger.getLogger("Minecraft");
    private Properties properties = new Properties();
    private File c;

    public PropertyManager(File file) {
        this.c = file;
        if (file.exists()) {
            try {
                this.properties.load(new FileInputStream(file));
            }
            catch (Exception exception) {
                a.log(Level.WARNING, "Failed to load " + file, exception);
                this.a();
            }
        } else {
            a.log(Level.WARNING, file + " does not exist");
            this.a();
        }
    }

    public void a() {
        a.log(Level.INFO, "Generating new properties file");
        this.savePropertiesFile();
    }

    public void savePropertiesFile() {
        try {
            this.properties.store(new FileOutputStream(this.c), "Minecraft server properties");
        }
        catch (Exception exception) {
            a.log(Level.WARNING, "Failed to save " + this.c, exception);
            this.a();
        }
    }

    public String getString(String string, String string2) {
        if (!this.properties.containsKey(string)) {
            this.properties.setProperty(string, string2);
            this.savePropertiesFile();
        }
        return this.properties.getProperty(string, string2);
    }

    public int getInt(String string, int n) {
        try {
            return Integer.parseInt(this.getString(string, "" + n));
        }
        catch (Exception exception) {
            this.properties.setProperty(string, "" + n);
            return n;
        }
    }

    public boolean getBoolean(String string, boolean bl) {
        try {
            return Boolean.parseBoolean(this.getString(string, "" + bl));
        }
        catch (Exception exception) {
            this.properties.setProperty(string, "" + bl);
            return bl;
        }
    }

    public void b(String string, boolean bl) {
        this.properties.setProperty(string, "" + bl);
        this.savePropertiesFile();
    }
}

