/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.ConsoleCommandHandler;
import net.minecraft.server.ConsoleLogManager;
import net.minecraft.server.ConvertProgressUpdater;
import net.minecraft.server.Convertable;
import net.minecraft.server.EntityTracker;
import net.minecraft.server.ICommandListener;
import net.minecraft.server.IUpdatePlayerListBox;
import net.minecraft.server.NetworkListenThread;
import net.minecraft.server.Packet4UpdateTime;
import net.minecraft.server.PropertyManager;
import net.minecraft.server.SecondaryWorldServer;
import net.minecraft.server.ServerCommand;
import net.minecraft.server.ServerConfigurationManager;
import net.minecraft.server.ServerGUI;
import net.minecraft.server.ServerNBTManager;
import net.minecraft.server.StatisticList;
import net.minecraft.server.ThreadCommandReader;
import net.minecraft.server.ThreadServerApplication;
import net.minecraft.server.ThreadSleepForever;
import net.minecraft.server.Vec3D;
import net.minecraft.server.WorldLoaderServer;
import net.minecraft.server.WorldManager;
import net.minecraft.server.WorldServer;

public class MinecraftServer
implements Runnable,
ICommandListener {
    public static Logger log = Logger.getLogger("Minecraft");
    public static HashMap trackerList = new HashMap();
    public NetworkListenThread networkListenThread;
    public PropertyManager propertyManager;
    public WorldServer[] worldServer;
    public ServerConfigurationManager serverConfigurationManager;
    private ConsoleCommandHandler consoleCommandHandler;
    private boolean isRunning = true;
    public boolean isStopped = false;
    int ticks = 0;
    public String i;
    public int j;
    private List r = new ArrayList();
    private List s = Collections.synchronizedList(new ArrayList());
    public EntityTracker[] tracker = new EntityTracker[2];
    public boolean onlineMode;
    public boolean spawnAnimals;
    public boolean pvpMode;
    public boolean allowFlight;

    public MinecraftServer() {
        new ThreadSleepForever(this);
    }

    private boolean init() throws IOException {
        this.consoleCommandHandler = new ConsoleCommandHandler(this);
        ThreadCommandReader threadCommandReader = new ThreadCommandReader(this);
        threadCommandReader.setDaemon(true);
        threadCommandReader.start();
        ConsoleLogManager.init();
        log.info("Starting minecraft server version Beta 1.7 PRERELEASE");
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            log.warning("**** NOT ENOUGH RAM!");
            log.warning("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        log.info("Loading properties");
        this.propertyManager = new PropertyManager(new File("server.properties"));
        String string = this.propertyManager.getString("server-ip", "");
        this.onlineMode = this.propertyManager.getBoolean("online-mode", true);
        this.spawnAnimals = this.propertyManager.getBoolean("spawn-animals", true);
        this.pvpMode = this.propertyManager.getBoolean("pvp", true);
        this.allowFlight = this.propertyManager.getBoolean("allow-flight", false);
        InetAddress inetAddress = null;
        if (string.length() > 0) {
            inetAddress = InetAddress.getByName(string);
        }
        int n = this.propertyManager.getInt("server-port", 25565);
        log.info("Starting Minecraft server on " + (string.length() == 0 ? "*" : string) + ":" + n);
        try {
            this.networkListenThread = new NetworkListenThread(this, inetAddress, n);
        }
        catch (IOException iOException) {
            log.warning("**** FAILED TO BIND TO PORT!");
            log.log(Level.WARNING, "The exception was: " + iOException.toString());
            log.warning("Perhaps a server is already running on that port?");
            return false;
        }
        if (!this.onlineMode) {
            log.warning("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            log.warning("The server will make no attempt to authenticate usernames. Beware.");
            log.warning("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            log.warning("To change this, set \"online-mode\" to \"true\" in the server.settings file.");
        }
        this.serverConfigurationManager = new ServerConfigurationManager(this);
        this.tracker[0] = new EntityTracker(this, 0);
        this.tracker[1] = new EntityTracker(this, -1);
        long l = System.nanoTime();
        String string2 = this.propertyManager.getString("level-name", "world");
        String string3 = this.propertyManager.getString("level-seed", "");
        long l2 = new Random().nextLong();
        if (string3.length() > 0) {
            try {
                l2 = Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                l2 = string3.hashCode();
            }
        }
        log.info("Preparing level \"" + string2 + "\"");
        this.a(new WorldLoaderServer(new File(".")), string2, l2);
        log.info("Done (" + (System.nanoTime() - l) + "ns)! For help, type \"help\" or \"?\"");
        return true;
    }

    private void a(Convertable convertable, String string, long l) throws IOException {
        int n;
        if (convertable.isConvertable(string)) {
            log.info("Converting map!");
            convertable.convert(string, new ConvertProgressUpdater(this));
        }
        this.worldServer = new WorldServer[2];
        ServerNBTManager serverNBTManager = new ServerNBTManager(new File("."), string, true);
        for (n = 0; n < this.worldServer.length; ++n) {
            this.worldServer[n] = n == 0 ? new WorldServer(this, serverNBTManager, string, n == 0 ? 0 : -1, l) : new SecondaryWorldServer(this, serverNBTManager, string, n == 0 ? 0 : -1, l, this.worldServer[0]);
            this.worldServer[n].addIWorldAccess(new WorldManager(this, this.worldServer[n]));
            this.worldServer[n].spawnMonsters = this.propertyManager.getBoolean("spawn-monsters", true) ? 1 : 0;
            this.worldServer[n].setSpawnFlags(this.propertyManager.getBoolean("spawn-monsters", true), this.spawnAnimals);
            this.serverConfigurationManager.setPlayerFileData(this.worldServer);
        }
        n = 196;
        long l2 = System.currentTimeMillis();
        for (int i = 0; i < this.worldServer.length; ++i) {
            log.info("Preparing start region for level " + i);
            if (i != 0 && !this.propertyManager.getBoolean("allow-nether", true)) continue;
            WorldServer worldServer = this.worldServer[i];
            ChunkCoordinates chunkCoordinates = worldServer.getSpawn();
            for (int j = -n; j <= n && this.isRunning; j += 16) {
                for (int k = -n; k <= n && this.isRunning; k += 16) {
                    long l3 = System.currentTimeMillis();
                    if (l3 < l2) {
                        l2 = l3;
                    }
                    if (l3 > l2 + 1000L) {
                        int n2 = (n * 2 + 1) * (n * 2 + 1);
                        int n3 = (j + n) * (n * 2 + 1) + k + 1;
                        this.a("Preparing spawn area", n3 * 100 / n2);
                        l2 = l3;
                    }
                    worldServer.chunkProviderServer.getChunkAt(chunkCoordinates.x + j >> 4, chunkCoordinates.z + k >> 4);
                    while (worldServer.doLighting() && this.isRunning) {
                    }
                }
            }
        }
        this.e();
    }

    private void a(String string, int n) {
        this.i = string;
        this.j = n;
        log.info(string + ": " + n + "%");
    }

    private void e() {
        this.i = null;
        this.j = 0;
    }

    private void saveChunks() {
        log.info("Saving chunks");
        for (int i = 0; i < this.worldServer.length; ++i) {
            WorldServer worldServer = this.worldServer[i];
            worldServer.save(true, null);
            worldServer.saveLevel();
        }
    }

    private void stop() {
        log.info("Stopping server");
        if (this.serverConfigurationManager != null) {
            this.serverConfigurationManager.savePlayers();
        }
        for (int i = 0; i < this.worldServer.length; ++i) {
            WorldServer worldServer = this.worldServer[i];
            if (worldServer == null) continue;
            this.saveChunks();
        }
    }

    public void a() {
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            if (this.init()) {
                long l = System.currentTimeMillis();
                long l2 = 0L;
                while (this.isRunning) {
                    long l3 = System.currentTimeMillis();
                    long l4 = l3 - l;
                    if (l4 > 2000L) {
                        log.warning("Can't keep up! Did the system time change, or is the server overloaded?");
                        l4 = 2000L;
                    }
                    if (l4 < 0L) {
                        log.warning("Time ran backwards! Did the system time change?");
                        l4 = 0L;
                    }
                    l2 += l4;
                    l = l3;
                    if (this.worldServer[0].everyoneDeeplySleeping()) {
                        this.h();
                        l2 = 0L;
                    } else {
                        while (l2 > 50L) {
                            l2 -= 50L;
                            this.h();
                        }
                    }
                    Thread.sleep(1L);
                }
                return;
            } else {
                while (this.isRunning) {
                    this.b();
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            log.log(Level.SEVERE, "Unexpected exception", throwable);
            while (this.isRunning) {
                this.b();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            return;
        }
        finally {
            try {
                this.stop();
                this.isStopped = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                System.exit(0);
            }
        }
    }

    private void h() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : trackerList.keySet()) {
            int n2 = (Integer)trackerList.get(string);
            if (n2 > 0) {
                trackerList.put(string, n2 - 1);
                continue;
            }
            arrayList.add(string);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            trackerList.remove(arrayList.get(n));
        }
        AxisAlignedBB.a();
        Vec3D.a();
        ++this.ticks;
        for (n = 0; n < this.worldServer.length; ++n) {
            if (n != 0 && !this.propertyManager.getBoolean("allow-nether", true)) continue;
            WorldServer worldServer = this.worldServer[n];
            if (this.ticks % 20 == 0) {
                this.serverConfigurationManager.a(new Packet4UpdateTime(worldServer.getTime()), worldServer.worldProvider.dimension);
            }
            worldServer.doTick();
            while (worldServer.doLighting()) {
            }
            worldServer.cleanUp();
        }
        this.networkListenThread.a();
        this.serverConfigurationManager.b();
        for (n = 0; n < this.tracker.length; ++n) {
            this.tracker[n].updatePlayers();
        }
        for (n = 0; n < this.r.size(); ++n) {
            ((IUpdatePlayerListBox)this.r.get(n)).a();
        }
        try {
            this.b();
        }
        catch (Exception exception) {
            log.log(Level.WARNING, "Unexpected exception while parsing console command", exception);
        }
    }

    public void issueCommand(String string, ICommandListener iCommandListener) {
        this.s.add(new ServerCommand(string, iCommandListener));
    }

    public void b() {
        while (this.s.size() > 0) {
            ServerCommand serverCommand = (ServerCommand)this.s.remove(0);
            this.consoleCommandHandler.handle(serverCommand);
        }
    }

    public void a(IUpdatePlayerListBox iUpdatePlayerListBox) {
        this.r.add(iUpdatePlayerListBox);
    }

    public static void main(String[] stringArray) {
        StatisticList.a();
        try {
            MinecraftServer minecraftServer = new MinecraftServer();
            if (!(GraphicsEnvironment.isHeadless() || stringArray.length > 0 && stringArray[0].equals("nogui"))) {
                ServerGUI.a(minecraftServer);
            }
            new ThreadServerApplication("Server thread", minecraftServer).start();
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Failed to start the minecraft server", exception);
        }
    }

    public File a(String string) {
        return new File(string);
    }

    @Override
    public void sendMessage(String string) {
        log.info(string);
    }

    public void c(String string) {
        log.warning(string);
    }

    @Override
    public String getName() {
        return "CONSOLE";
    }

    public WorldServer getWorldServer(int n) {
        return n == -1 ? this.worldServer[1] : this.worldServer[0];
    }

    public EntityTracker getTracker(int n) {
        return n == -1 ? this.tracker[1] : this.tracker[0];
    }

    public static boolean isRunning(MinecraftServer minecraftServer) {
        return minecraftServer.isRunning;
    }
}

