/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.Item;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.StatisticList;
import net.minecraft.server.World;

public final class ItemStack {
    public int count = 0;
    public int b;
    public int id;
    private int damage;

    public ItemStack(Block block) {
        this(block, 1);
    }

    public ItemStack(Block block, int n) {
        this(block.id, n, 0);
    }

    public ItemStack(Block block, int n, int n2) {
        this(block.id, n, n2);
    }

    public ItemStack(Item item) {
        this(item.id, 1, 0);
    }

    public ItemStack(Item item, int n) {
        this(item.id, n, 0);
    }

    public ItemStack(Item item, int n, int n2) {
        this(item.id, n, n2);
    }

    public ItemStack(int n, int n2, int n3) {
        this.id = n;
        this.count = n2;
        this.damage = n3;
    }

    public ItemStack(NBTTagCompound nBTTagCompound) {
        this.b(nBTTagCompound);
    }

    public ItemStack a(int n) {
        this.count -= n;
        return new ItemStack(this.id, n, this.damage);
    }

    public Item getItem() {
        return Item.byId[this.id];
    }

    public boolean placeItem(EntityHuman entityHuman, World world, int n, int n2, int n3, int n4) {
        boolean bl = this.getItem().a(this, entityHuman, world, n, n2, n3, n4);
        if (bl) {
            entityHuman.a(StatisticList.E[this.id], 1);
        }
        return bl;
    }

    public float a(Block block) {
        return this.getItem().a(this, block);
    }

    public ItemStack a(World world, EntityHuman entityHuman) {
        return this.getItem().a(this, world, entityHuman);
    }

    public NBTTagCompound a(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.a("id", (short)this.id);
        nBTTagCompound.a("Count", (byte)this.count);
        nBTTagCompound.a("Damage", (short)this.damage);
        return nBTTagCompound;
    }

    public void b(NBTTagCompound nBTTagCompound) {
        this.id = nBTTagCompound.d("id");
        this.count = nBTTagCompound.c("Count");
        this.damage = nBTTagCompound.d("Damage");
    }

    public int getMaxStackSize() {
        return this.getItem().getMaxStackSize();
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.d() || !this.f());
    }

    public boolean d() {
        return Item.byId[this.id].e() > 0;
    }

    public boolean usesData() {
        return Item.byId[this.id].d();
    }

    public boolean f() {
        return this.d() && this.damage > 0;
    }

    public int g() {
        return this.damage;
    }

    public int getData() {
        return this.damage;
    }

    public void b(int n) {
        this.damage = n;
    }

    public int i() {
        return Item.byId[this.id].e();
    }

    public void damage(int n, Entity entity) {
        if (this.d()) {
            this.damage += n;
            if (this.damage > this.i()) {
                if (entity instanceof EntityHuman) {
                    ((EntityHuman)entity).a(StatisticList.F[this.id], 1);
                }
                --this.count;
                if (this.count < 0) {
                    this.count = 0;
                }
                this.damage = 0;
            }
        }
    }

    public void a(EntityLiving entityLiving, EntityHuman entityHuman) {
        boolean bl = Item.byId[this.id].a(this, entityLiving, (EntityLiving)entityHuman);
        if (bl) {
            entityHuman.a(StatisticList.E[this.id], 1);
        }
    }

    public void a(int n, int n2, int n3, int n4, EntityHuman entityHuman) {
        boolean bl = Item.byId[this.id].a(this, n, n2, n3, n4, entityHuman);
        if (bl) {
            entityHuman.a(StatisticList.E[this.id], 1);
        }
    }

    public int a(Entity entity) {
        return Item.byId[this.id].a(entity);
    }

    public boolean b(Block block) {
        return Item.byId[this.id].a(block);
    }

    public void a(EntityHuman entityHuman) {
    }

    public void a(EntityLiving entityLiving) {
        Item.byId[this.id].a(this, entityLiving);
    }

    public ItemStack cloneItemStack() {
        return new ItemStack(this.id, this.count, this.damage);
    }

    public static boolean equals(ItemStack itemStack, ItemStack itemStack2) {
        return itemStack == null && itemStack2 == null ? true : (itemStack != null && itemStack2 != null ? itemStack.d(itemStack2) : false);
    }

    private boolean d(ItemStack itemStack) {
        return this.count != itemStack.count ? false : (this.id != itemStack.id ? false : this.damage == itemStack.damage);
    }

    public boolean doMaterialsMatch(ItemStack itemStack) {
        return this.id == itemStack.id && this.damage == itemStack.damage;
    }

    public static ItemStack b(ItemStack itemStack) {
        return itemStack == null ? null : itemStack.cloneItemStack();
    }

    public String toString() {
        return this.count + "x" + Item.byId[this.id].a() + "@" + this.damage;
    }

    public void a(World world, Entity entity, int n, boolean bl) {
        if (this.b > 0) {
            --this.b;
        }
        Item.byId[this.id].a(this, world, entity, n, bl);
    }

    public void b(World world, EntityHuman entityHuman) {
        entityHuman.a(StatisticList.D[this.id], this.count);
        Item.byId[this.id].c(this, world, entityHuman);
    }

    public boolean c(ItemStack itemStack) {
        return this.id == itemStack.id && this.count == itemStack.count && this.damage == itemStack.damage;
    }
}

