/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.AchievementList;
import net.minecraft.server.EntityAnimal;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityPigZombie;
import net.minecraft.server.EntityWeatherStorm;
import net.minecraft.server.Item;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityPig
extends EntityAnimal {
    public EntityPig(World world) {
        super(world);
        this.texture = "/mob/pig.png";
        this.b(0.9f, 0.9f);
    }

    @Override
    protected void b() {
        this.datawatcher.a(16, (byte)0);
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.a("Saddle", this.hasSaddle());
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setSaddle(nBTTagCompound.m("Saddle"));
    }

    @Override
    protected String g() {
        return "mob.pig";
    }

    @Override
    protected String h() {
        return "mob.pig";
    }

    @Override
    protected String i() {
        return "mob.pigdeath";
    }

    @Override
    public boolean a(EntityHuman entityHuman) {
        if (this.hasSaddle() && !this.world.isStatic && (this.passenger == null || this.passenger == entityHuman)) {
            entityHuman.mount(this);
            return true;
        }
        return false;
    }

    @Override
    protected int j() {
        return this.fireTicks > 0 ? Item.GRILLED_PORK.id : Item.PORK.id;
    }

    public boolean hasSaddle() {
        return (this.datawatcher.a(16) & 1) != 0;
    }

    public void setSaddle(boolean bl) {
        if (bl) {
            this.datawatcher.watch(16, (byte)1);
        } else {
            this.datawatcher.watch(16, (byte)0);
        }
    }

    @Override
    public void a(EntityWeatherStorm entityWeatherStorm) {
        if (!this.world.isStatic) {
            EntityPigZombie entityPigZombie = new EntityPigZombie(this.world);
            entityPigZombie.setPositionRotation(this.locX, this.locY, this.locZ, this.yaw, this.pitch);
            this.world.addEntity(entityPigZombie);
            this.die();
        }
    }

    @Override
    protected void a(float f) {
        super.a(f);
        if (f > 5.0f && this.passenger instanceof EntityHuman) {
            ((EntityHuman)this.passenger).a(AchievementList.u);
        }
    }
}

