/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.BlockMinecartTrack;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.IInventory;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public class EntityMinecart
extends Entity
implements IInventory {
    private ItemStack[] items = new ItemStack[36];
    public int damage = 0;
    public int b = 0;
    public int c = 1;
    private boolean i = false;
    public int type;
    public int e;
    public double f;
    public double g;
    private static final int[][][] matrix = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    private int k;
    private double l;
    private double m;
    private double n;
    private double o;
    private double p;

    public EntityMinecart(World world) {
        super(world);
        this.aI = true;
        this.b(0.98f, 0.7f);
        this.height = this.width / 2.0f;
    }

    @Override
    protected boolean n() {
        return false;
    }

    @Override
    protected void b() {
    }

    @Override
    public AxisAlignedBB a_(Entity entity) {
        return entity.boundingBox;
    }

    @Override
    public AxisAlignedBB e_() {
        return null;
    }

    @Override
    public boolean d_() {
        return true;
    }

    public EntityMinecart(World world, double d, double d2, double d3, int n) {
        this(world);
        this.setPosition(d, d2 + (double)this.height, d3);
        this.motX = 0.0;
        this.motY = 0.0;
        this.motZ = 0.0;
        this.lastX = d;
        this.lastY = d2;
        this.lastZ = d3;
        this.type = n;
    }

    @Override
    public double m() {
        return (double)this.width * 0.0 - (double)0.3f;
    }

    @Override
    public boolean damageEntity(Entity entity, int n) {
        if (!this.world.isStatic && !this.dead) {
            this.c = -this.c;
            this.b = 10;
            this.af();
            this.damage += n * 10;
            if (this.damage > 40) {
                if (this.passenger != null) {
                    this.passenger.mount(this);
                }
                this.die();
                this.a(Item.MINECART.id, 1, 0.0f);
                if (this.type == 1) {
                    EntityMinecart entityMinecart = this;
                    for (int i = 0; i < entityMinecart.getSize(); ++i) {
                        ItemStack itemStack = entityMinecart.getItem(i);
                        if (itemStack == null) continue;
                        float f = this.random.nextFloat() * 0.8f + 0.1f;
                        float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                        float f3 = this.random.nextFloat() * 0.8f + 0.1f;
                        while (itemStack.count > 0) {
                            int n2 = this.random.nextInt(21) + 10;
                            if (n2 > itemStack.count) {
                                n2 = itemStack.count;
                            }
                            itemStack.count -= n2;
                            EntityItem entityItem = new EntityItem(this.world, this.locX + (double)f, this.locY + (double)f2, this.locZ + (double)f3, new ItemStack(itemStack.id, n2, itemStack.getData()));
                            float f4 = 0.05f;
                            entityItem.motX = (float)this.random.nextGaussian() * f4;
                            entityItem.motY = (float)this.random.nextGaussian() * f4 + 0.2f;
                            entityItem.motZ = (float)this.random.nextGaussian() * f4;
                            this.world.addEntity(entityItem);
                        }
                    }
                    this.a(Block.CHEST.id, 1, 0.0f);
                } else if (this.type == 2) {
                    this.a(Block.FURNACE.id, 1, 0.0f);
                }
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean l_() {
        return !this.dead;
    }

    @Override
    public void die() {
        for (int i = 0; i < this.getSize(); ++i) {
            ItemStack itemStack = this.getItem(i);
            if (itemStack == null) continue;
            float f = this.random.nextFloat() * 0.8f + 0.1f;
            float f2 = this.random.nextFloat() * 0.8f + 0.1f;
            float f3 = this.random.nextFloat() * 0.8f + 0.1f;
            while (itemStack.count > 0) {
                int n = this.random.nextInt(21) + 10;
                if (n > itemStack.count) {
                    n = itemStack.count;
                }
                itemStack.count -= n;
                EntityItem entityItem = new EntityItem(this.world, this.locX + (double)f, this.locY + (double)f2, this.locZ + (double)f3, new ItemStack(itemStack.id, n, itemStack.getData()));
                float f4 = 0.05f;
                entityItem.motX = (float)this.random.nextGaussian() * f4;
                entityItem.motY = (float)this.random.nextGaussian() * f4 + 0.2f;
                entityItem.motZ = (float)this.random.nextGaussian() * f4;
                this.world.addEntity(entityItem);
            }
        }
        super.die();
    }

    @Override
    public void m_() {
        if (this.b > 0) {
            --this.b;
        }
        if (this.damage > 0) {
            --this.damage;
        }
        if (this.world.isStatic && this.k > 0) {
            if (this.k > 0) {
                double d;
                double d2 = this.locX + (this.l - this.locX) / (double)this.k;
                double d3 = this.locY + (this.m - this.locY) / (double)this.k;
                double d4 = this.locZ + (this.n - this.locZ) / (double)this.k;
                for (d = this.o - (double)this.yaw; d < -180.0; d += 360.0) {
                }
                while (d >= 180.0) {
                    d -= 360.0;
                }
                this.yaw = (float)((double)this.yaw + d / (double)this.k);
                this.pitch = (float)((double)this.pitch + (this.p - (double)this.pitch) / (double)this.k);
                --this.k;
                this.setPosition(d2, d3, d4);
                this.c(this.yaw, this.pitch);
            } else {
                this.setPosition(this.locX, this.locY, this.locZ);
                this.c(this.yaw, this.pitch);
            }
        } else {
            double d;
            int n;
            int n2;
            this.lastX = this.locX;
            this.lastY = this.locY;
            this.lastZ = this.locZ;
            this.motY -= (double)0.04f;
            int n3 = MathHelper.floor(this.locX);
            if (BlockMinecartTrack.g(this.world, n3, (n2 = MathHelper.floor(this.locY)) - 1, n = MathHelper.floor(this.locZ))) {
                --n2;
            }
            double d5 = 0.4;
            boolean bl = false;
            double d6 = 0.0078125;
            int n4 = this.world.getTypeId(n3, n2, n);
            if (BlockMinecartTrack.c(n4)) {
                double d7;
                double d8;
                double d9;
                double d10;
                double d11;
                Vec3D vec3D = this.h(this.locX, this.locY, this.locZ);
                int n5 = this.world.getData(n3, n2, n);
                this.locY = n2;
                boolean bl2 = false;
                boolean bl3 = false;
                if (n4 == Block.GOLDEN_RAIL.id) {
                    bl2 = (n5 & 8) != 0;
                    boolean bl4 = bl3 = !bl2;
                }
                if (((BlockMinecartTrack)Block.byId[n4]).e()) {
                    n5 &= 7;
                }
                if (n5 >= 2 && n5 <= 5) {
                    this.locY = n2 + 1;
                }
                if (n5 == 2) {
                    this.motX -= d6;
                }
                if (n5 == 3) {
                    this.motX += d6;
                }
                if (n5 == 4) {
                    this.motZ += d6;
                }
                if (n5 == 5) {
                    this.motZ -= d6;
                }
                int[][] nArray = matrix[n5];
                double d12 = nArray[1][0] - nArray[0][0];
                double d13 = nArray[1][2] - nArray[0][2];
                double d14 = Math.sqrt(d12 * d12 + d13 * d13);
                double d15 = this.motX * d12 + this.motZ * d13;
                if (d15 < 0.0) {
                    d12 = -d12;
                    d13 = -d13;
                }
                double d16 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
                this.motX = d16 * d12 / d14;
                this.motZ = d16 * d13 / d14;
                if (bl3) {
                    d11 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
                    if (d11 < 0.03) {
                        this.motX *= 0.0;
                        this.motY *= 0.0;
                        this.motZ *= 0.0;
                    } else {
                        this.motX *= 0.5;
                        this.motY *= 0.0;
                        this.motZ *= 0.5;
                    }
                }
                d11 = 0.0;
                double d17 = (double)n3 + 0.5 + (double)nArray[0][0] * 0.5;
                double d18 = (double)n + 0.5 + (double)nArray[0][2] * 0.5;
                double d19 = (double)n3 + 0.5 + (double)nArray[1][0] * 0.5;
                double d20 = (double)n + 0.5 + (double)nArray[1][2] * 0.5;
                d12 = d19 - d17;
                d13 = d20 - d18;
                if (d12 == 0.0) {
                    this.locX = (double)n3 + 0.5;
                    d11 = this.locZ - (double)n;
                } else if (d13 == 0.0) {
                    this.locZ = (double)n + 0.5;
                    d11 = this.locX - (double)n3;
                } else {
                    d10 = this.locX - d17;
                    d9 = this.locZ - d18;
                    d11 = d8 = (d10 * d12 + d9 * d13) * 2.0;
                }
                this.locX = d17 + d12 * d11;
                this.locZ = d18 + d13 * d11;
                this.setPosition(this.locX, this.locY + (double)this.height, this.locZ);
                d10 = this.motX;
                d9 = this.motZ;
                if (this.passenger != null) {
                    d10 *= 0.75;
                    d9 *= 0.75;
                }
                if (d10 < -d5) {
                    d10 = -d5;
                }
                if (d10 > d5) {
                    d10 = d5;
                }
                if (d9 < -d5) {
                    d9 = -d5;
                }
                if (d9 > d5) {
                    d9 = d5;
                }
                this.move(d10, 0.0, d9);
                if (nArray[0][1] != 0 && MathHelper.floor(this.locX) - n3 == nArray[0][0] && MathHelper.floor(this.locZ) - n == nArray[0][2]) {
                    this.setPosition(this.locX, this.locY + (double)nArray[0][1], this.locZ);
                } else if (nArray[1][1] != 0 && MathHelper.floor(this.locX) - n3 == nArray[1][0] && MathHelper.floor(this.locZ) - n == nArray[1][2]) {
                    this.setPosition(this.locX, this.locY + (double)nArray[1][1], this.locZ);
                }
                if (this.passenger != null) {
                    this.motX *= (double)0.997f;
                    this.motY *= 0.0;
                    this.motZ *= (double)0.997f;
                } else {
                    if (this.type == 2) {
                        d8 = MathHelper.a(this.f * this.f + this.g * this.g);
                        if (d8 > 0.01) {
                            bl = true;
                            this.f /= d8;
                            this.g /= d8;
                            double d21 = 0.04;
                            this.motX *= (double)0.8f;
                            this.motY *= 0.0;
                            this.motZ *= (double)0.8f;
                            this.motX += this.f * d21;
                            this.motZ += this.g * d21;
                        } else {
                            this.motX *= (double)0.9f;
                            this.motY *= 0.0;
                            this.motZ *= (double)0.9f;
                        }
                    }
                    this.motX *= (double)0.96f;
                    this.motY *= 0.0;
                    this.motZ *= (double)0.96f;
                }
                Vec3D vec3D2 = this.h(this.locX, this.locY, this.locZ);
                if (vec3D2 != null && vec3D != null) {
                    double d22 = (vec3D.b - vec3D2.b) * 0.05;
                    d16 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
                    if (d16 > 0.0) {
                        this.motX = this.motX / d16 * (d16 + d22);
                        this.motZ = this.motZ / d16 * (d16 + d22);
                    }
                    this.setPosition(this.locX, vec3D2.b, this.locZ);
                }
                int n6 = MathHelper.floor(this.locX);
                int n7 = MathHelper.floor(this.locZ);
                if (n6 != n3 || n7 != n) {
                    d16 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
                    this.motX = d16 * (double)(n6 - n3);
                    this.motZ = d16 * (double)(n7 - n);
                }
                if (this.type == 2 && (d7 = (double)MathHelper.a(this.f * this.f + this.g * this.g)) > 0.01 && this.motX * this.motX + this.motZ * this.motZ > 0.001) {
                    this.f /= d7;
                    this.g /= d7;
                    if (this.f * this.motX + this.g * this.motZ < 0.0) {
                        this.f = 0.0;
                        this.g = 0.0;
                    } else {
                        this.f = this.motX;
                        this.g = this.motZ;
                    }
                }
                if (bl2) {
                    d7 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
                    if (d7 > 0.01) {
                        double d23 = 0.06;
                        this.motX += this.motX / d7 * d23;
                        this.motZ += this.motZ / d7 * d23;
                    } else if (n5 == 1) {
                        if (this.world.e(n3 - 1, n2, n)) {
                            this.motX = 0.02;
                        } else if (this.world.e(n3 + 1, n2, n)) {
                            this.motX = -0.02;
                        }
                    } else if (n5 == 0) {
                        if (this.world.e(n3, n2, n - 1)) {
                            this.motZ = 0.02;
                        } else if (this.world.e(n3, n2, n + 1)) {
                            this.motZ = -0.02;
                        }
                    }
                }
            } else {
                if (this.motX < -d5) {
                    this.motX = -d5;
                }
                if (this.motX > d5) {
                    this.motX = d5;
                }
                if (this.motZ < -d5) {
                    this.motZ = -d5;
                }
                if (this.motZ > d5) {
                    this.motZ = d5;
                }
                if (this.onGround) {
                    this.motX *= 0.5;
                    this.motY *= 0.5;
                    this.motZ *= 0.5;
                }
                this.move(this.motX, this.motY, this.motZ);
                if (!this.onGround) {
                    this.motX *= (double)0.95f;
                    this.motY *= (double)0.95f;
                    this.motZ *= (double)0.95f;
                }
            }
            this.pitch = 0.0f;
            double d24 = this.lastX - this.locX;
            double d25 = this.lastZ - this.locZ;
            if (d24 * d24 + d25 * d25 > 0.001) {
                this.yaw = (float)(Math.atan2(d25, d24) * 180.0 / Math.PI);
                if (this.i) {
                    this.yaw += 180.0f;
                }
            }
            for (d = (double)(this.yaw - this.lastYaw); d >= 180.0; d -= 360.0) {
            }
            while (d < -180.0) {
                d += 360.0;
            }
            if (d < -170.0 || d >= 170.0) {
                this.yaw += 180.0f;
                this.i = !this.i;
            }
            this.c(this.yaw, this.pitch);
            List list = this.world.b(this, this.boundingBox.b(0.2f, 0.0, 0.2f));
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    Entity entity = (Entity)list.get(i);
                    if (entity == this.passenger || !entity.d_() || !(entity instanceof EntityMinecart)) continue;
                    entity.collide(this);
                }
            }
            if (this.passenger != null && this.passenger.dead) {
                this.passenger = null;
            }
            if (bl && this.random.nextInt(4) == 0) {
                --this.e;
                if (this.e < 0) {
                    this.g = 0.0;
                    this.f = 0.0;
                }
                this.world.a("largesmoke", this.locX, this.locY + 0.8, this.locZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public Vec3D h(double d, double d2, double d3) {
        int n;
        int n2;
        int n3;
        int n4 = MathHelper.floor(d);
        if (BlockMinecartTrack.g(this.world, n4, (n3 = MathHelper.floor(d2)) - 1, n2 = MathHelper.floor(d3))) {
            --n3;
        }
        if (BlockMinecartTrack.c(n = this.world.getTypeId(n4, n3, n2))) {
            int n5 = this.world.getData(n4, n3, n2);
            d2 = n3;
            if (((BlockMinecartTrack)Block.byId[n]).e()) {
                n5 &= 7;
            }
            if (n5 >= 2 && n5 <= 5) {
                d2 = n3 + 1;
            }
            int[][] nArray = matrix[n5];
            double d4 = 0.0;
            double d5 = (double)n4 + 0.5 + (double)nArray[0][0] * 0.5;
            double d6 = (double)n3 + 0.5 + (double)nArray[0][1] * 0.5;
            double d7 = (double)n2 + 0.5 + (double)nArray[0][2] * 0.5;
            double d8 = (double)n4 + 0.5 + (double)nArray[1][0] * 0.5;
            double d9 = (double)n3 + 0.5 + (double)nArray[1][1] * 0.5;
            double d10 = (double)n2 + 0.5 + (double)nArray[1][2] * 0.5;
            double d11 = d8 - d5;
            double d12 = (d9 - d6) * 2.0;
            double d13 = d10 - d7;
            if (d11 == 0.0) {
                d = (double)n4 + 0.5;
                d4 = d3 - (double)n2;
            } else if (d13 == 0.0) {
                d3 = (double)n2 + 0.5;
                d4 = d - (double)n4;
            } else {
                double d14;
                double d15 = d - d5;
                double d16 = d3 - d7;
                d4 = d14 = (d15 * d11 + d16 * d13) * 2.0;
            }
            d = d5 + d11 * d4;
            d2 = d6 + d12 * d4;
            d3 = d7 + d13 * d4;
            if (d12 < 0.0) {
                d2 += 1.0;
            }
            if (d12 > 0.0) {
                d2 += 0.5;
            }
            return Vec3D.create(d, d2, d3);
        }
        return null;
    }

    @Override
    protected void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.a("Type", this.type);
        if (this.type == 2) {
            nBTTagCompound.a("PushX", this.f);
            nBTTagCompound.a("PushZ", this.g);
            nBTTagCompound.a("Fuel", (short)this.e);
        } else if (this.type == 1) {
            NBTTagList nBTTagList = new NBTTagList();
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null) continue;
                NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
                nBTTagCompound2.a("Slot", (byte)i);
                this.items[i].a(nBTTagCompound2);
                nBTTagList.a(nBTTagCompound2);
            }
            nBTTagCompound.a("Items", nBTTagList);
        }
    }

    @Override
    protected void a(NBTTagCompound nBTTagCompound) {
        this.type = nBTTagCompound.e("Type");
        if (this.type == 2) {
            this.f = nBTTagCompound.h("PushX");
            this.g = nBTTagCompound.h("PushZ");
            this.e = nBTTagCompound.d("Fuel");
        } else if (this.type == 1) {
            NBTTagList nBTTagList = nBTTagCompound.l("Items");
            this.items = new ItemStack[this.getSize()];
            for (int i = 0; i < nBTTagList.c(); ++i) {
                NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagList.a(i);
                int n = nBTTagCompound2.c("Slot") & 0xFF;
                if (n < 0 || n >= this.items.length) continue;
                this.items[n] = new ItemStack(nBTTagCompound2);
            }
        }
    }

    @Override
    public void collide(Entity entity) {
        if (!this.world.isStatic && entity != this.passenger) {
            double d;
            double d2;
            double d3;
            if (entity instanceof EntityLiving && !(entity instanceof EntityHuman) && this.type == 0 && this.motX * this.motX + this.motZ * this.motZ > 0.01 && this.passenger == null && entity.vehicle == null) {
                entity.mount(this);
            }
            if ((d3 = (d2 = entity.locX - this.locX) * d2 + (d = entity.locZ - this.locZ) * d) >= (double)1.0E-4f) {
                d3 = MathHelper.a(d3);
                d2 /= d3;
                d /= d3;
                double d4 = 1.0 / d3;
                if (d4 > 1.0) {
                    d4 = 1.0;
                }
                d2 *= d4;
                d *= d4;
                d2 *= (double)0.1f;
                d *= (double)0.1f;
                d2 *= (double)(1.0f - this.bu);
                d *= (double)(1.0f - this.bu);
                d2 *= 0.5;
                d *= 0.5;
                if (entity instanceof EntityMinecart) {
                    double d5 = entity.locX - this.locX;
                    double d6 = entity.locZ - this.locZ;
                    double d7 = d5 * entity.motZ + d6 * entity.lastX;
                    if ((d7 *= d7) > 5.0) {
                        return;
                    }
                    double d8 = entity.motX + this.motX;
                    double d9 = entity.motZ + this.motZ;
                    if (((EntityMinecart)entity).type == 2 && this.type != 2) {
                        this.motX *= (double)0.2f;
                        this.motZ *= (double)0.2f;
                        this.f(entity.motX - d2, 0.0, entity.motZ - d);
                        entity.motX *= (double)0.7f;
                        entity.motZ *= (double)0.7f;
                    } else if (((EntityMinecart)entity).type != 2 && this.type == 2) {
                        entity.motX *= (double)0.2f;
                        entity.motZ *= (double)0.2f;
                        entity.f(this.motX + d2, 0.0, this.motZ + d);
                        this.motX *= (double)0.7f;
                        this.motZ *= (double)0.7f;
                    } else {
                        this.motX *= (double)0.2f;
                        this.motZ *= (double)0.2f;
                        this.f((d8 /= 2.0) - d2, 0.0, (d9 /= 2.0) - d);
                        entity.motX *= (double)0.2f;
                        entity.motZ *= (double)0.2f;
                        entity.f(d8 + d2, 0.0, d9 + d);
                    }
                } else {
                    this.f(-d2, 0.0, -d);
                    entity.f(d2 / 4.0, 0.0, d / 4.0);
                }
            }
        }
    }

    @Override
    public int getSize() {
        return 27;
    }

    @Override
    public ItemStack getItem(int n) {
        return this.items[n];
    }

    @Override
    public ItemStack splitStack(int n, int n2) {
        if (this.items[n] != null) {
            if (this.items[n].count <= n2) {
                ItemStack itemStack = this.items[n];
                this.items[n] = null;
                return itemStack;
            }
            ItemStack itemStack = this.items[n].a(n2);
            if (this.items[n].count == 0) {
                this.items[n] = null;
            }
            return itemStack;
        }
        return null;
    }

    @Override
    public void setItem(int n, ItemStack itemStack) {
        this.items[n] = itemStack;
        if (itemStack != null && itemStack.count > this.getMaxStackSize()) {
            itemStack.count = this.getMaxStackSize();
        }
    }

    @Override
    public String getName() {
        return "Minecart";
    }

    @Override
    public int getMaxStackSize() {
        return 64;
    }

    @Override
    public void update() {
    }

    @Override
    public boolean a(EntityHuman entityHuman) {
        if (this.type == 0) {
            if (this.passenger != null && this.passenger instanceof EntityHuman && this.passenger != entityHuman) {
                return true;
            }
            if (!this.world.isStatic) {
                entityHuman.mount(this);
            }
        } else if (this.type == 1) {
            if (!this.world.isStatic) {
                entityHuman.a(this);
            }
        } else if (this.type == 2) {
            ItemStack itemStack = entityHuman.inventory.getItemInHand();
            if (itemStack != null && itemStack.id == Item.COAL.id) {
                if (--itemStack.count == 0) {
                    entityHuman.inventory.setItem(entityHuman.inventory.itemInHandIndex, null);
                }
                this.e += 1200;
            }
            this.f = this.locX - entityHuman.locX;
            this.g = this.locZ - entityHuman.locZ;
        }
        return true;
    }

    @Override
    public boolean a_(EntityHuman entityHuman) {
        return this.dead ? false : entityHuman.g(this) <= 64.0;
    }
}

