/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Entity;
import net.minecraft.server.EntityMonster;
import net.minecraft.server.EntitySkeleton;
import net.minecraft.server.EntityWeatherStorm;
import net.minecraft.server.Item;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityCreeper
extends EntityMonster {
    int fuseTicks;
    int b;

    public EntityCreeper(World world) {
        super(world);
        this.texture = "/mob/creeper.png";
    }

    @Override
    protected void b() {
        super.b();
        this.datawatcher.a(16, (byte)-1);
        this.datawatcher.a(17, (byte)0);
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        if (this.datawatcher.a(17) == 1) {
            nBTTagCompound.a("powered", true);
        }
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.datawatcher.watch(17, (byte)(nBTTagCompound.m("powered") ? 1 : 0));
    }

    @Override
    protected void b(Entity entity, float f) {
        if (!this.world.isStatic && this.fuseTicks > 0) {
            this.e(-1);
            --this.fuseTicks;
            if (this.fuseTicks < 0) {
                this.fuseTicks = 0;
            }
        }
    }

    @Override
    public void m_() {
        this.b = this.fuseTicks;
        if (this.world.isStatic) {
            int n = this.x();
            if (n > 0 && this.fuseTicks == 0) {
                this.world.makeSound(this, "random.fuse", 1.0f, 0.5f);
            }
            this.fuseTicks += n;
            if (this.fuseTicks < 0) {
                this.fuseTicks = 0;
            }
            if (this.fuseTicks >= 30) {
                this.fuseTicks = 30;
            }
        }
        super.m_();
        if (this.target == null && this.fuseTicks > 0) {
            this.e(-1);
            --this.fuseTicks;
            if (this.fuseTicks < 0) {
                this.fuseTicks = 0;
            }
        }
    }

    @Override
    protected String h() {
        return "mob.creeper";
    }

    @Override
    protected String i() {
        return "mob.creeperdeath";
    }

    @Override
    public void die(Entity entity) {
        super.die(entity);
        if (entity instanceof EntitySkeleton) {
            this.b(Item.GOLD_RECORD.id + this.random.nextInt(2), 1);
        }
    }

    @Override
    protected void a(Entity entity, float f) {
        if (!this.world.isStatic) {
            int n = this.x();
            if ((n > 0 || f >= 3.0f) && (n <= 0 || f >= 7.0f)) {
                this.e(-1);
                --this.fuseTicks;
                if (this.fuseTicks < 0) {
                    this.fuseTicks = 0;
                }
            } else {
                if (this.fuseTicks == 0) {
                    this.world.makeSound(this, "random.fuse", 1.0f, 0.5f);
                }
                this.e(1);
                ++this.fuseTicks;
                if (this.fuseTicks >= 30) {
                    if (this.isPowered()) {
                        this.world.a((Entity)this, this.locX, this.locY, this.locZ, 6.0f);
                    } else {
                        this.world.a((Entity)this, this.locX, this.locY, this.locZ, 3.0f);
                    }
                    this.die();
                }
                this.e = true;
            }
        }
    }

    public boolean isPowered() {
        return this.datawatcher.a(17) == 1;
    }

    @Override
    protected int j() {
        return Item.SULPHUR.id;
    }

    private int x() {
        return this.datawatcher.a(16);
    }

    private void e(int n) {
        this.datawatcher.watch(16, (byte)n);
    }

    @Override
    public void a(EntityWeatherStorm entityWeatherStorm) {
        super.a(entityWeatherStorm);
        this.datawatcher.watch(17, (byte)1);
    }
}

