/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.List;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MathHelper;
import net.minecraft.server.MovingObjectPosition;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public class EntityArrow
extends Entity {
    private int d = -1;
    private int e = -1;
    private int f = -1;
    private int g = 0;
    private int h = 0;
    private boolean inGround = false;
    public boolean fromPlayer = false;
    public int shake = 0;
    public EntityLiving shooter;
    private int j;
    private int k = 0;

    public EntityArrow(World world) {
        super(world);
        this.b(0.5f, 0.5f);
    }

    public EntityArrow(World world, double d, double d2, double d3) {
        super(world);
        this.b(0.5f, 0.5f);
        this.setPosition(d, d2, d3);
        this.height = 0.0f;
    }

    public EntityArrow(World world, EntityLiving entityLiving) {
        super(world);
        this.shooter = entityLiving;
        this.fromPlayer = entityLiving instanceof EntityHuman;
        this.b(0.5f, 0.5f);
        this.setPositionRotation(entityLiving.locX, entityLiving.locY + (double)entityLiving.t(), entityLiving.locZ, entityLiving.yaw, entityLiving.pitch);
        this.locX -= (double)(MathHelper.cos(this.yaw / 180.0f * (float)Math.PI) * 0.16f);
        this.locY -= (double)0.1f;
        this.locZ -= (double)(MathHelper.sin(this.yaw / 180.0f * (float)Math.PI) * 0.16f);
        this.setPosition(this.locX, this.locY, this.locZ);
        this.height = 0.0f;
        this.motX = -MathHelper.sin(this.yaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.pitch / 180.0f * (float)Math.PI);
        this.motZ = MathHelper.cos(this.yaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.pitch / 180.0f * (float)Math.PI);
        this.motY = -MathHelper.sin(this.pitch / 180.0f * (float)Math.PI);
        this.a(this.motX, this.motY, this.motZ, 1.5f, 1.0f);
    }

    @Override
    protected void b() {
    }

    public void a(double d, double d2, double d3, float f, float f2) {
        float f3 = MathHelper.a(d * d + d2 * d2 + d3 * d3);
        d /= (double)f3;
        d2 /= (double)f3;
        d3 /= (double)f3;
        d += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        d2 += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        d3 += this.random.nextGaussian() * (double)0.0075f * (double)f2;
        this.motX = d *= (double)f;
        this.motY = d2 *= (double)f;
        this.motZ = d3 *= (double)f;
        float f4 = MathHelper.a(d * d + d3 * d3);
        this.lastYaw = this.yaw = (float)(Math.atan2(d, d3) * 180.0 / 3.1415927410125732);
        this.lastPitch = this.pitch = (float)(Math.atan2(d2, f4) * 180.0 / 3.1415927410125732);
        this.j = 0;
    }

    @Override
    public void m_() {
        Object object;
        int n;
        super.m_();
        if (this.lastPitch == 0.0f && this.lastYaw == 0.0f) {
            float f = MathHelper.a(this.motX * this.motX + this.motZ * this.motZ);
            this.lastYaw = this.yaw = (float)(Math.atan2(this.motX, this.motZ) * 180.0 / 3.1415927410125732);
            this.lastPitch = this.pitch = (float)(Math.atan2(this.motY, f) * 180.0 / 3.1415927410125732);
        }
        if ((n = this.world.getTypeId(this.d, this.e, this.f)) > 0) {
            Block.byId[n].a(this.world, this.d, this.e, this.f);
            object = Block.byId[n].d(this.world, this.d, this.e, this.f);
            if (object != null && ((AxisAlignedBB)object).a(Vec3D.create(this.locX, this.locY, this.locZ))) {
                this.inGround = true;
            }
        }
        if (this.shake > 0) {
            --this.shake;
        }
        if (this.inGround) {
            n = this.world.getTypeId(this.d, this.e, this.f);
            int n2 = this.world.getData(this.d, this.e, this.f);
            if (n == this.g && n2 == this.h) {
                ++this.j;
                if (this.j == 1200) {
                    this.die();
                }
            } else {
                this.inGround = false;
                this.motX *= (double)(this.random.nextFloat() * 0.2f);
                this.motY *= (double)(this.random.nextFloat() * 0.2f);
                this.motZ *= (double)(this.random.nextFloat() * 0.2f);
                this.j = 0;
                this.k = 0;
            }
        } else {
            float f;
            ++this.k;
            object = Vec3D.create(this.locX, this.locY, this.locZ);
            Vec3D vec3D = Vec3D.create(this.locX + this.motX, this.locY + this.motY, this.locZ + this.motZ);
            MovingObjectPosition movingObjectPosition = this.world.rayTrace((Vec3D)object, vec3D, false, true);
            object = Vec3D.create(this.locX, this.locY, this.locZ);
            vec3D = Vec3D.create(this.locX + this.motX, this.locY + this.motY, this.locZ + this.motZ);
            if (movingObjectPosition != null) {
                vec3D = Vec3D.create(movingObjectPosition.f.a, movingObjectPosition.f.b, movingObjectPosition.f.c);
            }
            Entity entity = null;
            List list = this.world.b(this, this.boundingBox.a(this.motX, this.motY, this.motZ).b(1.0, 1.0, 1.0));
            double d = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double d2;
                AxisAlignedBB axisAlignedBB;
                MovingObjectPosition movingObjectPosition2;
                Entity entity2 = (Entity)list.get(i);
                if (!entity2.l_() || entity2 == this.shooter && this.k < 5 || (movingObjectPosition2 = (axisAlignedBB = entity2.boundingBox.b(f = 0.3f, f, f)).a((Vec3D)object, vec3D)) == null || !((d2 = ((Vec3D)object).a(movingObjectPosition2.f)) < d) && d != 0.0) continue;
                entity = entity2;
                d = d2;
            }
            if (entity != null) {
                movingObjectPosition = new MovingObjectPosition(entity);
            }
            if (movingObjectPosition != null) {
                if (movingObjectPosition.entity != null) {
                    if (movingObjectPosition.entity.damageEntity(this.shooter, 4)) {
                        this.world.makeSound(this, "random.drr", 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
                        this.die();
                    } else {
                        this.motX *= (double)-0.1f;
                        this.motY *= (double)-0.1f;
                        this.motZ *= (double)-0.1f;
                        this.yaw += 180.0f;
                        this.lastYaw += 180.0f;
                        this.k = 0;
                    }
                } else {
                    this.d = movingObjectPosition.b;
                    this.e = movingObjectPosition.c;
                    this.f = movingObjectPosition.d;
                    this.g = this.world.getTypeId(this.d, this.e, this.f);
                    this.h = this.world.getData(this.d, this.e, this.f);
                    this.motX = (float)(movingObjectPosition.f.a - this.locX);
                    this.motY = (float)(movingObjectPosition.f.b - this.locY);
                    this.motZ = (float)(movingObjectPosition.f.c - this.locZ);
                    float f2 = MathHelper.a(this.motX * this.motX + this.motY * this.motY + this.motZ * this.motZ);
                    this.locX -= this.motX / (double)f2 * (double)0.05f;
                    this.locY -= this.motY / (double)f2 * (double)0.05f;
                    this.locZ -= this.motZ / (double)f2 * (double)0.05f;
                    this.world.makeSound(this, "random.drr", 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
                    this.inGround = true;
                    this.shake = 7;
                }
            }
            this.locX += this.motX;
            this.locY += this.motY;
            this.locZ += this.motZ;
            float f3 = MathHelper.a(this.motX * this.motX + this.motZ * this.motZ);
            this.yaw = (float)(Math.atan2(this.motX, this.motZ) * 180.0 / 3.1415927410125732);
            this.pitch = (float)(Math.atan2(this.motY, f3) * 180.0 / 3.1415927410125732);
            while (this.pitch - this.lastPitch < -180.0f) {
                this.lastPitch -= 360.0f;
            }
            while (this.pitch - this.lastPitch >= 180.0f) {
                this.lastPitch += 360.0f;
            }
            while (this.yaw - this.lastYaw < -180.0f) {
                this.lastYaw -= 360.0f;
            }
            while (this.yaw - this.lastYaw >= 180.0f) {
                this.lastYaw += 360.0f;
            }
            this.pitch = this.lastPitch + (this.pitch - this.lastPitch) * 0.2f;
            this.yaw = this.lastYaw + (this.yaw - this.lastYaw) * 0.2f;
            float f4 = 0.99f;
            f = 0.03f;
            if (this.ad()) {
                for (int i = 0; i < 4; ++i) {
                    float f5 = 0.25f;
                    this.world.a("bubble", this.locX - this.motX * (double)f5, this.locY - this.motY * (double)f5, this.locZ - this.motZ * (double)f5, this.motX, this.motY, this.motZ);
                }
                f4 = 0.8f;
            }
            this.motX *= (double)f4;
            this.motY *= (double)f4;
            this.motZ *= (double)f4;
            this.motY -= (double)f;
            this.setPosition(this.locX, this.locY, this.locZ);
        }
    }

    @Override
    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.a("xTile", (short)this.d);
        nBTTagCompound.a("yTile", (short)this.e);
        nBTTagCompound.a("zTile", (short)this.f);
        nBTTagCompound.a("inTile", (byte)this.g);
        nBTTagCompound.a("inData", (byte)this.h);
        nBTTagCompound.a("shake", (byte)this.shake);
        nBTTagCompound.a("inGround", (byte)(this.inGround ? 1 : 0));
        nBTTagCompound.a("player", this.fromPlayer);
    }

    @Override
    public void a(NBTTagCompound nBTTagCompound) {
        this.d = nBTTagCompound.d("xTile");
        this.e = nBTTagCompound.d("yTile");
        this.f = nBTTagCompound.d("zTile");
        this.g = nBTTagCompound.c("inTile") & 0xFF;
        this.h = nBTTagCompound.c("inData") & 0xFF;
        this.shake = nBTTagCompound.c("shake") & 0xFF;
        this.inGround = nBTTagCompound.c("inGround") == 1;
        this.fromPlayer = nBTTagCompound.m("player");
    }

    @Override
    public void b(EntityHuman entityHuman) {
        if (!this.world.isStatic && this.inGround && this.fromPlayer && this.shake <= 0 && entityHuman.inventory.pickup(new ItemStack(Item.ARROW, 1))) {
            this.world.makeSound(this, "random.pop", 0.2f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityHuman.receive(this, 1);
            this.die();
        }
    }
}

