/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Set;
import java.util.logging.Logger;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.ICommandListener;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Packet3Chat;
import net.minecraft.server.ServerCommand;
import net.minecraft.server.ServerConfigurationManager;
import net.minecraft.server.WorldServer;

public class ConsoleCommandHandler {
    private static Logger a = Logger.getLogger("Minecraft");
    private MinecraftServer server;

    public ConsoleCommandHandler(MinecraftServer minecraftServer) {
        this.server = minecraftServer;
    }

    public void handle(ServerCommand serverCommand) {
        block72: {
            String string = serverCommand.command;
            ICommandListener iCommandListener = serverCommand.b;
            String string2 = iCommandListener.getName();
            ServerConfigurationManager serverConfigurationManager = this.server.serverConfigurationManager;
            if (!string.toLowerCase().startsWith("help") && !string.toLowerCase().startsWith("?")) {
                if (string.toLowerCase().startsWith("list")) {
                    iCommandListener.sendMessage("Connected players: " + serverConfigurationManager.c());
                } else if (string.toLowerCase().startsWith("stop")) {
                    this.print(string2, "Stopping the server..");
                    this.server.a();
                } else if (string.toLowerCase().startsWith("save-all")) {
                    this.print(string2, "Forcing save..");
                    if (serverConfigurationManager != null) {
                        serverConfigurationManager.savePlayers();
                    }
                    for (int i = 0; i < this.server.worldServer.length; ++i) {
                        WorldServer worldServer = this.server.worldServer[i];
                        worldServer.save(true, null);
                    }
                    this.print(string2, "Save complete.");
                } else if (string.toLowerCase().startsWith("save-off")) {
                    this.print(string2, "Disabling level saving..");
                    for (int i = 0; i < this.server.worldServer.length; ++i) {
                        WorldServer worldServer = this.server.worldServer[i];
                        worldServer.canSave = true;
                    }
                } else if (string.toLowerCase().startsWith("save-on")) {
                    this.print(string2, "Enabling level saving..");
                    for (int i = 0; i < this.server.worldServer.length; ++i) {
                        WorldServer worldServer = this.server.worldServer[i];
                        worldServer.canSave = false;
                    }
                } else if (string.toLowerCase().startsWith("op ")) {
                    String string3 = string.substring(string.indexOf(" ")).trim();
                    serverConfigurationManager.e(string3);
                    this.print(string2, "Opping " + string3);
                    serverConfigurationManager.a(string3, "\u00a7eYou are now op!");
                } else if (string.toLowerCase().startsWith("deop ")) {
                    String string4 = string.substring(string.indexOf(" ")).trim();
                    serverConfigurationManager.f(string4);
                    serverConfigurationManager.a(string4, "\u00a7eYou are no longer op!");
                    this.print(string2, "De-opping " + string4);
                } else if (string.toLowerCase().startsWith("ban-ip ")) {
                    String string5 = string.substring(string.indexOf(" ")).trim();
                    serverConfigurationManager.c(string5);
                    this.print(string2, "Banning ip " + string5);
                } else if (string.toLowerCase().startsWith("pardon-ip ")) {
                    String string6 = string.substring(string.indexOf(" ")).trim();
                    serverConfigurationManager.d(string6);
                    this.print(string2, "Pardoning ip " + string6);
                } else if (string.toLowerCase().startsWith("ban ")) {
                    String string7 = string.substring(string.indexOf(" ")).trim();
                    serverConfigurationManager.a(string7);
                    this.print(string2, "Banning " + string7);
                    EntityPlayer entityPlayer = serverConfigurationManager.i(string7);
                    if (entityPlayer != null) {
                        entityPlayer.netServerHandler.disconnect("Banned by admin");
                    }
                } else if (string.toLowerCase().startsWith("pardon ")) {
                    String string8 = string.substring(string.indexOf(" ")).trim();
                    serverConfigurationManager.b(string8);
                    this.print(string2, "Pardoning " + string8);
                } else if (string.toLowerCase().startsWith("kick ")) {
                    String string9 = string.substring(string.indexOf(" ")).trim();
                    EntityPlayer entityPlayer = null;
                    for (int i = 0; i < serverConfigurationManager.players.size(); ++i) {
                        EntityPlayer entityPlayer2 = (EntityPlayer)serverConfigurationManager.players.get(i);
                        if (!entityPlayer2.name.equalsIgnoreCase(string9)) continue;
                        entityPlayer = entityPlayer2;
                    }
                    if (entityPlayer != null) {
                        entityPlayer.netServerHandler.disconnect("Kicked by admin");
                        this.print(string2, "Kicking " + entityPlayer.name);
                    } else {
                        iCommandListener.sendMessage("Can't find user " + string9 + ". No kick.");
                    }
                } else if (string.toLowerCase().startsWith("tp ")) {
                    String[] stringArray = string.split(" ");
                    if (stringArray.length == 3) {
                        EntityPlayer entityPlayer = serverConfigurationManager.i(stringArray[1]);
                        EntityPlayer entityPlayer3 = serverConfigurationManager.i(stringArray[2]);
                        if (entityPlayer == null) {
                            iCommandListener.sendMessage("Can't find user " + stringArray[1] + ". No tp.");
                        } else if (entityPlayer3 == null) {
                            iCommandListener.sendMessage("Can't find user " + stringArray[2] + ". No tp.");
                        } else if (entityPlayer.dimension != entityPlayer3.dimension) {
                            iCommandListener.sendMessage("User " + stringArray[1] + " and " + stringArray[2] + " are in different dimensions. No tp.");
                        } else {
                            entityPlayer.netServerHandler.a(entityPlayer3.locX, entityPlayer3.locY, entityPlayer3.locZ, entityPlayer3.yaw, entityPlayer3.pitch);
                            this.print(string2, "Teleporting " + stringArray[1] + " to " + stringArray[2] + ".");
                        }
                    } else {
                        iCommandListener.sendMessage("Syntax error, please provice a source and a target.");
                    }
                } else if (string.toLowerCase().startsWith("give ")) {
                    String[] stringArray = string.split(" ");
                    if (stringArray.length != 3 && stringArray.length != 4) {
                        return;
                    }
                    String string10 = stringArray[1];
                    EntityPlayer entityPlayer = serverConfigurationManager.i(string10);
                    if (entityPlayer != null) {
                        try {
                            int n = Integer.parseInt(stringArray[2]);
                            if (Item.byId[n] != null) {
                                this.print(string2, "Giving " + entityPlayer.name + " some " + n);
                                int n2 = 1;
                                if (stringArray.length > 3) {
                                    n2 = this.a(stringArray[3], 1);
                                }
                                if (n2 < 1) {
                                    n2 = 1;
                                }
                                if (n2 > 64) {
                                    n2 = 64;
                                }
                                entityPlayer.b(new ItemStack(n, n2, 0));
                                break block72;
                            }
                            iCommandListener.sendMessage("There's no item with id " + n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            iCommandListener.sendMessage("There's no item with id " + stringArray[2]);
                        }
                    } else {
                        iCommandListener.sendMessage("Can't find user " + string10);
                    }
                } else if (string.toLowerCase().startsWith("time ")) {
                    String[] stringArray = string.split(" ");
                    if (stringArray.length != 3) {
                        return;
                    }
                    String string11 = stringArray[1];
                    try {
                        int n = Integer.parseInt(stringArray[2]);
                        if ("add".equalsIgnoreCase(string11)) {
                            for (int i = 0; i < this.server.worldServer.length; ++i) {
                                WorldServer worldServer = this.server.worldServer[i];
                                worldServer.setTime(worldServer.getTime() + (long)n);
                            }
                            this.print(string2, "Added " + n + " to time");
                            break block72;
                        }
                        if ("set".equalsIgnoreCase(string11)) {
                            for (int i = 0; i < this.server.worldServer.length; ++i) {
                                WorldServer worldServer = this.server.worldServer[i];
                                worldServer.setTime(n);
                            }
                            this.print(string2, "Set time to " + n);
                            break block72;
                        }
                        iCommandListener.sendMessage("Unknown method, use either \"add\" or \"set\"");
                    }
                    catch (NumberFormatException numberFormatException) {
                        iCommandListener.sendMessage("Unable to convert time value, " + stringArray[2]);
                    }
                } else if (string.toLowerCase().startsWith("say ")) {
                    string = string.substring(string.indexOf(" ")).trim();
                    a.info("[" + string2 + "] " + string);
                    serverConfigurationManager.sendAll(new Packet3Chat("\u00a7d[Server] " + string));
                } else if (string.toLowerCase().startsWith("tell ")) {
                    String[] stringArray = string.split(" ");
                    if (stringArray.length >= 3) {
                        string = string.substring(string.indexOf(" ")).trim();
                        string = string.substring(string.indexOf(" ")).trim();
                        a.info("[" + string2 + "->" + stringArray[1] + "] " + string);
                        string = "\u00a77" + string2 + " whispers " + string;
                        a.info(string);
                        if (!serverConfigurationManager.a(stringArray[1], new Packet3Chat(string))) {
                            iCommandListener.sendMessage("There's no player by that name online.");
                        }
                    }
                } else if (string.toLowerCase().startsWith("whitelist ")) {
                    this.a(string2, string, iCommandListener);
                } else {
                    a.info("Unknown console command. Type \"help\" for help.");
                }
            } else {
                this.a(iCommandListener);
            }
        }
    }

    private void a(String string, String string2, ICommandListener iCommandListener) {
        String[] stringArray = string2.split(" ");
        if (stringArray.length >= 2) {
            String string3 = stringArray[1].toLowerCase();
            if ("on".equals(string3)) {
                this.print(string, "Turned on white-listing");
                this.server.propertyManager.b("white-list", true);
            } else if ("off".equals(string3)) {
                this.print(string, "Turned off white-listing");
                this.server.propertyManager.b("white-list", false);
            } else if ("list".equals(string3)) {
                Set set = this.server.serverConfigurationManager.e();
                String string4 = "";
                for (String string5 : set) {
                    string4 = string4 + string5 + " ";
                }
                iCommandListener.sendMessage("White-listed players: " + string4);
            } else if ("add".equals(string3) && stringArray.length == 3) {
                String string6 = stringArray[2].toLowerCase();
                this.server.serverConfigurationManager.k(string6);
                this.print(string, "Added " + string6 + " to white-list");
            } else if ("remove".equals(string3) && stringArray.length == 3) {
                String string7 = stringArray[2].toLowerCase();
                this.server.serverConfigurationManager.l(string7);
                this.print(string, "Removed " + string7 + " from white-list");
            } else if ("reload".equals(string3)) {
                this.server.serverConfigurationManager.f();
                this.print(string, "Reloaded white-list from file");
            }
        }
    }

    private void a(ICommandListener iCommandListener) {
        iCommandListener.sendMessage("To run the server without a gui, start it like this:");
        iCommandListener.sendMessage("   java -Xmx1024M -Xms1024M -jar minecraft_server.jar nogui");
        iCommandListener.sendMessage("Console commands:");
        iCommandListener.sendMessage("   help  or  ?               shows this message");
        iCommandListener.sendMessage("   kick <player>             removes a player from the server");
        iCommandListener.sendMessage("   ban <player>              bans a player from the server");
        iCommandListener.sendMessage("   pardon <player>           pardons a banned player so that they can connect again");
        iCommandListener.sendMessage("   ban-ip <ip>               bans an IP address from the server");
        iCommandListener.sendMessage("   pardon-ip <ip>            pardons a banned IP address so that they can connect again");
        iCommandListener.sendMessage("   op <player>               turns a player into an op");
        iCommandListener.sendMessage("   deop <player>             removes op status from a player");
        iCommandListener.sendMessage("   tp <player1> <player2>    moves one player to the same location as another player");
        iCommandListener.sendMessage("   give <player> <id> [num]  gives a player a resource");
        iCommandListener.sendMessage("   tell <player> <message>   sends a private message to a player");
        iCommandListener.sendMessage("   stop                      gracefully stops the server");
        iCommandListener.sendMessage("   save-all                  forces a server-wide level save");
        iCommandListener.sendMessage("   save-off                  disables terrain saving (useful for backup scripts)");
        iCommandListener.sendMessage("   save-on                   re-enables terrain saving");
        iCommandListener.sendMessage("   list                      lists all currently connected players");
        iCommandListener.sendMessage("   say <message>             broadcasts a message to all players");
        iCommandListener.sendMessage("   time <add|set> <amount>   adds to or sets the world time (0-24000)");
    }

    private void print(String string, String string2) {
        String string3 = string + ": " + string2;
        this.server.serverConfigurationManager.j("\u00a77(" + string3 + ")");
        a.info(string3);
    }

    private int a(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }
}

